/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.plan.ConditionalResolver;

public class ConditionalResolverSkewJoin
implements ConditionalResolver,
Serializable {
    private static final long serialVersionUID = 1L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public List<Task<? extends Serializable>> getTasks(HiveConf conf, Object objCtx) {
        ConditionalResolverSkewJoinCtx ctx = (ConditionalResolverSkewJoinCtx)objCtx;
        ArrayList<Task<? extends Serializable>> resTsks = new ArrayList<Task<? extends Serializable>>();
        HashMap<String, Task<? extends Serializable>> dirToTaskMap = ctx.getDirToTaskMap();
        Iterator bigKeysPathsIter = dirToTaskMap.entrySet().iterator();
        try {
            block2: while (bigKeysPathsIter.hasNext()) {
                Map.Entry entry = bigKeysPathsIter.next();
                String path = (String)entry.getKey();
                Path dirPath = new Path(path);
                FileSystem inpFs = dirPath.getFileSystem((Configuration)conf);
                FileStatus[] fstatus = inpFs.listStatus(dirPath);
                if (fstatus == null || fstatus.length <= 0) continue;
                Task task = (Task)entry.getValue();
                List<Task<Serializable>> parentOps = task.getParentTasks();
                if (parentOps != null) {
                    Iterator<Task<Serializable>> i$ = parentOps.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block2;
                        Task<Serializable> parentOp = i$.next();
                        resTsks.add(parentOp);
                    }
                }
                resTsks.add(task);
            }
            return resTsks;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resTsks;
    }

    public static class ConditionalResolverSkewJoinCtx
    implements Serializable {
        private static final long serialVersionUID = 1L;
        HashMap<String, Task<? extends Serializable>> dirToTaskMap;

        public ConditionalResolverSkewJoinCtx() {
        }

        public ConditionalResolverSkewJoinCtx(HashMap<String, Task<? extends Serializable>> dirToTaskMap) {
            this.dirToTaskMap = dirToTaskMap;
        }

        public HashMap<String, Task<? extends Serializable>> getDirToTaskMap() {
            return this.dirToTaskMap;
        }

        public void setDirToTaskMap(HashMap<String, Task<? extends Serializable>> dirToTaskMap) {
            this.dirToTaskMap = dirToTaskMap;
        }
    }
}

