/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.SessionState;

public class VariableSubstitution {
    private static final Log l4j = LogFactory.getLog(VariableSubstitution.class);
    protected static Pattern varPat = Pattern.compile("\\$\\{[^\\}\\$ ]+\\}");
    protected static int MAX_SUBST = 40;

    private String getSubstitute(HiveConf conf, String var) {
        String val = null;
        try {
            if (var.startsWith("system:")) {
                val = System.getProperty(var.substring("system:".length()));
            }
        }
        catch (SecurityException se) {
            l4j.warn((Object)"Unexpected SecurityException in Configuration", (Throwable)se);
        }
        if (val == null && var.startsWith("env:")) {
            val = System.getenv(var.substring("env:".length()));
        }
        if (val == null && var.startsWith("hiveconf:")) {
            val = conf.get(var.substring("hiveconf:".length()));
        }
        if (val == null) {
            val = var.startsWith("hivevar:") ? SessionState.get().getHiveVariables().get(var.substring("hivevar:".length())) : SessionState.get().getHiveVariables().get(var);
        }
        return val;
    }

    public String substitute(HiveConf conf, String expr) {
        if (!conf.getBoolVar(HiveConf.ConfVars.HIVEVARIABLESUBSTITUTE)) {
            return expr;
        }
        l4j.debug((Object)("Substitution is on: " + expr));
        if (expr == null) {
            return null;
        }
        Matcher match = varPat.matcher("");
        String eval = expr;
        for (int s = 0; s < MAX_SUBST; ++s) {
            match.reset(eval);
            if (!match.find()) {
                return eval;
            }
            String var = match.group();
            String val = this.getSubstitute(conf, var = var.substring(2, var.length() - 1));
            if (val == null) {
                l4j.debug((Object)("Interpolation result: " + eval));
                return eval;
            }
            eval = eval.substring(0, match.start()) + val + eval.substring(match.end());
        }
        throw new IllegalStateException("Variable substitution depth too large: " + MAX_SUBST + " " + expr);
    }
}

