/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakPropertyChangeSupport;

public class AnnotationTypes {
    public static final String PROP_BACKGROUND_DRAWING = "backgroundDrawing";
    public static final String PROP_BACKGROUND_GLYPH_ALPHA = "backgroundGlyphAlpha";
    public static final String PROP_COMBINE_GLYPHS = "combineGlyphs";
    public static final String PROP_GLYPHS_OVER_LINE_NUMBERS = "glyphsOverLineNumbers";
    public static final String PROP_SHOW_GLYPH_GUTTER = "showGlyphGutter";
    public static final String PROP_ANNOTATION_TYPES = "annotationTypes";
    private Map properties = new HashMap(6);
    private WeakPropertyChangeSupport support = new WeakPropertyChangeSupport();
    private Map allTypes = null;
    private boolean loadedTypes = false;
    private boolean loadedSettings = false;
    private boolean loadingInProgress = false;
    private Loader loader = null;
    private static URL defaultGlyphIcon = null;
    private static AnnotationTypes annoTypes = null;

    private AnnotationTypes() {
    }

    public static AnnotationTypes getTypes() {
        if (annoTypes == null) {
            annoTypes = new AnnotationTypes();
        }
        return annoTypes;
    }

    public static URL getDefaultGlyphURL() {
        if (defaultGlyphIcon == null) {
            try {
                defaultGlyphIcon = new URL("nbresloc:/org/netbeans/editor/resources/defaultglyph.gif");
            }
            catch (MalformedURLException malformedURLException) {
                Utilities.annotateLoggable(malformedURLException);
            }
        }
        return defaultGlyphIcon;
    }

    public Boolean isBackgroundDrawing() {
        this.loadSettings();
        Boolean bl = (Boolean)this.getProp(PROP_BACKGROUND_DRAWING);
        if (bl == null) {
            return Boolean.FALSE;
        }
        return bl;
    }

    public void setBackgroundDrawing(Boolean bl) {
        if (!this.isBackgroundDrawing().equals(bl)) {
            this.putProp(PROP_BACKGROUND_DRAWING, bl);
            this.firePropertyChange(PROP_BACKGROUND_DRAWING, null, null);
            this.saveSetting(PROP_BACKGROUND_DRAWING, bl);
        }
    }

    public Boolean isCombineGlyphs() {
        this.loadSettings();
        Boolean bl = (Boolean)this.getProp(PROP_COMBINE_GLYPHS);
        if (bl == null) {
            return Boolean.TRUE;
        }
        return bl;
    }

    public void setCombineGlyphs(Boolean bl) {
        if (!this.isCombineGlyphs().equals(bl)) {
            this.putProp(PROP_COMBINE_GLYPHS, bl);
            this.firePropertyChange(PROP_COMBINE_GLYPHS, null, null);
            this.saveSetting(PROP_COMBINE_GLYPHS, bl);
        }
    }

    public Integer getBackgroundGlyphAlpha() {
        this.loadSettings();
        if (this.getProp(PROP_BACKGROUND_GLYPH_ALPHA) == null) {
            return new Integer(40);
        }
        return (Integer)this.getProp(PROP_BACKGROUND_GLYPH_ALPHA);
    }

    public void setBackgroundGlyphAlpha(int n) {
        if (n < 0 || n > 100) {
            return;
        }
        Integer n2 = new Integer(n);
        this.putProp(PROP_BACKGROUND_GLYPH_ALPHA, n2);
        this.firePropertyChange(PROP_BACKGROUND_GLYPH_ALPHA, null, null);
        this.saveSetting(PROP_BACKGROUND_GLYPH_ALPHA, n2);
    }

    public Boolean isGlyphsOverLineNumbers() {
        this.loadSettings();
        Boolean bl = (Boolean)this.getProp(PROP_GLYPHS_OVER_LINE_NUMBERS);
        if (bl == null) {
            return Boolean.TRUE;
        }
        return bl;
    }

    public void setGlyphsOverLineNumbers(Boolean bl) {
        if (!this.isGlyphsOverLineNumbers().equals(bl)) {
            this.putProp(PROP_GLYPHS_OVER_LINE_NUMBERS, bl);
            this.firePropertyChange(PROP_GLYPHS_OVER_LINE_NUMBERS, null, null);
            this.saveSetting(PROP_GLYPHS_OVER_LINE_NUMBERS, bl);
        }
    }

    public Boolean isShowGlyphGutter() {
        this.loadSettings();
        Boolean bl = (Boolean)this.getProp(PROP_SHOW_GLYPH_GUTTER);
        if (bl == null) {
            return Boolean.TRUE;
        }
        return bl;
    }

    public void setShowGlyphGutter(Boolean bl) {
        if (!this.isShowGlyphGutter().equals(bl)) {
            this.putProp(PROP_SHOW_GLYPH_GUTTER, bl);
            this.firePropertyChange(PROP_SHOW_GLYPH_GUTTER, null, null);
            this.saveSetting(PROP_SHOW_GLYPH_GUTTER, bl);
        }
    }

    private Object getProp(String string) {
        return this.properties.get(string);
    }

    private void putProp(Object object, Object object2) {
        if (object2 == null) {
            this.properties.remove(object);
            return;
        }
        this.properties.put(object, object2);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.support.firePropertyChange(this, string, object, object2);
    }

    public final void setTypes(Map map) {
        if (this.allTypes != null) {
            this.allTypes = map;
            SwingUtilities.invokeLater(new FirePropertyChange());
        } else {
            this.allTypes = map;
        }
    }

    public final void removeType(String string) {
        this.allTypes.remove(string);
        SwingUtilities.invokeLater(new FirePropertyChange());
    }

    public final AnnotationType getType(String string) {
        this.loadTypes();
        AnnotationType annotationType = null;
        if (this.allTypes != null) {
            annotationType = (AnnotationType)this.allTypes.get(string);
        }
        if (annotationType == null) {
            Utilities.annotateLoggable(new NullPointerException("null AnnotationType for:" + string));
        }
        return annotationType;
    }

    public Iterator getAnnotationTypeNames() {
        this.loadTypes();
        HashSet hashSet = new HashSet();
        if (this.allTypes != null) {
            hashSet.addAll(this.allTypes.keySet());
        }
        return hashSet.iterator();
    }

    public int getAnnotationTypeNamesCount() {
        this.loadTypes();
        return this.allTypes.keySet().size();
    }

    public int getVisibleAnnotationTypeNamesCount() {
        this.loadTypes();
        Iterator iterator = this.getAnnotationTypeNames();
        int n = 0;
        while (iterator.hasNext()) {
            AnnotationType annotationType = this.getType((String)iterator.next());
            if (annotationType == null || !annotationType.isVisible()) continue;
            ++n;
        }
        return n;
    }

    public void registerLoader(Loader loader) {
        this.loader = loader;
        this.loadedTypes = false;
        this.loadedSettings = false;
    }

    private void loadTypes() {
        if (this.loadedTypes || this.loader == null) {
            return;
        }
        this.loader.loadTypes();
        this.loadedTypes = true;
    }

    public void saveType(AnnotationType annotationType) {
        if (!this.loadedTypes || this.loader == null) {
            return;
        }
        this.loader.saveType(annotationType);
    }

    private void loadSettings() {
        if (this.loadedSettings || this.loader == null || this.loadingInProgress) {
            return;
        }
        this.loadingInProgress = true;
        this.loader.loadSettings();
        this.loadingInProgress = false;
        this.loadedSettings = true;
    }

    public void saveSetting(String string, Object object) {
        if (!this.loadedSettings || this.loader == null) {
            return;
        }
        this.loader.saveSetting(string, object);
    }

    private class FirePropertyChange
    implements Runnable {
        FirePropertyChange() {
        }

        public void run() {
            AnnotationTypes.this.firePropertyChange(AnnotationTypes.PROP_ANNOTATION_TYPES, null, null);
        }
    }

    public static interface Loader {
        public void loadTypes();

        public void loadSettings();

        public void saveType(AnnotationType var1);

        public void saveSetting(String var1, Object var2);
    }
}

