/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.expressions;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.expressions.JRExprFunctions;
import net.sf.jasperreports.extensions.ExtensionsRegistry;

public class ExprFunctionsRegistry
implements ExtensionsRegistry {
    private final List<String> expressionFunctionsClassNames;
    private List<JRExprFunctions> expressionFunctionsClasses;

    public ExprFunctionsRegistry(List<String> classNames) {
        this.expressionFunctionsClassNames = classNames;
    }

    public <T> List<T> getExtensions(Class<T> extensionType) {
        if (JRExprFunctions.class.equals(extensionType)) {
            if (this.expressionFunctionsClasses == null && this.expressionFunctionsClassNames != null) {
                JRExprFunctions expressionFunctionsClass = new JRExprFunctions();
                for (String className : this.expressionFunctionsClassNames) {
                    try {
                        Class<?> c = this.loadClassForName(className);
                        expressionFunctionsClass.getFunctionsClasses().add(c);
                    }
                    catch (ClassNotFoundException e) {}
                }
                this.expressionFunctionsClasses = new ArrayList<JRExprFunctions>();
                this.expressionFunctionsClasses.add(expressionFunctionsClass);
            }
            return this.expressionFunctionsClasses;
        }
        return null;
    }

    protected Class<?> loadClassForName(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader == null) {
                throw e;
            }
            try {
                return Class.forName(name, false, contextClassLoader);
            }
            catch (ClassNotFoundException e2) {
                throw e;
            }
        }
    }
}

