/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.dimensiontree.elements;

import javax.swing.ImageIcon;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.metadata.QueryElement;
import rex.metadata.ServerMetadata;
import rex.metadata.UniqueNameElement;
import rex.utils.DOM;
import rex.utils.I18n;
import rex.utils.S;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;

public class MemberElement
implements DimensionTreeElement,
UniqueNameElement,
QueryElement {
    private String catalogName;
    private String cubeName;
    private String dimensionUniqueName;
    private String hierarchyUniqueName;
    private String levelUniqueName;
    private int levelNumber;
    private String memberName;
    private String memberUniqueName;
    private String memberCaption;
    private int memberType;
    private int memberOrdinal;
    private int childrenCardinality;
    private boolean nodeEnabled;
    private XMLADiscoverRestrictions restrictions;
    private XMLADiscoverProperties properties;
    private ServerMetadata parent;
    static int MEMBER_CARDINALITY_NOT_INITIALIZED = -1;
    static ImageIcon memberIcon = S.getAppIcon("insert_picture.gif");

    public MemberElement(ServerMetadata svm, Node rowNode, XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties) {
        this.parent = svm;
        this.nodeEnabled = true;
        NodeList nl = rowNode.getChildNodes();
        this.childrenCardinality = MEMBER_CARDINALITY_NOT_INITIALIZED;
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            if (nl.item(i).getNodeName().equals("CATALOG_NAME")) {
                this.catalogName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("CUBE_NAME")) {
                this.cubeName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DIMENSION_UNIQUE_NAME")) {
                this.dimensionUniqueName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("HIERARCHY_UNIQUE_NAME")) {
                this.hierarchyUniqueName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("LEVEL_UNIQUE_NAME")) {
                this.levelUniqueName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("LEVEL_NUMBER")) {
                this.levelNumber = Integer.parseInt(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equals("MEMBER_NAME")) {
                this.memberName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("MEMBER_UNIQUE_NAME")) {
                this.memberUniqueName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("MEMBER_CAPTION")) {
                this.memberCaption = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("MEMBER_TYPE")) {
                this.memberType = Integer.parseInt(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equals("MEMBER_ORDINAL")) {
                this.memberOrdinal = Integer.parseInt(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (!nl.item(i).getNodeName().equals("CHILDREN_CARDINALITY")) continue;
            this.childrenCardinality = Integer.parseInt(DOM.getTextFromDOMElement(nl.item(i)));
        }
    }

    public MemberElement(ServerMetadata svm, XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties, String _catalogName, String _cubeName, String _dimensionUniqueName, String _hierarchyUniqueName, String _levelUniqueName, int _levelNumber, String _memberName, String _memberUniqueName, String _memberCaption, int _memberType, int _memberOrdinal, int _childrenCardinality) {
        this.parent = svm;
        this.restrictions = _restrictions;
        this.properties = _properties;
        this.nodeEnabled = true;
        this.catalogName = _catalogName;
        this.cubeName = _cubeName;
        this.dimensionUniqueName = _dimensionUniqueName;
        this.hierarchyUniqueName = _hierarchyUniqueName;
        this.levelUniqueName = _levelUniqueName;
        this.levelNumber = _levelNumber;
        this.memberName = _memberName;
        this.memberUniqueName = _memberUniqueName;
        this.memberCaption = _memberCaption;
        this.memberType = _memberType;
        this.memberOrdinal = _memberOrdinal;
        this.childrenCardinality = _childrenCardinality;
    }

    @Override
    public DimensionTreeElement[] getChildren(boolean noMatterWhat) {
        if (this.childrenCardinality > 0) {
            this.restrictions.setMemberUniqueName(this.memberUniqueName);
            this.restrictions.setTreeOp(XMLADiscoverRestrictions.MD_TREEOP_CHILDREN);
            this.restrictions.setLevelUniqueName(null);
            return this.parent.getDimensionTreeMembersList(this.restrictions, this.properties);
        }
        return null;
    }

    @Override
    public String toString() {
        if (this.memberCaption == null) {
            return I18n.getString("toolTip.notInitialized");
        }
        return this.memberCaption;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getToolTip() {
        if (this.memberCaption == null) {
            return I18n.getString("toolTip.notInitialized");
        }
        return "<html>" + I18n.getString("toolTip.memberName:") + this.memberName + "<BR>" + I18n.getString("toolTip.memberUniqueName") + this.memberUniqueName + "<BR>" + I18n.getString("toolTip.memberCaption") + this.memberCaption + "<BR>" + I18n.getString("toolTip.memberOrdinal") + this.memberOrdinal + "<BR>" + I18n.getString("toolTip.childrenCount") + this.childrenCardinality + "</html>";
    }

    @Override
    public String[] getPopUpActionList() {
        return null;
    }

    @Override
    public String getUniqueName() {
        return this.memberUniqueName;
    }

    @Override
    public String getCaption() {
        return this.memberCaption;
    }

    @Override
    public String getQueryMembersExpression() {
        return this.memberUniqueName;
    }

    @Override
    public boolean isEnabled() {
        return this.nodeEnabled;
    }

    @Override
    public void setEnabled(boolean newValue) {
        this.nodeEnabled = newValue;
    }

    @Override
    public String getHierarchyUniqueName() {
        return this.memberUniqueName.substring(0, this.memberUniqueName.lastIndexOf(".") - 1);
    }

    public boolean isMeasure() {
        return false;
    }

    @Override
    public int getChildrenCount() {
        if (this.childrenCardinality == MEMBER_CARDINALITY_NOT_INITIALIZED) {
            DimensionTreeElement[] list = this.getChildren(true);
            this.childrenCardinality = list == null ? 0 : list.length;
        }
        return this.childrenCardinality;
    }

    @Override
    public ServerMetadata getServerMetadata() {
        return this.parent;
    }

    @Override
    public XMLADiscoverRestrictions getRestrictions() {
        return this.restrictions;
    }

    @Override
    public XMLADiscoverProperties getProperties() {
        return this.properties;
    }

    @Override
    public String getDimensionUniqueName() {
        return this.dimensionUniqueName;
    }
}

