/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import mondrian.olap.Axis;
import mondrian.olap.CacheControl;
import mondrian.olap.Cell;
import mondrian.olap.ConnectionBase;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.Result;
import mondrian.olap.ResultBase;
import mondrian.olap.ResultLimitExceededException;
import mondrian.olap.Role;
import mondrian.olap.RoleImpl;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.RolapAxis;
import mondrian.rolap.RolapCell;
import mondrian.rolap.RolapConnectionPool;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapResult;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.ScenarioImpl;
import mondrian.rolap.agg.AggregationManager;
import mondrian.spi.DataSourceResolver;
import mondrian.spi.Dialect;
import mondrian.spi.DialectManager;
import mondrian.spi.impl.JndiDataSourceResolver;
import mondrian.util.FilteredIterableList;
import mondrian.util.MemoryMonitor;
import mondrian.util.MemoryMonitorFactory;
import mondrian.util.Pair;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.StringProperty;
import org.olap4j.Scenario;

public class RolapConnection
extends ConnectionBase {
    private static final Logger LOGGER = Logger.getLogger(RolapConnection.class);
    private final Util.PropertyList connectInfo;
    private static long executeCount = 0L;
    private final DataSource dataSource;
    private final String catalogUrl;
    private final RolapSchema schema;
    private SchemaReader schemaReader;
    protected Role role;
    private Locale locale;
    private Scenario scenario;
    private static DataSourceResolver dataSourceResolver;

    public RolapConnection(Util.PropertyList connectInfo) {
        this(connectInfo, null, null);
    }

    public RolapConnection(Util.PropertyList connectInfo, DataSource dataSource) {
        this(connectInfo, null, dataSource);
    }

    RolapConnection(Util.PropertyList connectInfo, RolapSchema schema) {
        this(connectInfo, schema, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RolapConnection(Util.PropertyList connectInfo, RolapSchema schema, DataSource dataSource) {
        String localeString;
        Role role;
        block28: {
            this.locale = Locale.US;
            String provider = connectInfo.get(RolapConnectionProperties.Provider.name(), "mondrian");
            Util.assertTrue(provider.equalsIgnoreCase("mondrian"));
            this.connectInfo = connectInfo;
            this.catalogUrl = connectInfo.get(RolapConnectionProperties.Catalog.name());
            String jdbcUser = connectInfo.get(RolapConnectionProperties.JdbcUser.name());
            String jdbcConnectString = connectInfo.get(RolapConnectionProperties.Jdbc.name());
            String strDataSource = connectInfo.get(RolapConnectionProperties.DataSource.name());
            StringBuilder buf = new StringBuilder();
            this.dataSource = RolapConnection.createDataSource(dataSource, connectInfo, buf);
            role = null;
            if (schema == null) {
                if (dataSource == null) {
                    String connectionKey = jdbcConnectString + RolapConnection.getJdbcProperties(connectInfo).toString();
                    schema = RolapSchema.Pool.instance().get(this.catalogUrl, connectionKey, jdbcUser, strDataSource, connectInfo);
                } else {
                    schema = RolapSchema.Pool.instance().get(this.catalogUrl, dataSource, connectInfo);
                }
                String roleNameList = connectInfo.get(RolapConnectionProperties.Role.name());
                if (roleNameList != null) {
                    List<String> roleNames = Util.parseCommaList(roleNameList);
                    ArrayList<Role> roleList = new ArrayList<Role>();
                    for (String roleName : roleNames) {
                        Role role1 = schema.lookupRole(roleName);
                        if (role1 == null) {
                            throw Util.newError("Role '" + roleName + "' not found");
                        }
                        roleList.add(role1);
                    }
                    switch (roleList.size()) {
                        case 0: {
                            role = null;
                            break;
                        }
                        case 1: {
                            role = (Role)roleList.get(0);
                            break;
                        }
                        default: {
                            role = RoleImpl.union(roleList);
                        }
                    }
                }
            } else {
                Connection conn = null;
                Statement statement = null;
                try {
                    conn = this.dataSource.getConnection();
                    Dialect dialect = DialectManager.createDialect(this.dataSource, conn);
                    if (dialect.getDatabaseProduct() == Dialect.DatabaseProduct.DERBY) {
                        statement = conn.createStatement();
                        statement.executeQuery("select * from bogustable");
                    }
                }
                catch (SQLException e) {
                    if (e.getMessage().equals("Table/View 'BOGUSTABLE' does not exist.")) {
                        break block28;
                    }
                    throw Util.newError(e, "Error while creating SQL connection: " + buf);
                }
                finally {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException e) {}
                }
            }
        }
        if (role == null) {
            role = schema.getDefaultRole();
        }
        if ((localeString = connectInfo.get(RolapConnectionProperties.Locale.name())) != null) {
            this.locale = Util.parseLocale(localeString);
        }
        this.schema = schema;
        this.setRole(role);
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    static DataSource createDataSource(DataSource dataSource, Util.PropertyList connectInfo, StringBuilder buf) {
        assert (buf != null);
        String jdbcConnectString = connectInfo.get(RolapConnectionProperties.Jdbc.name());
        String jdbcUser = connectInfo.get(RolapConnectionProperties.JdbcUser.name());
        String jdbcPassword = connectInfo.get(RolapConnectionProperties.JdbcPassword.name());
        String dataSourceName = connectInfo.get(RolapConnectionProperties.DataSource.name());
        if (dataSource != null) {
            RolapConnection.appendKeyValue(buf, "Anonymous data source", dataSource);
            RolapConnection.appendKeyValue(buf, RolapConnectionProperties.JdbcUser.name(), jdbcUser);
            RolapConnection.appendKeyValue(buf, RolapConnectionProperties.JdbcPassword.name(), jdbcPassword);
            if (jdbcUser != null || jdbcPassword != null) {
                dataSource = new UserPasswordDataSource(dataSource, jdbcUser, jdbcPassword);
            }
            return dataSource;
        }
        if (jdbcConnectString != null) {
            boolean poolNeeded;
            RolapConnection.appendKeyValue(buf, RolapConnectionProperties.Jdbc.name(), jdbcConnectString);
            RolapConnection.appendKeyValue(buf, RolapConnectionProperties.JdbcUser.name(), jdbcUser);
            RolapConnection.appendKeyValue(buf, RolapConnectionProperties.JdbcPassword.name(), jdbcPassword);
            String jdbcDrivers = connectInfo.get(RolapConnectionProperties.JdbcDrivers.name());
            if (jdbcDrivers != null) {
                RolapUtil.loadDrivers(jdbcDrivers);
            }
            String jdbcDriversProp = MondrianProperties.instance().JdbcDrivers.get();
            RolapUtil.loadDrivers(jdbcDriversProp);
            Properties jdbcProperties = RolapConnection.getJdbcProperties(connectInfo);
            Map<String, String> map = Util.toMap(jdbcProperties);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                RolapConnection.appendKeyValue(buf, entry.getKey(), entry.getValue());
            }
            if (jdbcUser != null) {
                jdbcProperties.put("user", jdbcUser);
            }
            if (jdbcPassword != null) {
                jdbcProperties.put("password", jdbcPassword);
            }
            if (!(poolNeeded = connectInfo.get(RolapConnectionProperties.PoolNeeded.name(), "true").equalsIgnoreCase("true"))) {
                return new DriverManagerDataSource(jdbcConnectString, jdbcProperties);
            }
            if (jdbcConnectString.toLowerCase().indexOf("mysql") > -1) {
                jdbcProperties.setProperty("autoReconnect", "true");
            }
            return RolapConnectionPool.instance().getDriverManagerPoolingDataSource(jdbcConnectString, jdbcProperties);
        }
        if (dataSourceName != null) {
            RolapConnection.appendKeyValue(buf, RolapConnectionProperties.DataSource.name(), dataSourceName);
            RolapConnection.appendKeyValue(buf, RolapConnectionProperties.JdbcUser.name(), jdbcUser);
            RolapConnection.appendKeyValue(buf, RolapConnectionProperties.JdbcPassword.name(), jdbcPassword);
            boolean poolNeeded = connectInfo.get(RolapConnectionProperties.PoolNeeded.name(), "false").equalsIgnoreCase("true");
            DataSourceResolver dataSourceResolver = RolapConnection.getDataSourceResolver();
            try {
                dataSource = dataSourceResolver.lookup(dataSourceName);
            }
            catch (Exception e) {
                throw Util.newInternal(e, "Error while looking up data source (" + dataSourceName + ")");
            }
            if (poolNeeded) {
                dataSource = RolapConnectionPool.instance().getDataSourcePoolingDataSource(dataSource, dataSourceName, jdbcUser, jdbcPassword);
            } else if (jdbcUser != null || jdbcPassword != null) {
                dataSource = new UserPasswordDataSource(dataSource, jdbcUser, jdbcPassword);
            }
            return dataSource;
        }
        throw Util.newInternal("Connect string '" + connectInfo.toString() + "' must contain either '" + (Object)((Object)RolapConnectionProperties.Jdbc) + "' or '" + (Object)((Object)RolapConnectionProperties.DataSource) + "'");
    }

    private static synchronized DataSourceResolver getDataSourceResolver() {
        if (dataSourceResolver == null) {
            StringProperty property = MondrianProperties.instance().DataSourceResolverClass;
            String className = property.get(JndiDataSourceResolver.class.getName());
            try {
                Class<?> clazz = Class.forName(className);
                if (!DataSourceResolver.class.isAssignableFrom(clazz)) {
                    throw Util.newInternal("Plugin class specified by property " + property.getPath() + " must implement " + DataSourceResolver.class.getName());
                }
                dataSourceResolver = (DataSourceResolver)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw Util.newInternal(e, "Error while loading plugin class '" + className + "'");
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal(e, "Error while loading plugin class '" + className + "'");
            }
            catch (InstantiationException e) {
                throw Util.newInternal(e, "Error while loading plugin class '" + className + "'");
            }
        }
        return dataSourceResolver;
    }

    private static void appendKeyValue(StringBuilder buf, String key, Object value) {
        if (value != null) {
            if (buf.length() > 0) {
                buf.append("; ");
            }
            buf.append(key).append('=').append(value);
        }
    }

    private static Properties getJdbcProperties(Util.PropertyList connectInfo) {
        Properties jdbcProperties = new Properties();
        for (Pair<String, String> entry : connectInfo) {
            if (!((String)entry.left).startsWith("jdbc.")) continue;
            jdbcProperties.put(((String)entry.left).substring("jdbc.".length()), entry.right);
        }
        return jdbcProperties;
    }

    public Util.PropertyList getConnectInfo() {
        return this.connectInfo;
    }

    public void close() {
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getConnectString() {
        return this.connectInfo.toString();
    }

    public String getCatalogName() {
        return this.catalogUrl;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public SchemaReader getSchemaReader() {
        return this.schemaReader;
    }

    public Object getProperty(String name) {
        if (name.equals(RolapConnectionProperties.JdbcPassword.name()) || name.equals(RolapConnectionProperties.CatalogContent.name())) {
            return "";
        }
        return this.connectInfo.get(name);
    }

    public CacheControl getCacheControl(PrintWriter pw) {
        return AggregationManager.instance().getCacheControl(pw);
    }

    public Result execute(Query query) {
        class Listener
        implements MemoryMonitor.Listener {
            private final Query query;

            Listener(Query query) {
                this.query = query;
            }

            public void memoryUsageNotification(long used, long max) {
                StringBuilder buf = new StringBuilder(200);
                buf.append("OutOfMemory used=");
                buf.append(used);
                buf.append(", max=");
                buf.append(max);
                buf.append(" for connection: ");
                buf.append(RolapConnection.this.getConnectString());
                RolapConnection.memoryUsageNotification(this.query, buf.toString());
            }
        }
        Listener listener = new Listener(query);
        MemoryMonitor mm = MemoryMonitorFactory.getMemoryMonitor();
        long currId = -1L;
        try {
            mm.addListener(listener);
            query.checkCancelOrTimeout();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)Util.unparse(query));
            }
            if (RolapUtil.MDX_LOGGER.isDebugEnabled()) {
                currId = executeCount++;
                RolapUtil.MDX_LOGGER.debug((Object)(currId + ": " + Util.unparse(query)));
            }
            query.setQueryStartTime();
            ResultBase result = new RolapResult(query, true);
            for (int i = 0; i < query.axes.length; ++i) {
                QueryAxis axis = query.axes[i];
                if (!axis.isNonEmpty()) continue;
                result = new NonEmptyResult(result, query, i);
            }
            query.setQueryEndExecution();
            RolapResult i = result;
            return i;
        }
        catch (ResultLimitExceededException e) {
            throw e;
        }
        catch (Exception e) {
            String queryString;
            query.setQueryEndExecution();
            try {
                queryString = Util.unparse(query);
            }
            catch (Exception e1) {
                queryString = "?";
            }
            throw Util.newError(e, "Error while executing query [" + queryString + "]");
        }
        finally {
            mm.removeListener(listener);
            if (RolapUtil.MDX_LOGGER.isDebugEnabled()) {
                RolapUtil.MDX_LOGGER.debug((Object)(currId + ": exec: " + (System.currentTimeMillis() - query.getQueryStartTime()) + " ms"));
            }
        }
    }

    public void setRole(Role role) {
        assert (role != null);
        this.role = role;
        this.schemaReader = new RolapSchemaReader(role, this.schema);
    }

    public Role getRole() {
        Util.assertPostcondition(this.role != null, "role != null");
        return this.role;
    }

    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public ScenarioImpl createScenario() {
        ScenarioImpl scenario = new ScenarioImpl();
        scenario.register(this.schema);
        return scenario;
    }

    private static class UserPasswordDataSource
    extends DelegatingDataSource {
        private final String jdbcUser;
        private final String jdbcPassword;

        public UserPasswordDataSource(DataSource dataSource, String jdbcUser, String jdbcPassword) {
            super(dataSource);
            this.jdbcUser = jdbcUser;
            this.jdbcPassword = jdbcPassword;
        }

        public Connection getConnection() throws SQLException {
            return this.dataSource.getConnection(this.jdbcUser, this.jdbcPassword);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class DelegatingDataSource
    implements DataSource {
        protected final DataSource dataSource;

        public DelegatingDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.dataSource.getConnection();
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return this.dataSource.getConnection(username, password);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.dataSource.getLogWriter();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.dataSource.setLogWriter(out);
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.dataSource.setLoginTimeout(seconds);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.dataSource.getLoginTimeout();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            if (Util.JdbcVersion >= 4) {
                try {
                    Method method = DataSource.class.getMethod("unwrap", Class.class);
                    return iface.cast(method.invoke((Object)this.dataSource, iface));
                }
                catch (IllegalAccessException e) {
                    throw Util.newInternal(e, "While invokin unwrap");
                }
                catch (InvocationTargetException e) {
                    throw Util.newInternal(e, "While invokin unwrap");
                }
                catch (NoSuchMethodException e) {
                    throw Util.newInternal(e, "While invokin unwrap");
                }
            }
            if (iface.isInstance(this.dataSource)) {
                return iface.cast(this.dataSource);
            }
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            if (Util.JdbcVersion >= 4) {
                try {
                    Method method = DataSource.class.getMethod("isWrapperFor", Boolean.TYPE);
                    return (Boolean)method.invoke((Object)this.dataSource, iface);
                }
                catch (IllegalAccessException e) {
                    throw Util.newInternal(e, "While invoking isWrapperFor");
                }
                catch (InvocationTargetException e) {
                    throw Util.newInternal(e, "While invoking isWrapperFor");
                }
                catch (NoSuchMethodException e) {
                    throw Util.newInternal(e, "While invoking isWrapperFor");
                }
            }
            return iface.isInstance(this.dataSource);
        }
    }

    static class NonEmptyResult
    extends ResultBase {
        final Result underlying;
        private final int axis;
        private final Map<Integer, Integer> map;
        private final int[] pos;

        NonEmptyResult(Result result, Query query, int axis) {
            super(query, (Axis[])result.getAxes().clone());
            this.underlying = result;
            this.axis = axis;
            this.map = new HashMap<Integer, Integer>();
            int axisCount = this.underlying.getAxes().length;
            this.pos = new int[axisCount];
            this.slicerAxis = this.underlying.getSlicerAxis();
            List<Position> positions = this.underlying.getAxes()[axis].getPositions();
            try {
                ArrayList<Position> positionsList;
                if (((Member)positions.get(0).get(0)).getDimension().isHighCardinality()) {
                    positionsList = new FilteredIterableList<Position>(positions, new FilteredIterableList.Filter<Position>(){

                        @Override
                        public boolean accept(Position p) {
                            return p.get(0) != null;
                        }
                    });
                } else {
                    positionsList = new ArrayList();
                    int i = -1;
                    for (Position position : positions) {
                        if (this.isEmpty(++i, axis)) continue;
                        this.map.put(positionsList.size(), i);
                        positionsList.add(position);
                    }
                }
                this.axes[axis] = new RolapAxis.PositionList(positionsList);
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.axes[axis] = new RolapAxis.PositionList(new ArrayList<Position>());
            }
        }

        protected Logger getLogger() {
            return LOGGER;
        }

        private boolean isEmpty(int offset, int fixedAxis) {
            int axisCount = this.getAxes().length;
            this.pos[fixedAxis] = offset;
            return this.isEmptyRecurse(fixedAxis, axisCount - 1);
        }

        private boolean isEmptyRecurse(int fixedAxis, int axis) {
            if (axis < 0) {
                RolapCell cell = (RolapCell)this.underlying.getCell(this.pos);
                return cell.isNull();
            }
            if (axis == fixedAxis) {
                return this.isEmptyRecurse(fixedAxis, axis - 1);
            }
            List<Position> positions = this.getAxes()[axis].getPositions();
            int positionCount = positions.size();
            int i = 0;
            while (i < positionCount) {
                this.pos[axis] = i++;
                if (this.isEmptyRecurse(fixedAxis, axis - 1)) continue;
                return false;
            }
            return true;
        }

        public synchronized Cell getCell(int[] externalPos) {
            try {
                int mappedOffset;
                System.arraycopy(externalPos, 0, this.pos, 0, externalPos.length);
                int offset = externalPos[this.axis];
                this.pos[this.axis] = mappedOffset = this.mapOffsetToUnderlying(offset);
                return this.underlying.getCell(this.pos);
            }
            catch (NullPointerException npe) {
                return this.underlying.getCell(externalPos);
            }
        }

        private int mapOffsetToUnderlying(int offset) {
            return this.map.get(offset);
        }

        public void close() {
            this.underlying.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DriverManagerDataSource
    implements DataSource {
        private final String jdbcConnectString;
        private PrintWriter logWriter;
        private int loginTimeout;
        private Properties jdbcProperties;

        public DriverManagerDataSource(String jdbcConnectString, Properties properties) {
            this.jdbcConnectString = jdbcConnectString;
            this.jdbcProperties = properties;
        }

        public int hashCode() {
            int h = this.loginTimeout;
            h = Util.hash(h, this.jdbcConnectString);
            h = Util.hash(h, this.jdbcProperties);
            return h;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DriverManagerDataSource) {
                DriverManagerDataSource that = (DriverManagerDataSource)obj;
                return this.loginTimeout == that.loginTimeout && this.jdbcConnectString.equals(that.jdbcConnectString) && this.jdbcProperties.equals(that.jdbcProperties);
            }
            return false;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return new DelegatingConnection(DriverManager.getConnection(this.jdbcConnectString, this.jdbcProperties));
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            if (this.jdbcProperties == null) {
                return DriverManager.getConnection(this.jdbcConnectString, username, password);
            }
            Properties temp = (Properties)this.jdbcProperties.clone();
            temp.put("user", username);
            temp.put("password", password);
            return DriverManager.getConnection(this.jdbcConnectString, temp);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.logWriter;
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.logWriter = out;
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.loginTimeout = seconds;
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.loginTimeout;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new SQLException("not a wrapper");
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }
    }
}

