/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.repo.PersistenceService;
import net.sf.jasperreports.repo.PersistenceUtil;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.Resource;
import net.sf.jasperreports.repo.StreamRepositoryService;

public class FileRepositoryService
implements StreamRepositoryService {
    private JasperReportsContext jasperReportsContext;
    private String root;
    private boolean resolveAbsolutePath;

    public FileRepositoryService(String root, boolean resolveAbsolutePath) {
        this(DefaultJasperReportsContext.getInstance(), root, resolveAbsolutePath);
    }

    public FileRepositoryService(JasperReportsContext jasperReportsContext, String root, boolean resolveAbsolutePath) {
        this.jasperReportsContext = jasperReportsContext;
        this.root = root;
        this.resolveAbsolutePath = resolveAbsolutePath;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getRoot() {
        return this.root;
    }

    @Override
    public void setContext(RepositoryContext context) {
    }

    @Override
    public void revertContext() {
    }

    @Override
    public InputStream getInputStream(String uri) {
        File file = null;
        if (!(uri == null || (file = new File(this.getRoot(), uri)).exists() && file.isFile())) {
            if (this.resolveAbsolutePath) {
                file = new File(uri);
                if (!file.exists() || !file.isFile()) {
                    file = null;
                }
            } else {
                file = null;
            }
        }
        FileInputStream is = null;
        if (file != null) {
            try {
                is = new FileInputStream(file);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
        return is;
    }

    @Override
    public OutputStream getOutputStream(String uri) {
        File file = null;
        if (uri != null) {
            file = new File(this.getRoot(), uri);
        }
        FileOutputStream os = null;
        if (file != null) {
            try {
                os = new FileOutputStream(file);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
        return os;
    }

    @Override
    public Resource getResource(String uri) {
        throw new JRRuntimeException("Not implemented.");
    }

    @Override
    public void saveResource(String uri, Resource resource) {
        PersistenceService persistenceService = PersistenceUtil.getInstance(this.jasperReportsContext).getService(FileRepositoryService.class, resource.getClass());
        if (persistenceService != null) {
            persistenceService.save(resource, uri, this);
        }
    }

    @Override
    public <K extends Resource> K getResource(String uri, Class<K> resourceType) {
        PersistenceService persistenceService = PersistenceUtil.getInstance(this.jasperReportsContext).getService(FileRepositoryService.class, resourceType);
        if (persistenceService != null) {
            return (K)persistenceService.load(uri, this);
        }
        return null;
    }
}

