/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.Comparator;

public class VersionComparator
implements Comparator<String> {
    @Override
    public int compare(String currentVersion, String oldVersion) {
        if (oldVersion == null) {
            throw new IllegalArgumentException("Reference version can't be null.");
        }
        if (currentVersion == null || currentVersion.startsWith(oldVersion)) {
            return 1;
        }
        String[] oldVersionChunks = oldVersion.split("\\.");
        String[] currentVersionChunks = currentVersion.split("\\.");
        int count = Math.min(oldVersionChunks.length, currentVersionChunks.length);
        int old = 0;
        int current = 0;
        for (int i = 0; i < count; ++i) {
            try {
                old = Integer.valueOf(oldVersionChunks[i]);
                current = Integer.valueOf(currentVersionChunks[i]);
                if (current == old) continue;
                return current - old;
            }
            catch (NumberFormatException e) {
                if (currentVersionChunks[i].compareTo(oldVersionChunks[i]) == 0) continue;
                return currentVersionChunks[i].compareTo(oldVersionChunks[i]);
            }
        }
        return currentVersionChunks.length - oldVersionChunks.length;
    }
}

