/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.actions;

import com.jaspersoft.ireport.components.table.actions.TableCellSeparatorMoveProvider;
import com.jaspersoft.ireport.components.table.actions.TableCellSeparatorMoveStrategy;
import java.awt.Point;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;

public class TableCellSeparatorMoveAction
extends WidgetAction.LockedAdapter {
    private MoveStrategy strategy;
    private MoveProvider provider;
    private Widget movingWidget = null;
    private Point dragSceneLocation = null;
    private Point originalSceneLocation = null;
    private int modifiers = 0;
    private boolean reversOrder = false;

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public TableCellSeparatorMoveAction() {
        this(false);
    }

    public TableCellSeparatorMoveAction(boolean reversOrder) {
        this(reversOrder, 0);
    }

    public TableCellSeparatorMoveAction(boolean reversOrder, int modifiers) {
        this.strategy = new TableCellSeparatorMoveStrategy(reversOrder);
        this.provider = new TableCellSeparatorMoveProvider(reversOrder);
        this.modifiers = modifiers;
        this.reversOrder = reversOrder;
    }

    protected boolean isLocked() {
        return this.movingWidget != null;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (event.getButton() == 1 && event.getClickCount() == 1 && (this.getModifiers() == 0 || (event.getModifiersEx() & this.getModifiers()) == this.getModifiers())) {
            this.movingWidget = widget;
            this.originalSceneLocation = this.provider.getOriginalLocation(widget);
            if (this.originalSceneLocation == null) {
                this.originalSceneLocation = new Point();
            }
            this.dragSceneLocation = widget.convertLocalToScene(event.getPoint());
            this.provider.movementStarted(widget);
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        boolean state = this.move(widget, event.getPoint());
        if (state) {
            this.movingWidget = null;
            this.provider.movementFinished(widget);
        }
        return state ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
        return this.move(widget, event.getPoint()) ? WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this) : WidgetAction.State.REJECTED;
    }

    private boolean move(Widget widget, Point newLocation) {
        if (this.movingWidget != widget) {
            return false;
        }
        newLocation = widget.convertLocalToScene(newLocation);
        Point location = new Point(this.originalSceneLocation.x + newLocation.x - this.dragSceneLocation.x, this.originalSceneLocation.y + newLocation.y - this.dragSceneLocation.y);
        this.provider.setNewLocation(widget, this.strategy.locationSuggested(widget, this.originalSceneLocation, location));
        return true;
    }
}

