/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class UrlPathHelper {
    public static final String INCLUDE_URI_REQUEST_ATTRIBUTE = "javax.servlet.include.request_uri";
    public static final String INCLUDE_CONTEXT_PATH_REQUEST_ATTRIBUTE = "javax.servlet.include.context_path";
    public static final String INCLUDE_SERVLET_PATH_REQUEST_ATTRIBUTE = "javax.servlet.include.servlet_path";
    private final Log logger = LogFactory.getLog(this.getClass());
    private boolean alwaysUseFullPath = false;
    private boolean urlDecode = true;
    private String defaultEncoding = "ISO-8859-1";

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.alwaysUseFullPath = alwaysUseFullPath;
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlDecode = urlDecode;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    protected String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getLookupPathForRequest(HttpServletRequest request) {
        if (this.alwaysUseFullPath) {
            return this.getPathWithinApplication(request);
        }
        String rest = this.getPathWithinServletMapping(request);
        if (!"".equals(rest)) {
            return rest;
        }
        return this.getPathWithinApplication(request);
    }

    public String getPathWithinServletMapping(HttpServletRequest request) {
        String servletPath;
        String pathWithinApp = this.getPathWithinApplication(request);
        if (pathWithinApp.startsWith(servletPath = this.getServletPath(request))) {
            return pathWithinApp.substring(servletPath.length());
        }
        return servletPath;
    }

    public String getPathWithinApplication(HttpServletRequest request) {
        String contextPath = this.getContextPath(request);
        String requestUri = this.getRequestUri(request);
        if (StringUtils.startsWithIgnoreCase(requestUri, contextPath)) {
            String path = requestUri.substring(contextPath.length());
            return StringUtils.hasText(path) ? path : "/";
        }
        return requestUri;
    }

    public String getRequestUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute(INCLUDE_URI_REQUEST_ATTRIBUTE);
        if (uri == null) {
            uri = request.getRequestURI();
        }
        return this.decodeAndCleanUriString(request, uri);
    }

    public String getContextPath(HttpServletRequest request) {
        String contextPath = (String)request.getAttribute(INCLUDE_CONTEXT_PATH_REQUEST_ATTRIBUTE);
        if (contextPath == null) {
            contextPath = request.getContextPath();
        }
        return this.decodeRequestString(request, contextPath);
    }

    public String getServletPath(HttpServletRequest request) {
        String servletPath = (String)request.getAttribute(INCLUDE_SERVLET_PATH_REQUEST_ATTRIBUTE);
        if (servletPath == null) {
            servletPath = request.getServletPath();
        }
        return servletPath;
    }

    public String getOriginatingRequestUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (uri == null) {
            uri = request.getRequestURI();
        }
        return this.decodeAndCleanUriString(request, uri);
    }

    public String getOriginatingContextPath(HttpServletRequest request) {
        String contextPath = (String)request.getAttribute("javax.servlet.forward.context_path");
        if (contextPath == null) {
            contextPath = request.getContextPath();
        }
        return this.decodeRequestString(request, contextPath);
    }

    public String getOriginatingQueryString(HttpServletRequest request) {
        String queryString = (String)request.getAttribute("javax.servlet.forward.query_string");
        if (queryString == null) {
            queryString = request.getQueryString();
        }
        return queryString;
    }

    private String decodeAndCleanUriString(HttpServletRequest request, String uri) {
        int semicolonIndex = (uri = this.decodeRequestString(request, uri)).indexOf(59);
        return semicolonIndex != -1 ? uri.substring(0, semicolonIndex) : uri;
    }

    public String decodeRequestString(HttpServletRequest request, String source) {
        if (this.urlDecode) {
            String enc = this.determineEncoding(request);
            try {
                return URLDecoder.decode(source, enc);
            }
            catch (UnsupportedEncodingException ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("Could not decode request string [" + source + "] with encoding '" + enc + "': falling back to platform default encoding; exception message: " + ex.getMessage()));
                }
                return URLDecoder.decode(source);
            }
        }
        return source;
    }

    protected String determineEncoding(HttpServletRequest request) {
        String enc = request.getCharacterEncoding();
        if (enc == null) {
            enc = this.getDefaultEncoding();
        }
        return enc;
    }
}

