/*
 * Decompiled with CFR 0.152.
 */
package rex.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;
import rex.utils.S;

public class UIPropertyManager {
    public static final String METAL_LF = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String MOTIF_LF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static final String WINDOWS_LF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static String currentUI = "";
    private static Border lineBasic = BorderFactory.createLineBorder(Color.black);
    private static Border lineFull;
    private static Border loweredBasic;
    private static Border raisedBasic;
    private static Border raisedFull;
    private static Border etchedBasic;
    private static Border etchedFull;
    private static Border emptyWrapperWin;
    private static Border emptyWrapperMetal;
    private static Border emptyBasic;
    private static Border emptyWin;
    private static Border emptyMetal;
    private static Border formBorder;
    private static Border formActiveBorder;
    private static Insets menuInsets;
    private static Color backgroundColor;
    private static Color inactiveColor;
    private static Color activeNotnullColor;
    private static Color activeColor;
    private static Color activeBorderColor;
    private static Color labelColor;

    public static boolean isCurrentUI(String ui) {
        return currentUI.equals(ui);
    }

    public static void setCurrentUI(String ui) {
        currentUI = ui;
        if (ui.equals(METAL_LF)) {
            UIPropertyManager.setMetalProperties();
        } else if (ui.equals(MOTIF_LF)) {
            UIPropertyManager.setMetalProperties();
        } else if (ui.equals(WINDOWS_LF)) {
            UIPropertyManager.setWindowsProperties();
        }
    }

    public static void setSystemUI() {
        String ui = UIManager.getSystemLookAndFeelClassName();
        if (ui.equals(METAL_LF)) {
            UIPropertyManager.setMetalProperties();
        } else if (ui.equals(MOTIF_LF)) {
            UIPropertyManager.setMetalProperties();
        } else if (ui.equals(WINDOWS_LF)) {
            UIPropertyManager.setWindowsProperties();
        }
    }

    public static void setMetalProperties() {
        S.out("Setting metal UI properties...");
    }

    public static void setWindowsProperties() {
        S.out("Setting windows UI properties...");
        UIManager.put("Label.font", new Font("Dialog", 0, 12));
        UIManager.put("Label.border", BorderFactory.createLineBorder(Color.BLACK));
        UIManager.put("Table.font", new Font("Dialog", 0, 10));
    }

    public static void setFixedProperties() {
        System.setProperty("StyleReport.locale.properties", "/StyleReportMappings");
        UIManager.put("FileChooser.acceptAllFileFilterText", "Sve datoteke");
        UIManager.put("FileChooser.saveButtonToolTipText", "Spremi odabranu datoteku");
        UIManager.put("FileChooser.openButtonToolTipText", "Otvori odabranu datoteku");
        UIManager.put("FileChooser.cancelButtonToolTipText", "Odustani od rada s izbornikom datoteka");
        UIManager.put("FileChooser.updateButtonToolTipText", "A\u00fburiraj listu kazala");
        UIManager.put("FileChooser.helpButtonToolTipText", "Pomo\u00ca");
        UIManager.put("FileChooser.newFolderErrorText", "Pogre\u00f6ka pri kreiranju novog kazala");
        UIManager.put("FileChooser.fileDescriptionText", "Generi\u00cbka datoteka");
        UIManager.put("FileChooser.directoryDescriptionText", "Kazalo");
        UIManager.put("FileChooser.saveButtonText", "Spremi");
        UIManager.put("FileChooser.openButtonText", "Otvori");
        UIManager.put("FileChooser.cancelButtonText", "Odustani");
        UIManager.put("FileChooser.updateButtonText", "Promijeni");
        UIManager.put("FileChooser.helpButtonText", "Pomo\u00ca");
        UIManager.put("FileChooser.lookInLabelText", "Pogledaj u:");
        UIManager.put("FileChooser.fileNameLabelText", "Ime datoteke:");
        UIManager.put("FileChooser.filesOfTypeLabelText", "Datoteke vrste:");
        UIManager.put("FileChooser.upFolderToolTipText", "Nadre\uf8ffeno kazalo");
        UIManager.put("FileChooser.homeFolderToolTipText", "Osnovno kazalo korisnika");
        UIManager.put("FileChooser.newFolderToolTipText", "Kreiraj novo kazalo");
        UIManager.put("FileChooser.listViewButtonToolTipText", "Lista");
        UIManager.put("FileChooser.detailsViewButtonToolTipText", "Lista s detaljima");
        UIManager.put("ColorChooser.okText", "Prihvati");
        UIManager.put("ColorChooser.cancelText", "Odbaci");
        UIManager.put("ColorChooser.resetText", "Obnovi");
        UIManager.put("ColorChooser.previewText", "Rezultat");
        UIManager.put("ColorChooser.swatchesRecentText", "Do sada");
        UIManager.put("ColorChooser.sampleText", "Uzorak teksta");
    }

    static {
        loweredBasic = new SoftBevelBorder(1);
        raisedBasic = new SoftBevelBorder(0);
        etchedBasic = BorderFactory.createEtchedBorder();
        emptyBasic = BorderFactory.createEmptyBorder(1, 6, 1, 6);
        emptyWrapperWin = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        emptyWrapperMetal = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        lineFull = BorderFactory.createCompoundBorder(lineBasic, emptyBasic);
        raisedFull = BorderFactory.createCompoundBorder(raisedBasic, emptyBasic);
        etchedFull = BorderFactory.createCompoundBorder(etchedBasic, emptyBasic);
        emptyWin = BorderFactory.createCompoundBorder(emptyWrapperWin, emptyBasic);
        emptyMetal = BorderFactory.createCompoundBorder(emptyWrapperMetal, emptyBasic);
        backgroundColor = Color.lightGray;
        inactiveColor = new Color(225, 225, 225);
        activeNotnullColor = new Color(255, 255, 232);
        activeColor = Color.white;
        activeBorderColor = new Color(252, 237, 66);
        labelColor = Color.blue.darker().darker();
    }
}

