/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.actions;

import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RemoveServerAction
extends NodeAction {
    protected void performAction(Node[] nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            ServerInstance serverInstance = this.getServerInstance(nodeArray[i]);
            if (serverInstance == null || !serverInstance.isRemovable()) continue;
            String string = NbBundle.getMessage(RemoveServerAction.class, (String)"MSG_RemoveServerTitle", (Object)serverInstance.getDisplayName());
            String string2 = NbBundle.getMessage(RemoveServerAction.class, (String)"MSG_RemoveServerMessage", (Object)serverInstance.getDisplayName());
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, string, 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) != NotifyDescriptor.YES_OPTION) continue;
            serverInstance.remove();
        }
    }

    private ServerInstance getServerInstance(Node node) {
        ServerInstance serverInstance = null;
        GlassfishModule glassfishModule = (GlassfishModule)node.getLookup().lookup(GlassfishModule.class);
        if (glassfishModule != null) {
            String string = glassfishModule.getInstanceProperties().get("url");
            serverInstance = ServerUtilities.getServerInstance(string);
        }
        return serverInstance;
    }

    protected boolean enable(Node[] nodeArray) {
        boolean bl = true;
        for (int i = 0; i < nodeArray.length; ++i) {
            ServerInstance serverInstance = this.getServerInstance(nodeArray[i]);
            if (serverInstance != null && serverInstance.isRemovable()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(RemoveServerAction.class, (String)"CTL_RemoveServerAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

