/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.impl.MySQLOptions;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AdminPropertiesPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(AdminPropertiesPanel.class.getName());
    MySQLOptions options = MySQLOptions.getDefault();
    DialogDescriptor descriptor;
    private Color nbErrorForeground = UIManager.getColor("nb.errorForeground");
    private static String recentDirectory = null;
    private JButton btnAdminBrowse;
    private JButton btnStartBrowse;
    private JButton btnStopBrowse;
    private JLabel labelAdmin;
    private JLabel labelAdminArgs;
    private JLabel labelStart;
    private JLabel labelStartArgs;
    private JLabel labelStartArgs1;
    private JLabel labelStop;
    private JLabel messageLabel;
    private JTextField txtAdmin;
    private JTextField txtAdminArgs;
    private JTextField txtStart;
    private JTextField txtStartArgs;
    private JTextField txtStop;
    private JTextField txtStopArgs;

    private void validatePanel() {
        this.descriptor.setValid(false);
        this.messageLabel.setText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.MSG_ValidatingCommandPaths"));
        this.revalidate();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    if (AdminPropertiesPanel.this.descriptor == null) {
                        return;
                    }
                    String string = null;
                    String string2 = AdminPropertiesPanel.this.getAdminPath();
                    String string3 = AdminPropertiesPanel.this.getStartPath();
                    String string4 = AdminPropertiesPanel.this.getStopPath();
                    if (!Utils.isValidExecutable(string3, true)) {
                        string = NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.MSG_InvalidStartPath");
                    }
                    if (!Utils.isValidExecutable(string4, true)) {
                        string = NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.MSG_InvalidStopPath");
                    }
                    if (!Utils.isValidURL(string2, true) && !Utils.isValidExecutable(string2, true)) {
                        string = NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.MSG_InvalidAdminPath");
                    }
                    final String string5 = string;
                    Mutex.EVENT.postReadRequest(new Runnable(){

                        public void run() {
                            if (string5 != null) {
                                AdminPropertiesPanel.this.messageLabel.setForeground(AdminPropertiesPanel.this.nbErrorForeground);
                                AdminPropertiesPanel.this.messageLabel.setText(string5);
                                AdminPropertiesPanel.this.descriptor.setValid(false);
                            } else {
                                AdminPropertiesPanel.this.messageLabel.setText(" ");
                                AdminPropertiesPanel.this.descriptor.setValid(true);
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    AdminPropertiesPanel.this.messageLabel.setForeground(AdminPropertiesPanel.this.nbErrorForeground);
                    AdminPropertiesPanel.this.messageLabel.setText(" ");
                    AdminPropertiesPanel.this.descriptor.setValid(true);
                    throw new RuntimeException(throwable);
                }
            }
        });
    }

    public AdminPropertiesPanel(DatabaseServer databaseServer) {
        if (this.nbErrorForeground == null) {
            this.nbErrorForeground = new Color(255, 0, 0);
        }
        this.initComponents();
        this.setBackground(this.getBackground());
        this.messageLabel.setBackground(this.getBackground());
        this.messageLabel.setText(" ");
        this.txtAdmin.setText(databaseServer.getAdminPath());
        this.txtAdminArgs.setText(databaseServer.getAdminArgs());
        this.txtStart.setText(databaseServer.getStartPath());
        this.txtStartArgs.setText(databaseServer.getStartArgs());
        this.txtStop.setText(databaseServer.getStopPath());
        this.txtStopArgs.setText(databaseServer.getStopArgs());
    }

    public String getAdminPath() {
        return this.txtAdmin.getText().trim();
    }

    public String getAdminArgs() {
        return this.txtAdminArgs.getText().trim();
    }

    public String getStartPath() {
        return this.txtStart.getText().trim();
    }

    public String getStartArgs() {
        return this.txtStartArgs.getText().trim();
    }

    public String getStopPath() {
        return this.txtStop.getText().trim();
    }

    public String getStopArgs() {
        return this.txtStopArgs.getText().trim();
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.descriptor = dialogDescriptor;
    }

    private void chooseFile(JTextField jTextField) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(0);
        String string = jTextField.getText().trim();
        if (string != null && string.length() > 0) {
            jFileChooser.setSelectedFile(new File(string));
        } else if (recentDirectory != null) {
            jFileChooser.setCurrentDirectory(new File(recentDirectory));
        }
        if (jFileChooser.showOpenDialog(this) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        recentDirectory = file.getParentFile().getAbsolutePath();
        jTextField.setText(file.getAbsolutePath());
    }

    private void initComponents() {
        this.txtAdmin = new JTextField();
        this.btnAdminBrowse = new JButton();
        this.txtAdminArgs = new JTextField();
        this.messageLabel = new JLabel();
        this.labelAdmin = new JLabel();
        this.labelAdminArgs = new JLabel();
        this.labelStart = new JLabel();
        this.txtStart = new JTextField();
        this.btnStartBrowse = new JButton();
        this.txtStartArgs = new JTextField();
        this.labelStartArgs = new JLabel();
        this.labelStop = new JLabel();
        this.txtStop = new JTextField();
        this.btnStopBrowse = new JButton();
        this.txtStopArgs = new JTextField();
        this.labelStartArgs1 = new JLabel();
        this.txtAdmin.setText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtAdmin.text"));
        this.txtAdmin.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtAdmin.AccessibleContext.accessibleDescription"));
        this.txtAdmin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdminPropertiesPanel.this.txtAdminActionPerformed(actionEvent);
            }
        });
        this.txtAdmin.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                AdminPropertiesPanel.this.txtAdminFocusLost(focusEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdminBrowse, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.btnAdminBrowse.text"));
        this.btnAdminBrowse.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.btnAdminBrowse.AccessibleContext.accessibleDescription"));
        this.btnAdminBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdminPropertiesPanel.this.btnAdminBrowseActionPerformed(actionEvent);
            }
        });
        this.txtAdminArgs.setText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtAdminArgs.text"));
        this.txtAdminArgs.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtAdminArgs.AccessibleContext.accessibleDescription"));
        this.messageLabel.setForeground(new Color(255, 0, 51));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.messageLabel.text"));
        this.labelAdmin.setHorizontalAlignment(4);
        this.labelAdmin.setLabelFor(this.txtAdmin);
        Mnemonics.setLocalizedText((JLabel)this.labelAdmin, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.labelAdmin.text"));
        this.labelAdminArgs.setHorizontalAlignment(4);
        this.labelAdminArgs.setLabelFor(this.txtAdminArgs);
        Mnemonics.setLocalizedText((JLabel)this.labelAdminArgs, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.labelAdminArgs.text"));
        this.labelStart.setHorizontalAlignment(4);
        this.labelStart.setLabelFor(this.txtStart);
        Mnemonics.setLocalizedText((JLabel)this.labelStart, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.labelStart.text"));
        this.txtStart.setText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtStart.text"));
        this.txtStart.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtStart.AccessibleContext.accessibleDescription"));
        this.txtStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdminPropertiesPanel.this.txtStartActionPerformed(actionEvent);
            }
        });
        this.txtStart.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                AdminPropertiesPanel.this.txtStartFocusLost(focusEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnStartBrowse, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.btnStartBrowse.text"));
        this.btnStartBrowse.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.btnStartBrowse.AccessibleContext.accessibleDescription"));
        this.btnStartBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdminPropertiesPanel.this.btnStartBrowseActionPerformed(actionEvent);
            }
        });
        this.txtStartArgs.setText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtStartArgs.text"));
        this.txtStartArgs.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtStartArgs.AccessibleContext.accessibleDescription"));
        this.labelStartArgs.setHorizontalAlignment(4);
        this.labelStartArgs.setLabelFor(this.txtStartArgs);
        Mnemonics.setLocalizedText((JLabel)this.labelStartArgs, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.labelStartArgs.text"));
        this.labelStop.setHorizontalAlignment(4);
        this.labelStop.setLabelFor(this.txtStop);
        Mnemonics.setLocalizedText((JLabel)this.labelStop, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.labelStop.text"));
        this.txtStop.setText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtStop.text"));
        this.txtStop.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtStop.AccessibleContext.accessibleDescription"));
        this.txtStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdminPropertiesPanel.this.txtStopActionPerformed(actionEvent);
            }
        });
        this.txtStop.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                AdminPropertiesPanel.this.txtStopFocusLost(focusEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnStopBrowse, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.btnStopBrowse.text"));
        this.btnStopBrowse.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.btnStopBrowse.AccessibleContext.accessibleDescription"));
        this.btnStopBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdminPropertiesPanel.this.btnStopBrowseActionPerformed(actionEvent);
            }
        });
        this.txtStopArgs.setText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtStopArgs.text"));
        this.txtStopArgs.setToolTipText(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtStopArgs.AccessibleContext.accessibleDescription"));
        this.labelStartArgs1.setHorizontalAlignment(4);
        this.labelStartArgs1.setLabelFor(this.txtStopArgs);
        Mnemonics.setLocalizedText((JLabel)this.labelStartArgs1, (String)NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.labelStopArgs.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.messageLabel, -1, 734, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (GroupLayout.Group)groupLayout.createParallelGroup(2, false).add(1, (Component)this.labelAdminArgs, -1, -1, Short.MAX_VALUE).add(1, (Component)this.labelStartArgs, -1, -1, Short.MAX_VALUE).add(1, (Component)this.labelStart, -1, 177, Short.MAX_VALUE).add(1, (Component)this.labelAdmin, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.labelStartArgs1, -1, -1, Short.MAX_VALUE).add((Component)this.labelStop, -1, -1, Short.MAX_VALUE))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.txtStopArgs, -1, 442, Short.MAX_VALUE).add((Component)this.txtStop, -1, 442, Short.MAX_VALUE).add((Component)this.txtAdmin, -1, 442, Short.MAX_VALUE).add((Component)this.txtAdminArgs, -1, 442, Short.MAX_VALUE).add(1, (Component)this.txtStart, -1, 442, Short.MAX_VALUE).add(1, (Component)this.txtStartArgs, -1, 442, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.btnStopBrowse).add((Component)this.btnStartBrowse).add((Component)this.btnAdminBrowse)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.btnAdminBrowse).add((Component)this.labelAdmin).add((Component)this.txtAdmin, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.labelAdminArgs, -2, 16, -2).add((Component)this.txtAdminArgs, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.labelStart).add((Component)this.btnStartBrowse).add((Component)this.txtStart, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.labelStartArgs, -2, 16, -2).add((Component)this.txtStartArgs, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.btnStopBrowse).add((Component)this.labelStop).add((Component)this.txtStop, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.labelStartArgs1, -2, 16, -2).add((Component)this.txtStopArgs, -2, -1, -2)).addPreferredGap(1).add((Component)this.messageLabel).add(108, 108, 108)));
        this.txtAdmin.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtAdmin.AccessibleContext.accessibleDescription"));
        this.btnAdminBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.btnAdminBrowse.AccessibleContext.accessibleDescription"));
        this.txtAdminArgs.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtAdminArgs.AccessibleContext.accessibleName"));
        this.txtAdminArgs.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdminPropertiesPanel.class, (String)"AdminPropertiesPanel.txtAdminArgs.AccessibleContext.accessibleDescription"));
    }

    private void btnAdminBrowseActionPerformed(ActionEvent actionEvent) {
        this.chooseFile(this.txtAdmin);
    }

    private void txtAdminFocusLost(FocusEvent focusEvent) {
        this.validatePanel();
    }

    private void txtAdminActionPerformed(ActionEvent actionEvent) {
    }

    private void txtStartActionPerformed(ActionEvent actionEvent) {
    }

    private void txtStartFocusLost(FocusEvent focusEvent) {
        this.validatePanel();
    }

    private void btnStartBrowseActionPerformed(ActionEvent actionEvent) {
        this.chooseFile(this.txtStart);
    }

    private void txtStopActionPerformed(ActionEvent actionEvent) {
    }

    private void txtStopFocusLost(FocusEvent focusEvent) {
        this.validatePanel();
    }

    private void btnStopBrowseActionPerformed(ActionEvent actionEvent) {
        this.chooseFile(this.txtStop);
    }
}

