/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.api.sql.execute.SQLExecutor;
import org.netbeans.modules.db.mysql.spi.sample.SampleProvider;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.JarFileSystem;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSampleProvider
implements SampleProvider {
    private static final Logger LOGGER = Logger.getLogger(BaseSampleProvider.class.getName());
    private static final BaseSampleProvider DEFAULT = new BaseSampleProvider();
    private static ArrayList<String> SAMPLES = new ArrayList();
    private static final String MODULE_JAR_FILE = "modules/org-netbeans-modules-db-mysql.jar";
    private static final String RESOURCE_DIR_PATH = "org/netbeans/modules/db/mysql/resources";

    private String getMessage(String string, String ... stringArray) {
        return NbBundle.getMessage(BaseSampleProvider.class, (String)string, (Object[])stringArray);
    }

    public static BaseSampleProvider getDefault() {
        return DEFAULT;
    }

    @Override
    public void create(String string, DatabaseConnection databaseConnection) throws DatabaseException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (!SAMPLES.contains(string)) {
            throw new DatabaseException(this.getMessage("MSG_SampleNotSupported", string));
        }
        if (!this.checkInnodbSupport(databaseConnection.getJDBCConnection())) {
            throw new DatabaseException(this.getMessage("MSG_NoSampleWithoutInnoDB", new String[0]));
        }
        String string2 = BaseSampleProvider.getSqlText(string);
        SQLExecutor.execute((DatabaseConnection)databaseConnection, (String)string2);
    }

    @Override
    public boolean supportsSample(String string) {
        return SAMPLES.contains(string);
    }

    private boolean checkInnodbSupport(Connection connection) throws DatabaseException {
        try {
            ResultSet resultSet = connection.createStatement().executeQuery("SHOW STORAGE ENGINES");
            while (resultSet.next()) {
                if (!"INNODB".equals(resultSet.getString(1).toUpperCase()) || !"YES".equals(resultSet.getString(2).toUpperCase()) && !"DEFAULT".equals(resultSet.getString(2).toUpperCase())) continue;
                return true;
            }
            return false;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException((Throwable)sQLException);
        }
    }

    @Override
    public List<String> getSampleNames() {
        return SAMPLES;
    }

    private static String getSqlText(String string) throws DatabaseException {
        FileObject fileObject = BaseSampleProvider.getSampleFile(string);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream()));
            char[] cArray = new char[100];
            while (true) {
                int n;
                if ((n = bufferedReader.read(cArray)) < 0) {
                    bufferedReader.close();
                    break;
                }
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new DatabaseException((Throwable)iOException);
        }
        return stringBuilder.toString().trim();
    }

    private static FileObject getSampleFile(String string) throws DatabaseException {
        try {
            File file = InstalledFileLocator.getDefault().locate(MODULE_JAR_FILE, null, false);
            JarFileSystem jarFileSystem = new JarFileSystem();
            jarFileSystem.setJarFile(file);
            String string2 = "/create-" + string + ".sql";
            return jarFileSystem.findResource(RESOURCE_DIR_PATH + string2);
        }
        catch (Exception exception) {
            DatabaseException databaseException = new DatabaseException(Utils.getMessage("MSG_ErrorLoadingSampleSQL", string, exception.getMessage()));
            databaseException.initCause((Throwable)exception);
            throw databaseException;
        }
    }

    static {
        SAMPLES.add("sample");
        SAMPLES.add("vir");
        SAMPLES.add("travel");
    }
}

