/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobConf;

public class MapRedTask
extends ExecDriver
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String HADOOP_MEM_KEY = "HADOOP_HEAPSIZE";
    static final String HADOOP_OPTS_KEY = "HADOOP_OPTS";
    static final String HADOOP_CLIENT_OPTS = "HADOOP_CLIENT_OPTS";
    static final String HIVE_DEBUG_RECURSIVE = "HIVE_DEBUG_RECURSIVE";
    static final String HIVE_MAIN_CLIENT_DEBUG_OPTS = "HIVE_MAIN_CLIENT_DEBUG_OPTS";
    static final String HIVE_CHILD_CLIENT_DEBUG_OPTS = "HIVE_CHILD_CLIENT_DEBUG_OPTS";
    static final String[] HIVE_SYS_PROP = new String[]{"build.dir", "build.dir.hive"};
    private transient ContentSummary inputSummary = null;
    private transient boolean runningViaChild = false;
    private transient boolean inputSizeEstimated = false;
    private transient long totalInputFileSize;
    private transient long totalInputNumFiles;

    public MapRedTask() {
    }

    public MapRedTask(MapredWork plan, JobConf job, boolean isSilent) throws HiveException {
        throw new RuntimeException("Illegal Constructor call");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(DriverContext driverContext) {
        Context ctx = driverContext.getCtx();
        boolean ctxCreated = false;
        try {
            int numReducers;
            if (ctx == null) {
                ctx = new Context(this.conf);
                ctxCreated = true;
            }
            this.setNumberOfReducers();
            if (!ctx.isLocalOnlyExecutionMode() && this.conf.getBoolVar(HiveConf.ConfVars.LOCALMODEAUTO)) {
                String reason;
                if (this.inputSummary == null) {
                    this.inputSummary = Utilities.getInputSummary(driverContext.getCtx(), (MapredWork)this.work, null);
                }
                this.estimateInputSize();
                numReducers = ((MapredWork)this.work).getNumReduceTasks();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Task: " + this.getId() + ", Summary: " + this.totalInputFileSize + "," + this.totalInputNumFiles + "," + numReducers));
                }
                if ((reason = MapRedTask.isEligibleForLocalMode(this.conf, numReducers, this.totalInputFileSize, this.totalInputNumFiles)) == null) {
                    this.cloneConf();
                    this.conf.setVar(HiveConf.ConfVars.HADOOPJT, "local");
                    this.console.printInfo("Selecting local mode for task: " + this.getId());
                    this.setLocalMode(true);
                } else {
                    this.console.printInfo("Cannot run job locally: " + reason);
                    this.setLocalMode(false);
                }
            }
            boolean bl = this.runningViaChild = "local".equals(this.conf.getVar(HiveConf.ConfVars.HADOOPJT)) || this.conf.getBoolVar(HiveConf.ConfVars.SUBMITVIACHILD);
            if (!this.runningViaChild) {
                numReducers = super.execute(driverContext);
                return numReducers;
            }
            this.cloneConf();
            super.setInputAttributes(this.conf);
            String hadoopExec = this.conf.getVar(HiveConf.ConfVars.HADOOPBIN);
            String hiveJar = this.conf.getJar();
            String addedJars = MapRedTask.getResourceFiles(this.conf, SessionState.ResourceType.JAR);
            this.conf.setVar(HiveConf.ConfVars.HIVEADDEDJARS, addedJars);
            String auxJars = this.conf.getAuxJars();
            String libJarsOption = StringUtils.isEmpty(addedJars) ? (StringUtils.isEmpty(auxJars) ? " " : " -libjars " + auxJars + " ") : (StringUtils.isEmpty(auxJars) ? " -libjars " + addedJars + " " : " -libjars " + addedJars + "," + auxJars + " ");
            String hiveConfArgs = MapRedTask.generateCmdLine(this.conf);
            Path planPath = new Path(ctx.getLocalTmpFileURI(), "plan.xml");
            FSDataOutputStream out = FileSystem.getLocal((Configuration)this.conf).create(planPath);
            MapredWork plan = (MapredWork)this.getWork();
            LOG.info((Object)("Generating plan file " + planPath.toString()));
            Utilities.serializeMapRedWork(plan, (OutputStream)out);
            String isSilent = "true".equalsIgnoreCase(System.getProperty("test.silent")) ? "-nolog" : "";
            String jarCmd = ShimLoader.getHadoopShims().usesJobShell() ? libJarsOption + hiveJar + " " + ExecDriver.class.getName() : hiveJar + " " + ExecDriver.class.getName() + libJarsOption;
            String cmdLine = hadoopExec + " jar " + jarCmd + " -plan " + planPath.toString() + " " + isSilent + " " + hiveConfArgs;
            String workDir = new File(".").getCanonicalPath();
            String files = MapRedTask.getResourceFiles(this.conf, SessionState.ResourceType.FILE);
            if (!files.isEmpty()) {
                cmdLine = cmdLine + " -files " + files;
                workDir = new Path(ctx.getLocalTmpFileURI()).toUri().getPath();
                if (!new File(workDir).mkdir()) {
                    throw new IOException("Cannot create tmp working dir: " + workDir);
                }
                for (String f : StringUtils.split(files, ',')) {
                    String link;
                    Path p = new Path(f);
                    String target = p.toUri().getPath();
                    if (FileUtil.symLink((String)target, (String)(link = workDir + "/" + p.getName())) == 0) continue;
                    throw new IOException("Cannot link to added file: " + target + " from: " + link);
                }
            }
            LOG.info((Object)("Executing: " + cmdLine));
            Process executor = null;
            StringBuilder sb = new StringBuilder();
            Properties p = System.getProperties();
            for (String element : HIVE_SYS_PROP) {
                if (!p.containsKey(element)) continue;
                sb.append(" -D" + element + "=" + p.getProperty(element));
            }
            String hadoopOpts = sb.toString();
            HashMap<String, String> variables = new HashMap<String, String>(System.getenv());
            if ("local".equals(this.conf.getVar(HiveConf.ConfVars.HADOOPJT))) {
                int hadoopMem = this.conf.getIntVar(HiveConf.ConfVars.HIVEHADOOPMAXMEM);
                if (hadoopMem == 0) {
                    variables.remove(HADOOP_MEM_KEY);
                } else {
                    variables.put(HADOOP_MEM_KEY, String.valueOf(hadoopMem));
                }
            }
            if (variables.containsKey(HADOOP_OPTS_KEY)) {
                variables.put(HADOOP_OPTS_KEY, (String)variables.get(HADOOP_OPTS_KEY) + hadoopOpts);
            } else {
                variables.put(HADOOP_OPTS_KEY, hadoopOpts);
            }
            if (variables.containsKey(HIVE_DEBUG_RECURSIVE)) {
                MapRedTask.configureDebugVariablesForChildJVM(variables);
            }
            String[] env = new String[variables.size()];
            int pos = 0;
            for (Map.Entry entry : variables.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                env[pos++] = name + "=" + value;
            }
            executor = Runtime.getRuntime().exec(cmdLine, env, new File(workDir));
            Utilities.StreamPrinter outPrinter = new Utilities.StreamPrinter(executor.getInputStream(), null, SessionState.getConsole().getChildOutStream());
            Utilities.StreamPrinter errPrinter = new Utilities.StreamPrinter(executor.getErrorStream(), null, SessionState.getConsole().getChildErrStream());
            outPrinter.start();
            errPrinter.start();
            int exitVal = this.jobExecHelper.progressLocal(executor, this.getId());
            if (exitVal != 0) {
                LOG.error((Object)("Execution failed with exit status: " + exitVal));
            } else {
                LOG.info((Object)"Execution completed successfully");
            }
            int n = exitVal;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error((Object)("Exception: " + e.getMessage()));
            int n = 1;
            return n;
        }
        finally {
            try {
                if (ctxCreated) {
                    ctx.clear();
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Exception: " + e.getMessage()));
            }
        }
    }

    static void configureDebugVariablesForChildJVM(Map<String, String> environmentVariables) {
        assert (environmentVariables.containsKey(HADOOP_CLIENT_OPTS) && environmentVariables.get(HADOOP_CLIENT_OPTS) != null) : "HADOOP_CLIENT_OPTS environment variable must be set when JVM in debug mode";
        String hadoopClientOpts = environmentVariables.get(HADOOP_CLIENT_OPTS);
        assert (environmentVariables.containsKey(HIVE_MAIN_CLIENT_DEBUG_OPTS) && environmentVariables.get(HIVE_MAIN_CLIENT_DEBUG_OPTS) != null) : "HIVE_MAIN_CLIENT_DEBUG_OPTS environment variable must be set when JVM in debug mode";
        assert (hadoopClientOpts.contains(environmentVariables.get(HIVE_MAIN_CLIENT_DEBUG_OPTS))) : "HADOOP_CLIENT_OPTS environment variable must contain debugging parameters, when JVM in debugging mode";
        assert ("y".equals(environmentVariables.get(HIVE_DEBUG_RECURSIVE)) || "n".equals(environmentVariables.get(HIVE_DEBUG_RECURSIVE))) : "HIVE_DEBUG_RECURSIVE environment variable must be set to \"y\" or \"n\" when debugging";
        if (environmentVariables.get(HIVE_DEBUG_RECURSIVE).equals("y")) {
            assert (environmentVariables.containsKey(HIVE_CHILD_CLIENT_DEBUG_OPTS) && environmentVariables.get(HIVE_MAIN_CLIENT_DEBUG_OPTS) != null) : "HIVE_CHILD_CLIENT_DEBUG_OPTS environment variable must be set when JVM in debug mode";
            String newHadoopClientOpts = hadoopClientOpts.replace(environmentVariables.get(HIVE_MAIN_CLIENT_DEBUG_OPTS), environmentVariables.get(HIVE_CHILD_CLIENT_DEBUG_OPTS));
            environmentVariables.put(HADOOP_CLIENT_OPTS, newHadoopClientOpts);
        } else {
            String newHadoopClientOpts = hadoopClientOpts.replace(environmentVariables.get(HIVE_MAIN_CLIENT_DEBUG_OPTS), "").trim();
            if (newHadoopClientOpts.isEmpty()) {
                environmentVariables.remove(HADOOP_CLIENT_OPTS);
            } else {
                environmentVariables.put(HADOOP_CLIENT_OPTS, newHadoopClientOpts);
            }
        }
        environmentVariables.remove(HIVE_DEBUG_RECURSIVE);
    }

    @Override
    public boolean mapStarted() {
        boolean b = super.mapStarted();
        return this.runningViaChild ? this.isdone : b;
    }

    @Override
    public boolean reduceStarted() {
        boolean b = super.reduceStarted();
        return this.runningViaChild ? this.isdone : b;
    }

    @Override
    public boolean mapDone() {
        boolean b = super.mapDone();
        return this.runningViaChild ? this.isdone : b;
    }

    @Override
    public boolean reduceDone() {
        boolean b = super.reduceDone();
        return this.runningViaChild ? this.isdone : b;
    }

    private void setNumberOfReducers() throws IOException {
        Integer numReducersFromWork = ((MapredWork)this.work).getNumReduceTasks();
        if (((MapredWork)this.work).getReducer() == null) {
            this.console.printInfo("Number of reduce tasks is set to 0 since there's no reduce operator");
            ((MapredWork)this.work).setNumReduceTasks(0);
        } else {
            if (numReducersFromWork >= 0) {
                this.console.printInfo("Number of reduce tasks determined at compile time: " + ((MapredWork)this.work).getNumReduceTasks());
            } else if (this.job.getNumReduceTasks() > 0) {
                int reducers = this.job.getNumReduceTasks();
                ((MapredWork)this.work).setNumReduceTasks(reducers);
                this.console.printInfo("Number of reduce tasks not specified. Defaulting to jobconf value of: " + reducers);
            } else {
                int reducers = this.estimateNumberOfReducers();
                ((MapredWork)this.work).setNumReduceTasks(reducers);
                this.console.printInfo("Number of reduce tasks not specified. Estimated from input data size: " + reducers);
            }
            this.console.printInfo("In order to change the average load for a reducer (in bytes):");
            this.console.printInfo("  set " + HiveConf.ConfVars.BYTESPERREDUCER.varname + "=<number>");
            this.console.printInfo("In order to limit the maximum number of reducers:");
            this.console.printInfo("  set " + HiveConf.ConfVars.MAXREDUCERS.varname + "=<number>");
            this.console.printInfo("In order to set a constant number of reducers:");
            this.console.printInfo("  set " + (Object)((Object)HiveConf.ConfVars.HADOOPNUMREDUCERS) + "=<number>");
        }
    }

    private int estimateNumberOfReducers() throws IOException {
        long bytesPerReducer = this.conf.getLongVar(HiveConf.ConfVars.BYTESPERREDUCER);
        int maxReducers = this.conf.getIntVar(HiveConf.ConfVars.MAXREDUCERS);
        if (this.inputSummary == null) {
            this.inputSummary = Utilities.getInputSummary(this.driverContext.getCtx(), (MapredWork)this.work, null);
        }
        this.estimateInputSize();
        if (this.totalInputFileSize != this.inputSummary.getLength()) {
            LOG.info((Object)("BytesPerReducer=" + bytesPerReducer + " maxReducers=" + maxReducers + " estimated totalInputFileSize=" + this.totalInputFileSize));
        } else {
            LOG.info((Object)("BytesPerReducer=" + bytesPerReducer + " maxReducers=" + maxReducers + " totalInputFileSize=" + this.totalInputFileSize));
        }
        int reducers = (int)((this.totalInputFileSize + bytesPerReducer - 1L) / bytesPerReducer);
        reducers = Math.max(1, reducers);
        reducers = Math.min(maxReducers, reducers);
        return reducers;
    }

    private void estimateInputSize() {
        if (this.inputSizeEstimated) {
            return;
        }
        this.totalInputFileSize = this.inputSummary.getLength();
        this.totalInputNumFiles = this.inputSummary.getFileCount();
        if (((MapredWork)this.work).getNameToSplitSample() == null || ((MapredWork)this.work).getNameToSplitSample().isEmpty()) {
            this.inputSizeEstimated = true;
            return;
        }
        double highestSamplePercentage = 0.0;
        boolean allSample = false;
        for (String alias : ((MapredWork)this.work).getAliasToWork().keySet()) {
            if (((MapredWork)this.work).getNameToSplitSample().containsKey(alias)) {
                allSample = true;
                double rate = ((MapredWork)this.work).getNameToSplitSample().get(alias).getPercent();
                if (!(rate > highestSamplePercentage)) continue;
                highestSamplePercentage = rate;
                continue;
            }
            allSample = false;
            break;
        }
        if (allSample) {
            this.totalInputFileSize = Math.min((long)((double)this.totalInputFileSize * highestSamplePercentage / 100.0), this.totalInputFileSize);
            this.totalInputNumFiles = Math.min((long)((double)this.totalInputNumFiles * highestSamplePercentage / 100.0), this.totalInputNumFiles);
        }
        this.inputSizeEstimated = true;
    }

    public static String isEligibleForLocalMode(HiveConf conf, int numReducers, long inputLength, long inputFileCount) {
        long maxBytes = conf.getLongVar(HiveConf.ConfVars.LOCALMODEMAXBYTES);
        long maxTasks = conf.getIntVar(HiveConf.ConfVars.LOCALMODEMAXTASKS);
        if (inputLength > maxBytes) {
            return "Input Size (= " + inputLength + ") is larger than " + HiveConf.ConfVars.LOCALMODEMAXBYTES.varname + " (= " + maxBytes + ")";
        }
        if (inputFileCount > maxTasks) {
            return "Number of Input Files (= " + inputFileCount + ") is larger than " + HiveConf.ConfVars.LOCALMODEMAXTASKS.varname + "(= " + maxTasks + ")";
        }
        if (numReducers > 1) {
            return "Number of reducers (= " + numReducers + ") is more than 1";
        }
        return null;
    }

    @Override
    public Operator<? extends Serializable> getReducer() {
        return ((MapredWork)this.getWork()).getReducer();
    }
}

