/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons.layers;

import com.jaspersoft.ireport.addons.layers.Layer;
import com.jaspersoft.ireport.addons.layers.LayersSupport;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class LayersAction
extends NodeAction {
    JMenu menu = null;

    protected void performAction(Node[] nodes) {
    }

    public void sendElementsToLayer(Layer layer) {
        Node[] nodes = this.getActivatedNodes();
        block0: for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof ElementNode)) continue;
            ElementNode node = (ElementNode)nodes[i];
            LayersSupport.getInstance().addElementToLayer(node.getElement(), layer);
            ReportObjectScene scene = IReportManager.getInstance().getActiveVisualView().getReportDesignerPanel().getScene();
            List list = scene.getElementsLayer().getChildren();
            for (Widget w : list) {
                JRDesignElementWidget ew;
                if (!(w instanceof JRDesignElementWidget) || (ew = (JRDesignElementWidget)w).getElement() != node.getElement()) continue;
                if (!layer.isVisible()) {
                    IReportManager.getInstance().removeSelectedObject((Object)ew.getElement());
                }
                ew.setVisible(layer.isVisible());
                ew.getSelectionWidget().setVisible(layer.isVisible());
                scene.revalidate(true);
                scene.validate();
                continue block0;
            }
        }
    }

    protected boolean enable(Node[] nodes) {
        this.getMenu().setEnabled(false);
        if (nodes == null || nodes.length < 1) {
            return false;
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] instanceof ElementNode) continue;
            return false;
        }
        this.getMenu().setEnabled(true);
        this.rebuildMenu();
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(LayersAction.class, (String)"LayersAction.name");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public JMenuItem getMenuPresenter() {
        return this.getMenu();
    }

    public JMenuItem getPopupPresenter() {
        return this.getMenu();
    }

    public void jasperDesignActivated(JasperDesign jd) {
        this.menu.removeAll();
    }

    public JMenu getMenu() {
        if (this.menu == null) {
            this.menu = new JMenu(this.getName());
        }
        return this.menu;
    }

    public void setMenu(JMenu menu) {
        this.menu = menu;
    }

    private void rebuildMenu() {
        this.getMenu().removeAll();
        List<Layer> layers = LayersSupport.getInstance().getLayers();
        for (final Layer layer : layers) {
            JMenuItem item = new JMenuItem(layer.getName());
            this.getMenu().add((Component)item, 0);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayersAction.this.sendElementsToLayer(layer);
                }
            });
        }
    }
}

