/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.mdi;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import nickyb.sqleonardo.common.gui.AbstractDialogConfirm;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.environment.Application;

public class DialogQuickObject
extends AbstractDialogConfirm
implements ItemListener {
    private boolean terminated = false;
    private JComboBox cbxConnections;
    private JComboBox cbxSchemas;
    private JTextField txtName;

    private DialogQuickObject(String title) {
        super((Component)Application.window, title, 350, 230);
        this.setDefaultCloseOperation(1);
        this.cbxConnections = new JComboBox<Object>(ConnectionAssistant.getHandlers().toArray());
        this.cbxSchemas = new JComboBox();
        this.txtName = new JTextField();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel pnl = new JPanel();
        pnl.setLayout(gbl);
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 8, 0, 8);
        JLabel lbl = new JLabel("use connection:");
        gbl.setConstraints(lbl, gbc);
        pnl.add(lbl);
        gbl.setConstraints(this.cbxConnections, gbc);
        pnl.add(this.cbxConnections);
        gbc.insets = new Insets(5, 8, 0, 8);
        lbl = new JLabel("schema:");
        gbl.setConstraints(lbl, gbc);
        pnl.add(lbl);
        gbc.insets = new Insets(0, 8, 0, 8);
        gbl.setConstraints(this.cbxSchemas, gbc);
        pnl.add(this.cbxSchemas);
        gbc.insets = new Insets(5, 8, 0, 8);
        lbl = new JLabel("table:");
        gbl.setConstraints(lbl, gbc);
        pnl.add(lbl);
        gbc.insets = new Insets(0, 8, 0, 8);
        gbl.setConstraints(this.txtName, gbc);
        pnl.add(this.txtName);
        this.getContentPane().add(new JScrollPane(pnl));
    }

    public static Object[] show(String title) {
        DialogQuickObject dlg = new DialogQuickObject(title);
        dlg.setVisible(true);
        return DialogQuickObject.onDispose(dlg);
    }

    private static Object[] onDispose(DialogQuickObject dlg) {
        Object[] ret = null;
        if (dlg.terminated) {
            String keycah = dlg.cbxConnections.getSelectedItem().toString();
            String name = dlg.txtName.getText().trim();
            try {
                ConnectionHandler ch = ConnectionAssistant.getHandler(keycah);
                DatabaseMetaData dbmetadata = ch.get().getMetaData();
                if (dbmetadata.storesLowerCaseIdentifiers()) {
                    name = name.toLowerCase();
                } else if (dbmetadata.storesUpperCaseIdentifiers()) {
                    name = name.toUpperCase();
                }
            }
            catch (SQLException sql) {
                Application.println(sql, true);
            }
            ret = new Object[]{keycah, dlg.cbxSchemas.getSelectedItem(), name};
        }
        dlg.dispose();
        return ret;
    }

    protected boolean onConfirm() {
        if (this.cbxConnections.getSelectedItem() == null) {
            return false;
        }
        if (this.cbxSchemas.isEnabled() && this.cbxSchemas.getSelectedItem() == null) {
            return false;
        }
        if (this.txtName.getText().trim().length() == 0) {
            return false;
        }
        this.terminated = true;
        return true;
    }

    protected void onOpen() {
        this.cbxConnections.addItemListener(this);
        this.cbxConnections.setSelectedItem(null);
        this.cbxSchemas.setSelectedItem(null);
        this.cbxSchemas.setEnabled(false);
    }

    public void itemStateChanged(ItemEvent ie) {
        ConnectionHandler ch = ConnectionAssistant.getHandler(ie.getItem().toString());
        if (ch == null) {
            this.cbxSchemas.setModel(new DefaultComboBoxModel());
        } else {
            ArrayList schemas = (ArrayList)ch.getObject("$schema_names");
            this.cbxSchemas.setModel(new DefaultComboBoxModel<Object>(schemas.toArray()));
        }
        this.cbxSchemas.setEnabled(this.cbxSchemas.getItemCount() > 0);
    }
}

