/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.nodes;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseMetaDataTransfer;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseMetaDataTransferAccessor;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.nodes.DatabaseNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.ExTransferable;

public class ConnectionNode
extends DatabaseNode
implements ChangeListener {
    private static final Logger LOGGER = Logger.getLogger(ConnectionNode.class.getName());
    private boolean createPropSupport = true;

    public ConnectionNode(DatabaseNodeInfo databaseNodeInfo) {
        super(databaseNodeInfo);
    }

    public void setInfo(DatabaseNodeInfo databaseNodeInfo) {
        super.setInfo(databaseNodeInfo);
        this.getCookieSet().add((Node.Cookie)this);
        databaseNodeInfo.addChangeListener((ChangeListener)WeakListeners.create(ChangeListener.class, (EventListener)this, (Object)databaseNodeInfo));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        super.stateChanged(changeEvent);
        this.update();
    }

    private boolean createPropSupport() {
        return this.createPropSupport;
    }

    private void setPropSupport(boolean bl) {
        this.createPropSupport = bl;
    }

    private void update() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                DatabaseNodeInfo databaseNodeInfo = ConnectionNode.this.getInfo();
                boolean bl = databaseNodeInfo.getConnection() != null;
                ConnectionNode.this.setIconBase((String)databaseNodeInfo.get(bl ? "activeiconbase" : "iconbase"));
                Sheet.Set set = ConnectionNode.this.getSheet().get("properties");
                try {
                    if (ConnectionNode.this.createPropSupport()) {
                        Node.Property property = set.get("db");
                        PropertySupport propertySupport = ConnectionNode.this.createPropertySupport(property.getName(), property.getValueType(), property.getDisplayName(), property.getShortDescription(), databaseNodeInfo, !bl);
                        set.put((Node.Property)propertySupport);
                        ConnectionNode.this.firePropertyChange("db", property, propertySupport);
                        Node.Property property2 = set.get("driver");
                        PropertySupport propertySupport2 = ConnectionNode.this.createPropertySupport(property2.getName(), property2.getValueType(), property2.getDisplayName(), property2.getShortDescription(), databaseNodeInfo, !bl);
                        set.put((Node.Property)propertySupport2);
                        ConnectionNode.this.firePropertyChange("driver", property2, propertySupport2);
                        Node.Property property3 = set.get("schema");
                        PropertySupport propertySupport3 = ConnectionNode.this.createPropertySupport(property3.getName(), property3.getValueType(), property3.getDisplayName(), property3.getShortDescription(), databaseNodeInfo, !bl);
                        set.put((Node.Property)propertySupport3);
                        ConnectionNode.this.firePropertyChange("schema", property3, propertySupport3);
                        Node.Property property4 = set.get("user");
                        PropertySupport propertySupport4 = ConnectionNode.this.createPropertySupport(property4.getName(), property4.getValueType(), property4.getDisplayName(), property4.getShortDescription(), databaseNodeInfo, !bl);
                        set.put((Node.Property)propertySupport4);
                        ConnectionNode.this.firePropertyChange("user", property4, propertySupport4);
                        Node.Property property5 = set.get("rememberpwd");
                        PropertySupport propertySupport5 = ConnectionNode.this.createPropertySupport(property5.getName(), property5.getValueType(), property5.getDisplayName(), property5.getShortDescription(), databaseNodeInfo, bl);
                        set.put((Node.Property)propertySupport5);
                        ConnectionNode.this.firePropertyChange("rememberpwd", property5, propertySupport5);
                        ConnectionNode.this.setPropSupport(false);
                    } else {
                        Node.Property property = set.get("db");
                        set.put(property);
                        ConnectionNode.this.firePropertyChange("db", null, property);
                        Node.Property property6 = set.get("driver");
                        ConnectionNode.this.firePropertyChange("driver", null, property6);
                        Node.Property property7 = set.get("schema");
                        ConnectionNode.this.firePropertyChange("schema", null, property7);
                        Node.Property property8 = set.get("user");
                        ConnectionNode.this.firePropertyChange("user", null, property8);
                        Node.Property property9 = set.get("rememberpwd");
                        ConnectionNode.this.firePropertyChange("rememberpwd", null, property9);
                    }
                }
                catch (Exception exception) {
                    LOGGER.log(Level.INFO, null, exception);
                }
            }
        });
    }

    public boolean canDestroy() {
        return !this.getInfo().isConnected();
    }

    public String getShortDescription() {
        return NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ND_Connection");
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
        ConnectionNodeInfo connectionNodeInfo = (ConnectionNodeInfo)this.getInfo().getParent("connection");
        final DatabaseConnection databaseConnection = ConnectionList.getDefault().getConnection(connectionNodeInfo.getDatabaseConnection());
        exTransferable.put(new ExTransferable.Single(DatabaseMetaDataTransfer.CONNECTION_FLAVOR){

            protected Object getData() {
                return DatabaseMetaDataTransferAccessor.DEFAULT.createConnectionData(databaseConnection.getDatabaseConnection(), databaseConnection.findJDBCDriver());
            }
        });
        return exTransferable;
    }
}

