/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabObjectFactory;
import net.sf.jasperreports.crosstabs.type.CrosstabColumnPositionEnum;
import net.sf.jasperreports.crosstabs.type.CrosstabRowPositionEnum;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleSetter;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRClonePool;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JROriginProvider;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.type.ModeEnum;
import org.apache.commons.collections.ReferenceMap;

public class JRFillCellContents
extends JRFillElementContainer
implements JRCellContents,
JRStyleSetter {
    private final Map<StretchedContents, JRFillCellContents> transformedContentsCache;
    private final Map<BoxContents, JRFillCellContents> boxContentsCache;
    private final JRClonePool clonePool;
    private final JROriginProvider originProvider;
    private final int elementId;
    private JRFillCellContents original;
    private final JRCellContents parentCell;
    private final String cellType;
    private JRLineBox lineBox;
    private int height;
    private int width;
    private int x;
    private int y;
    private int verticalSpan;
    private CrosstabRowPositionEnum verticalPositionType = CrosstabRowPositionEnum.TOP;
    private int horizontalSpan;
    private Map<JRStyle, JRTemplateFrame> templateFrames;
    private JRDefaultStyleProvider defaultStyleProvider;
    private JRStyle initStyle;
    private int prepareStretchHeight;

    public JRFillCellContents(JRBaseFiller filler, JRCellContents cell, String cellType, JRFillCrosstabObjectFactory factory) {
        super(filler, cell, factory);
        this.defaultStyleProvider = factory.getDefaultStyleProvider();
        this.parentCell = cell;
        this.cellType = cellType;
        this.elementId = filler.getFillContext().generateFillElementId();
        this.lineBox = cell.getLineBox().clone(this);
        this.width = cell.getWidth();
        this.height = cell.getHeight();
        factory.registerDelayedStyleSetter((JRStyleSetter)this, this.parentCell);
        this.initElements();
        this.initConditionalStyles();
        this.initTemplatesMap();
        this.originProvider = factory.getParentOriginProvider();
        this.setElementOriginProvider(this.originProvider);
        this.transformedContentsCache = new ReferenceMap();
        this.boxContentsCache = new HashMap<BoxContents, JRFillCellContents>();
        this.clonePool = new JRClonePool(this, true, true);
    }

    private void initTemplatesMap() {
        this.templateFrames = new HashMap<JRStyle, JRTemplateFrame>();
    }

    protected JRFillCellContents(JRFillCellContents cellContents, JRFillCloneFactory factory) {
        super(cellContents, factory);
        this.defaultStyleProvider = cellContents.defaultStyleProvider;
        this.parentCell = cellContents.parentCell;
        this.cellType = cellContents.cellType;
        this.elementId = cellContents.elementId;
        this.lineBox = cellContents.getLineBox().clone(this);
        this.width = cellContents.width;
        this.height = cellContents.height;
        this.initStyle = cellContents.initStyle;
        this.initElements();
        this.initConditionalStyles();
        this.templateFrames = cellContents.templateFrames;
        this.originProvider = cellContents.originProvider;
        this.transformedContentsCache = new ReferenceMap();
        this.boxContentsCache = new HashMap<BoxContents, JRFillCellContents>();
        this.clonePool = new JRClonePool(this, true, true);
        this.verticalPositionType = cellContents.verticalPositionType;
    }

    @Override
    public Color getBackcolor() {
        return this.parentCell.getBackcolor();
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    protected void setBox(JRLineBox box) {
        this.lineBox = box;
        this.initTemplatesMap();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    protected void setHeight(int height) {
        this.height = height;
    }

    protected void setWidth(int width) {
        this.width = width;
    }

    public JRFillCellContents getBoxContents(boolean left, boolean right, boolean top) {
        boolean copyTop;
        if (this.lineBox == null) {
            return this;
        }
        boolean copyLeft = left && this.lineBox.getLeftPen().getLineWidth().floatValue() <= 0.0f && this.lineBox.getRightPen().getLineWidth().floatValue() > 0.0f;
        boolean copyRight = right && this.lineBox.getRightPen().getLineWidth().floatValue() <= 0.0f && this.lineBox.getLeftPen().getLineWidth().floatValue() > 0.0f;
        boolean bl = copyTop = top && this.lineBox.getTopPen().getLineWidth().floatValue() <= 0.0f && this.lineBox.getBottomPen().getLineWidth().floatValue() > 0.0f;
        if (!(copyLeft || copyRight || copyTop)) {
            return this;
        }
        BoxContents key = new BoxContents(copyLeft, copyRight, copyTop);
        JRFillCellContents boxContents = this.boxContentsCache.get(key);
        if (boxContents == null) {
            boxContents = (JRFillCellContents)this.createClone();
            JRLineBox newBox = this.lineBox.clone(this);
            if (copyLeft) {
                newBox.copyLeftPen(this.lineBox.getRightPen());
            }
            if (copyRight) {
                newBox.copyRightPen(this.lineBox.getLeftPen());
            }
            if (copyTop) {
                newBox.copyTopPen(this.lineBox.getBottomPen());
            }
            boxContents.setBox(newBox);
            this.boxContentsCache.put(key, boxContents);
        }
        return boxContents;
    }

    public JRFillCellContents getTransformedContents(int newWidth, int newHeight, CrosstabColumnPositionEnum xPosition, CrosstabRowPositionEnum yPosition) throws JRException {
        if (this.getHeight() == newHeight && this.getWidth() == newWidth) {
            return this;
        }
        if (newHeight < this.getHeight() || newWidth < this.getWidth()) {
            throw new JRException("Cannot shrink cell contents.");
        }
        StretchedContents key = new StretchedContents(newWidth, newHeight, xPosition, yPosition);
        JRFillCellContents transformedCell = this.transformedContentsCache.get(key);
        if (transformedCell == null) {
            transformedCell = (JRFillCellContents)this.createClone();
            transformedCell.transform(newWidth, newHeight, xPosition, yPosition);
            this.transformedContentsCache.put(key, transformedCell);
        }
        return transformedCell;
    }

    private void transform(int newWidth, int newHeight, CrosstabColumnPositionEnum xPosition, CrosstabRowPositionEnum yPosition) {
        this.transformElements(newWidth, newHeight, xPosition, yPosition);
        this.width = newWidth;
        this.height = newHeight;
    }

    private void transformElements(int newWidth, int newHeight, CrosstabColumnPositionEnum xPosition, CrosstabRowPositionEnum yPosition) {
        if (!(this.height != newHeight && yPosition != CrosstabRowPositionEnum.TOP || this.width != newWidth && xPosition != CrosstabColumnPositionEnum.LEFT)) {
            return;
        }
        double scaleX = -1.0;
        int offsetX = 0;
        switch (xPosition) {
            case CENTER: {
                offsetX = (newWidth - this.width) / 2;
                break;
            }
            case RIGHT: {
                offsetX = newWidth - this.width;
                break;
            }
            case STRETCH: {
                scaleX = (double)newWidth / (double)this.width;
            }
        }
        double scaleY = -1.0;
        int offsetY = 0;
        switch (yPosition) {
            case MIDDLE: {
                offsetY = (newHeight - this.height) / 2;
                break;
            }
            case BOTTOM: {
                offsetY = newHeight - this.height;
                break;
            }
            case STRETCH: {
                scaleY = (double)newHeight / (double)this.height;
            }
        }
        JRFillCellContents.transformElements(this.getElements(), scaleX, offsetX, scaleY, offsetY);
    }

    private static void transformElements(JRElement[] elements, double scaleX, int offsetX, double scaleY, int offsetY) {
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                JRFillElement element = (JRFillElement)elements[i];
                if (scaleX != -1.0) {
                    element.setX((int)((double)element.getX() * scaleX));
                    element.setWidth((int)((double)element.getWidth() * scaleX));
                }
                if (offsetX != 0) {
                    element.setX(element.getX() + offsetX);
                }
                if (scaleY != -1.0) {
                    element.setY((int)((double)element.getY() * scaleY));
                    element.setHeight((int)((double)element.getHeight() * scaleY));
                }
                if (offsetY != 0) {
                    element.setY(element.getY() + offsetY);
                }
                if (!(element instanceof JRFrame)) continue;
                JRElement[] frameElements = ((JRFrame)((Object)element)).getElements();
                JRFillCellContents.transformElements(frameElements, scaleX, offsetX, scaleY, offsetY);
            }
        }
    }

    protected void prepare(int availableHeight) throws JRException {
        this.initFill();
        this.resetElements();
        this.prepareElements(availableHeight, true);
        this.prepareStretchHeight = this.getStretchHeight();
    }

    protected JRPrintFrame fill() throws JRException {
        this.stretchElements();
        this.moveBandBottomElements();
        this.removeBlankElements();
        JRTemplatePrintFrame printCell = new JRTemplatePrintFrame(this.getTemplateFrame(), this.elementId);
        printCell.setX(this.x);
        printCell.setY(this.y);
        printCell.setWidth(this.width);
        this.fillElements(printCell);
        this.verticallyPositionElements(printCell);
        printCell.setHeight(this.getPrintHeight());
        this.setCellProperties(printCell);
        return printCell;
    }

    protected void setCellProperties(JRTemplatePrintFrame printCell) {
        if (this.verticalSpan > 1) {
            printCell.getPropertiesMap().setProperty("net.sf.jasperreports.crosstab.cell.row.span", Integer.toString(this.verticalSpan));
        }
        if (this.horizontalSpan > 1) {
            printCell.getPropertiesMap().setProperty("net.sf.jasperreports.crosstab.cell.column.span", Integer.toString(this.horizontalSpan));
        }
    }

    protected JRTemplateFrame getTemplateFrame() {
        JRStyle style = this.getStyle();
        JRTemplateFrame template = this.templateFrames.get(style);
        if (template == null) {
            template = new JRTemplateFrame(this.getOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
            template.getPropertiesMap().setProperty("net.sf.jasperreports.crosstab.cell.type", this.cellType);
            template = this.filler.fillContext.deduplicate(template);
            this.templateFrames.put(style, template);
        }
        return template;
    }

    protected JROrigin getOrigin() {
        return this.originProvider == null ? null : this.originProvider.getOrigin();
    }

    protected void verticallyPositionElements(JRTemplatePrintFrame printCell) {
        int positionOffset;
        switch (this.verticalPositionType) {
            case MIDDLE: {
                positionOffset = (this.getStretchHeight() - this.prepareStretchHeight) / 2;
                break;
            }
            case BOTTOM: {
                positionOffset = this.getStretchHeight() - this.prepareStretchHeight;
                break;
            }
            default: {
                positionOffset = 0;
            }
        }
        if (positionOffset != 0) {
            List<JRPrintElement> printElements = printCell.getElements();
            int positionY = this.getStretchHeight() - positionOffset;
            boolean outside = false;
            Iterator<JRPrintElement> it = printElements.iterator();
            while (!outside && it.hasNext()) {
                JRPrintElement element = it.next();
                outside = element.getY() + element.getHeight() > positionY;
            }
            if (!outside) {
                for (JRPrintElement element : printElements) {
                    element.setY(element.getY() + positionOffset);
                }
            }
        }
    }

    protected int getPrintHeight() {
        return this.getStretchHeight() + this.getTopPadding() + this.getBottomPadding();
    }

    protected void stretchTo(int stretchHeight) {
        this.setStretchHeight(stretchHeight - this.getTopPadding() - this.getBottomPadding());
    }

    @Override
    protected int getContainerHeight() {
        return this.getHeight() - this.getTopPadding() - this.getBottomPadding();
    }

    protected int getTopPadding() {
        return this.lineBox == null ? 0 : this.lineBox.getTopPadding();
    }

    protected int getBottomPadding() {
        return this.lineBox == null ? 0 : this.lineBox.getBottomPadding();
    }

    public JRFillCloneable createClone() {
        JRFillCloneFactory factory = new JRFillCloneFactory();
        return this.createClone(factory);
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillCellContents(this, factory);
    }

    public JRFillCellContents getWorkingClone() {
        JRFillCellContents clone = (JRFillCellContents)this.clonePool.getClone();
        clone.original = this;
        return clone;
    }

    public void releaseWorkingClone() {
        this.original.clonePool.releaseClone(this);
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getVerticalSpan() {
        return this.verticalSpan;
    }

    public void setVerticalSpan(int span) {
        this.verticalSpan = span;
    }

    public void setVerticalPositionType(CrosstabRowPositionEnum positionType) {
        this.verticalPositionType = positionType;
    }

    public int getHorizontalSpan() {
        return this.horizontalSpan;
    }

    public void setHorizontalSpan(int horizontalSpan) {
        this.horizontalSpan = horizontalSpan;
    }

    @Override
    protected void evaluate(byte evaluation) throws JRException {
        this.evaluateConditionalStyles(evaluation);
        super.evaluate(evaluation);
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    @Override
    public JRStyle getStyle() {
        JRStyle crtStyle = this.initStyle;
        boolean isUsingDefaultStyle = false;
        if (crtStyle == null) {
            crtStyle = this.filler.getDefaultStyle();
            isUsingDefaultStyle = true;
        }
        JRStyle evalStyle = this.getEvaluatedConditionalStyle(crtStyle);
        if (isUsingDefaultStyle && evalStyle == crtStyle) {
            evalStyle = null;
        }
        return evalStyle;
    }

    @Override
    protected void initConditionalStyles() {
        super.initConditionalStyles();
        this.collectConditionalStyle(this.initStyle);
    }

    @Override
    public ModeEnum getModeValue() {
        return this.parentCell.getModeValue();
    }

    @Override
    public String getStyleNameReference() {
        return null;
    }

    @Override
    public void setStyle(JRStyle style) {
        this.initStyle = style;
        this.collectConditionalStyle(style);
    }

    @Override
    public void setStyleNameReference(String name) {
        throw new UnsupportedOperationException("Style name references not allowed at fill time");
    }

    @Override
    public Color getDefaultLineColor() {
        return this.parentCell.getDefaultLineColor();
    }

    protected static class StretchedContents {
        final int newHeight;
        final int newWidth;
        final int hashCode;
        final CrosstabColumnPositionEnum xPosition;
        final CrosstabRowPositionEnum yPosition;

        StretchedContents(int newWidth, int newHeight, CrosstabColumnPositionEnum xPosition, CrosstabRowPositionEnum yPosition) {
            this.newHeight = newHeight;
            this.newWidth = newWidth;
            this.xPosition = xPosition;
            this.yPosition = yPosition;
            int hash = newHeight;
            hash = 31 * hash + newWidth;
            hash = 31 * hash + xPosition.getValue();
            this.hashCode = hash = 31 * hash + yPosition.getValue();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            StretchedContents s = (StretchedContents)o;
            return s.newHeight == this.newHeight && s.newWidth == this.newWidth && s.xPosition == this.xPosition && s.yPosition == this.yPosition;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    protected static class BoxContents {
        final boolean left;
        final boolean right;
        final boolean top;
        final int hashCode;

        public BoxContents(boolean left, boolean right, boolean top) {
            this.left = left;
            this.right = right;
            this.top = top;
            int hash = left ? 1231 : 1237;
            hash = 31 * hash + (right ? 1231 : 1237);
            this.hashCode = hash = 31 * hash + (top ? 1231 : 1237);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            BoxContents b = (BoxContents)obj;
            return b.left == this.left && b.right == this.right && b.top == this.top;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

