/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.html;

import java.io.IOException;
import net.sf.jasperreports.components.html.HtmlComponent;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentXmlWriter;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.JREnum;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class HtmlComponentXmlWriter
implements ComponentXmlWriter {
    public void writeToXml(ComponentKey componentKey, Component component, JRXmlWriter reportWriter) throws IOException {
        if (component instanceof HtmlComponent) {
            HtmlComponent htmlComponent = (HtmlComponent)component;
            this.writeHtmlComponent(htmlComponent, componentKey, reportWriter);
        }
    }

    protected void writeHtmlComponent(HtmlComponent htmlComponent, ComponentKey componentKey, JRXmlWriter reportWriter) throws IOException {
        JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        XmlNamespace namespace = new XmlNamespace("http://jasperreports.sourceforge.net/htmlcomponent", componentKey.getNamespacePrefix(), "http://jasperreports.sourceforge.net/xsd/htmlcomponent.xsd");
        writer.startElement("html", namespace);
        writer.addAttribute("scaleType", (JREnum)htmlComponent.getScaleType());
        writer.addAttribute("horizontalAlign", (JREnum)htmlComponent.getHorizontalAlign());
        writer.addAttribute("verticalAlign", (JREnum)htmlComponent.getVerticalAlign());
        writer.writeExpression("htmlContentExpression", htmlComponent.getHtmlContentExpression(), false);
        if (htmlComponent.getEvaluationTime() != EvaluationTimeEnum.NOW) {
            writer.addAttribute("evaluationTime", (JREnum)htmlComponent.getEvaluationTime());
        }
        writer.addAttribute("evaluationGroup", htmlComponent.getEvaluationGroup());
        writer.addAttribute("clipOnOverflow", (Object)htmlComponent.getClipOnOverflow());
        writer.closeElement();
    }
}

