/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons.layers;

import com.jaspersoft.ireport.addons.layers.Layer;
import com.jaspersoft.ireport.addons.layers.LayersChangedEvent;
import com.jaspersoft.ireport.addons.layers.LayersChangedListener;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JasperDesignActivatedListener;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.model.ObjectSceneListener;
import org.netbeans.api.visual.model.ObjectState;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayersSupport
implements JasperDesignActivatedListener,
ObjectSceneListener {
    private ReportObjectScene scene = null;
    private static LayersSupport singleton = null;
    private List<Layer> layers = new ArrayList<Layer>();
    private final Set<LayersChangedListener> layersChangedListeners = new HashSet<LayersChangedListener>(1);
    private PropertyChangeListener layersPropertyCahangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() != null && evt.getPropertyName().equals("PROPERTY_VISIBLE")) {
                if (evt.getSource() instanceof Layer) {
                    Layer layer = (Layer)evt.getSource();
                    List<JRDesignElementWidget> widgets = LayersSupport.this.getLayerWidgets(layer);
                    for (JRDesignElementWidget w : widgets) {
                        w.setVisible(layer.isVisible());
                        w.revalidate(layer.isVisible());
                        w.getScene().validate();
                    }
                }
            } else if (evt.getPropertyName() != null && evt.getPropertyName().equals("PROPERTY_PRINT_WHEN_EXPRESSION") && evt.getSource() instanceof Layer) {
                Layer layer = (Layer)evt.getSource();
                List<JRDesignElement> elements = LayersSupport.this.getLayerElements(layer);
                for (JRDesignElement element : elements) {
                    JRDesignExpression exp = Misc.createExpression((String)"java.lang.Boolean", (String)layer.getPrintWhenExpression());
                    element.setPrintWhenExpression((JRExpression)exp);
                }
            }
            LayersSupport.this.saveLayers();
        }
    };
    private JasperDesign jasperDesign = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addLayersChangedListener(LayersChangedListener l) {
        Set<LayersChangedListener> set = this.layersChangedListeners;
        synchronized (set) {
            this.layersChangedListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeLayersChangedListener(LayersChangedListener l) {
        Set<LayersChangedListener> set = this.layersChangedListeners;
        synchronized (set) {
            this.layersChangedListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fireLayersChangedListenerEvent(LayersChangedEvent evt) {
        Iterator<LayersChangedListener> it;
        Set<LayersChangedListener> set = this.layersChangedListeners;
        synchronized (set) {
            it = new HashSet<LayersChangedListener>(this.layersChangedListeners).iterator();
        }
        while (it.hasNext()) {
            it.next().layersChanged(evt);
        }
    }

    public void addElementToLayer(JRDesignElement element, Layer layer) {
        element.setPrintWhenExpression((JRExpression)Misc.createExpression((String)"java.lang.Boolean", (String)layer.getPrintWhenExpression()));
        if (!layer.isBackgroundLayer()) {
            element.getPropertiesMap().setProperty("ireport.layer", "" + layer.getId());
        } else {
            element.getPropertiesMap().removeProperty("ireport.layer");
        }
    }

    public static LayersSupport getInstance() {
        if (singleton == null) {
            singleton = new LayersSupport();
        }
        return singleton;
    }

    private LayersSupport() {
        IReportManager.getInstance().addJasperDesignActivatedListener((JasperDesignActivatedListener)this);
        this.jasperDesignActivated(IReportManager.getInstance().getActiveReport());
    }

    public void saveLayers() {
        if (this.getJasperDesign() == null) {
            return;
        }
        Properties props = new Properties();
        List<Layer> theLayers = this.getLayers();
        int k = 0;
        for (Layer l : theLayers) {
            props.put("layer." + k + ".id", l.getId() + "");
            props.put("layer." + k + ".name", l.getName());
            props.put("layer." + k + ".visible", "" + l.isVisible());
            if (l.getPrintWhenExpression() != null && l.getPrintWhenExpression().trim().length() > 0) {
                props.put("layer." + k + ".printWhenExpression", l.getPrintWhenExpression());
            }
            ++k;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            props.store(out, "");
            String s = out.toString();
            s = Misc.string_replace((String)"", (String)"\r", (String)s);
            s = Misc.string_replace((String)"\\nlayer.", (String)"\nlayer.", (String)s);
            s = Misc.string_replace((String)"", (String)"\n", (String)s);
            this.getJasperDesign().setProperty("ireport.layers", s);
            Misc.getViewForJasperDesign((JasperDesign)this.getJasperDesign()).getEditorSupport().notifyModified();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public List<Layer> loadLayers() {
        ArrayList<Layer> list = new ArrayList<Layer>();
        JasperDesign jd = this.getJasperDesign();
        if (jd == null) {
            return list;
        }
        String s = jd.getProperty("ireport.layers");
        s = Misc.string_replace((String)"\nlayer.", (String)"\\nlayer.", (String)s);
        Layer backgroundLayer = new Layer();
        backgroundLayer.setBackgroundLayer(true);
        backgroundLayer.setName("Background");
        list.add(backgroundLayer);
        if (s != null) {
            Properties props = new Properties();
            try {
                props.load(new ByteArrayInputStream(s.getBytes()));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            int i = 0;
            while (props.containsKey("layer." + i + ".id")) {
                Layer layer = new Layer();
                layer.setId(Integer.valueOf(props.getProperty("layer." + i + ".id")));
                layer.setName(props.getProperty("layer." + i + ".name"));
                layer.setVisible(Boolean.valueOf(props.getProperty("layer." + i + ".visible")));
                layer.setPrintWhenExpression(props.getProperty("layer." + i + ".printWhenExpression"));
                if (layer.getId() == 0) {
                    backgroundLayer.setVisible(Boolean.valueOf(props.getProperty("layer." + i + ".visible")));
                } else {
                    list.add(layer);
                }
                ++i;
            }
        }
        return list;
    }

    public void jasperDesignActivated(JasperDesign jd) {
        this.setJasperDesign(jd);
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jd) {
        JrxmlVisualView view;
        if (this.jasperDesign == jd) {
            return;
        }
        this.jasperDesign = jd;
        if (this.getScene() != null) {
            this.getScene().removeObjectSceneListener((ObjectSceneListener)this, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_ADDED});
        }
        if ((view = Misc.getViewForJasperDesign((JasperDesign)this.jasperDesign)) != null) {
            this.setScene(view.getReportDesignerPanel().getScene());
            if (this.getScene() != null) {
                this.getScene().addObjectSceneListener((ObjectSceneListener)this, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_ADDED});
            }
        }
        List<Layer> currentLayers = this.getLayers();
        for (Layer layer : currentLayers) {
            layer.getEventSupport().removePropertyChangeListener(this.layersPropertyCahangeListener);
        }
        if (this.getJasperDesign() != null) {
            this.setLayers(this.loadLayers());
        } else {
            this.setLayers(new ArrayList<Layer>());
        }
        currentLayers = this.getLayers();
        for (Layer layer : currentLayers) {
            layer.getEventSupport().addPropertyChangeListener(this.layersPropertyCahangeListener);
        }
        this.updateAllLayers();
        this.fireLayersChangedListenerEvent(new LayersChangedEvent(3, this.getJasperDesign()));
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    private void setLayers(List<Layer> layers) {
        this.layers = layers;
    }

    public void addLayer(Layer l) {
        if (this.getJasperDesign() == null || l == null || l.isBackgroundLayer()) {
            return;
        }
        this.layers.add(l);
        l.getEventSupport().addPropertyChangeListener(this.layersPropertyCahangeListener);
        this.saveLayers();
        ArrayList<Layer> toAddLayers = new ArrayList<Layer>();
        toAddLayers.add(l);
        LayersChangedEvent evt = new LayersChangedEvent(1, this.getJasperDesign(), toAddLayers);
        this.fireLayersChangedListenerEvent(evt);
    }

    public void removeLayer(Layer l) {
        if (this.getJasperDesign() == null || l == null || l.isBackgroundLayer()) {
            return;
        }
        ArrayList<Layer> toRemoveLayers = new ArrayList<Layer>();
        toRemoveLayers.add(l);
        this.removeLayers(toRemoveLayers);
    }

    public void removeLayers(List<Layer> toRemoveLayers) {
        if (this.getJasperDesign() == null || toRemoveLayers == null) {
            return;
        }
        for (int i = 0; i < toRemoveLayers.size(); ++i) {
            Layer l = toRemoveLayers.get(i);
            l.getEventSupport().removePropertyChangeListener(this.layersPropertyCahangeListener);
            if (!l.isBackgroundLayer()) continue;
            toRemoveLayers.remove(l);
            --i;
        }
        if (toRemoveLayers.size() > 0) {
            this.layers.removeAll(toRemoveLayers);
            this.saveLayers();
            for (Layer layer : toRemoveLayers) {
                List<JRDesignElementWidget> widgets = this.getLayerWidgets(layer);
                for (JRDesignElementWidget w : widgets) {
                    w.getElement().getPropertiesMap().removeProperty("ireport.layer");
                    w.setVisible(true);
                    w.getSelectionWidget().setVisible(true);
                    w.revalidate(true);
                    w.getScene().validate();
                }
            }
            LayersChangedEvent evt = new LayersChangedEvent(2, this.getJasperDesign(), toRemoveLayers);
            this.fireLayersChangedListenerEvent(evt);
        }
    }

    public List<JRDesignElementWidget> getLayerWidgets(Layer layer) {
        ArrayList<JRDesignElementWidget> list = new ArrayList<JRDesignElementWidget>();
        List elements = ModelUtils.getAllElements((JasperDesign)this.getJasperDesign(), (boolean)false);
        if (this.getScene() == null) {
            return list;
        }
        for (JRDesignElement element : elements) {
            JRDesignElementWidget w;
            if ((element.getPropertiesMap().containsProperty("ireport.layer") || !layer.isBackgroundLayer()) && (element.getPropertiesMap().getProperty("ireport.layer") == null || !element.getPropertiesMap().getProperty("ireport.layer").equals(layer.getId() + "")) || (w = this.getScene().findElementWidget(element)) == null) continue;
            list.add(w);
        }
        return list;
    }

    public List<JRDesignElement> getLayerElements(Layer layer) {
        ArrayList<JRDesignElement> list = new ArrayList<JRDesignElement>();
        List elements = ModelUtils.getAllElements((JasperDesign)this.getJasperDesign(), (boolean)false);
        for (JRDesignElement element : elements) {
            if ((element.getPropertiesMap().containsProperty("ireport.layer") || !layer.isBackgroundLayer()) && (element.getPropertiesMap().getProperty("ireport.layer") == null || !element.getPropertiesMap().getProperty("ireport.layer").equals(layer.getId() + ""))) continue;
            list.add(element);
        }
        return list;
    }

    public Layer getLayer(int id) {
        for (Layer l : this.getLayers()) {
            if (l.getId() != id) continue;
            return l;
        }
        return null;
    }

    public void objectAdded(ObjectSceneEvent event, Object addedObject) {
        JRDesignElement element;
        if (addedObject instanceof JRDesignElement && (element = (JRDesignElement)addedObject).getPropertiesMap().getProperty("ireport.layer") != null) {
            JRDesignElementWidget w;
            Layer layer = null;
            try {
                layer = this.getLayer(Integer.valueOf(element.getPropertiesMap().getProperty("ireport.layer")));
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (layer != null && (w = ((ReportObjectScene)event.getObjectScene()).findElementWidget(element)) != null) {
                w.setVisible(layer.isVisible());
                w.revalidate(layer.isVisible());
                w.getScene().validate();
            }
        }
    }

    public void objectRemoved(ObjectSceneEvent event, Object removedObject) {
    }

    public void objectStateChanged(ObjectSceneEvent event, Object changedObject, ObjectState previousState, ObjectState newState) {
    }

    public void selectionChanged(ObjectSceneEvent event, Set<Object> previousSelection, Set<Object> newSelection) {
    }

    public void highlightingChanged(ObjectSceneEvent event, Set<Object> previousHighlighting, Set<Object> newHighlighting) {
    }

    public void hoverChanged(ObjectSceneEvent event, Object previousHoveredObject, Object newHoveredObject) {
    }

    public void focusChanged(ObjectSceneEvent event, Object previousFocusedObject, Object newFocusedObject) {
    }

    public void updateAllLayers() {
        if (this.getScene() == null || this.jasperDesign == null) {
            return;
        }
        List elements = ModelUtils.getAllElements((JasperDesign)this.jasperDesign, (boolean)false);
        for (JRDesignElement element : elements) {
            String layerProp = element.getPropertiesMap().getProperty("ireport.layer");
            if (layerProp == null) continue;
            try {
                JRDesignElementWidget w;
                Layer layer = this.getLayer(Integer.valueOf(layerProp));
                if (layer == null || (w = this.getScene().findElementWidget(element)).isVisible() == layer.isVisible()) continue;
                w.setVisible(layer.isVisible());
                w.revalidate(true);
            }
            catch (Exception ex) {}
        }
        this.getScene().validate();
    }

    public ReportObjectScene getScene() {
        return this.scene;
    }

    public void setScene(ReportObjectScene scene) {
        this.scene = scene;
    }
}

