/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.hadoop.hive.jasperserver;

import com.jaspersoft.hadoop.hive.connection.HiveConnection;
import com.jaspersoft.hadoop.hive.connection.HiveConnectionManager;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.CustomReportDataSourceService;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;

public class HiveDataSourceService
implements CustomReportDataSourceService {
    private String jdbcURL;
    private HiveConnection connection;
    private HiveConnectionManager connectionManager;
    private static final Logger logger = Logger.getLogger(HiveDataSourceService.class);

    public void closeConnection() {
        if (this.connectionManager != null && this.connection != null) {
            this.connectionManager.returnConnection(this.connection);
            this.connection = null;
        }
    }

    public void setReportParameterValues(Map parameters) {
        try {
            this.createConnection();
            parameters.put("REPORT_CONNECTION", this.connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createConnection() throws JRException {
        if (this.connection != null) {
            this.closeConnection();
        }
        this.connectionManager.setJdbcURL(this.jdbcURL);
        try {
            this.connection = this.connectionManager.borrowConnection();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new JRException(e.getMessage());
        }
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }

    public void setConnectionManager(HiveConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public HiveConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testConnection() throws JRException {
        try {
            this.createConnection();
            if (this.connection == null) {
                boolean bl = false;
                return bl;
            }
            this.connection.test();
            boolean bl = true;
            return bl;
        }
        finally {
            this.closeConnection();
        }
    }
}

