/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BraceCompletionInsertAction
extends ExtKit.ExtDefaultKeyTypedAction {
    protected void insertString(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl) throws BadLocationException {
        TokenSequence tokenSequence = Utils.getTokenSequence((Document)baseDocument, caret.getDot());
        if (tokenSequence != null) {
            String string2 = tokenSequence.language().mimeType();
            try {
                Language language = LanguagesManager.getDefault().getLanguage(string2);
                List<Feature> list = language.getFeatureList().getFeatures("COMPLETE");
                if (list != null) {
                    this.complete(baseDocument, n, caret, string, bl, tokenSequence, list);
                    return;
                }
            }
            catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                // empty catch block
            }
        }
        super.insertString(baseDocument, n, caret, string, bl);
    }

    private void complete(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl, TokenSequence tokenSequence, List<Feature> list) throws BadLocationException {
        for (Feature feature : list) {
            String string2;
            if (feature.getType() == Feature.Type.METHOD_CALL) {
                feature.getValue(new Object[]{baseDocument, caret, string});
                return;
            }
            String string3 = (String)feature.getValue();
            int n2 = string3.indexOf(58);
            if (n2 < 0) continue;
            if (caret.getDot() + string3.length() - n2 - 1 < baseDocument.getLength()) {
                string2 = baseDocument.getText(caret.getDot(), string3.length() - n2 - 1);
                if (string3.endsWith(":" + string2) && string.equals(string2)) {
                    caret.setDot(caret.getDot() + 1);
                    return;
                }
            }
            if (caret.getDot() - n2 + string.length() < 0 || !string3.startsWith((string2 = baseDocument.getText(caret.getDot() - n2 + string.length(), n2 - string.length()) + string) + ":")) continue;
            Token token = tokenSequence.token();
            boolean bl2 = false;
            if (token != null) {
                char c = token.text().charAt(0);
                boolean bl3 = bl2 = c == '\n' || c == ' ';
            }
            if (token != null && tokenSequence.offset() != caret.getDot() && token.id().name().indexOf("whitespace") < 0 && !bl2) continue;
            string = string + string3.substring(n2 + 1);
            super.insertString(baseDocument, n, caret, string, bl);
            caret.setDot(n + 1);
            return;
        }
        super.insertString(baseDocument, n, caret, string, bl);
    }
}

