/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewPageContext;
import org.netbeans.modules.db.dataview.output.DataViewTableUI;
import org.netbeans.modules.db.dataview.output.DataViewUI;
import org.netbeans.modules.db.dataview.output.InsertRecordDialog;
import org.netbeans.modules.db.dataview.output.SQLExecutionHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

class DataViewActionHandler {
    private final DataViewPageContext dataPage;
    private final SQLExecutionHelper execHelper;
    private final DataViewUI dataViewUI;
    private final DataView dataView;

    DataViewActionHandler(DataViewUI dataViewUI, DataView dataView) {
        this.dataView = dataView;
        this.dataViewUI = dataViewUI;
        this.dataPage = dataView.getDataViewPageContext();
        this.execHelper = dataView.getSQLExecutionHelper();
    }

    private boolean rejectModifications() {
        String string;
        boolean bl = true;
        if (this.dataViewUI.isCommitEnabled() && DataViewActionHandler.showYesAllDialog(string = NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_commit_changes"), NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_navigation")).equals(NotifyDescriptor.NO_OPTION)) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelEditPerformed() {
        DataView dataView = this.dataView;
        synchronized (dataView) {
            this.dataView.getUpdatedRowContext().resetUpdateState();
            this.dataView.setRowsInTableModel();
            this.dataViewUI.setCancelEnabled(false);
            this.dataViewUI.setCommitEnabled(false);
        }
    }

    void setMaxActionPerformed() {
        if (this.rejectModifications()) {
            int n = this.dataViewUI.getPageSize();
            this.dataPage.setPageSize(n);
            this.dataPage.first();
            this.dataPage.setTotalRows(-1);
            this.execHelper.executeQuery();
        }
    }

    void firstActionPerformed() {
        if (this.rejectModifications()) {
            this.dataPage.first();
            this.execHelper.executeQuery();
        }
    }

    void previousActionPerformed() {
        if (this.rejectModifications()) {
            this.dataPage.previous();
            this.execHelper.executeQuery();
        }
    }

    void nextActionPerformed() {
        if (this.rejectModifications()) {
            this.dataPage.next();
            this.execHelper.executeQuery();
        }
    }

    void lastActionPerformed() {
        if (this.rejectModifications()) {
            this.dataPage.last();
            this.execHelper.executeQuery();
        }
    }

    void commitActionPerformed(boolean bl) {
        if (this.dataViewUI.isDirty()) {
            this.execHelper.executeUpdateRow(this.dataViewUI.getDataViewTableUI(), bl);
        }
    }

    void insertActionPerformed() {
        InsertRecordDialog insertRecordDialog = new InsertRecordDialog(this.dataView);
        insertRecordDialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        insertRecordDialog.setVisible(true);
    }

    void truncateActionPerformed() {
        String string = NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_truncate_table") + this.dataView.getDataViewDBTable().geTable(0).getDisplayName();
        if (DataViewActionHandler.showYesAllDialog(string, string).equals(NotifyDescriptor.YES_OPTION)) {
            this.execHelper.executeTruncate();
        }
    }

    void deleteRecordActionPerformed() {
        DataViewTableUI dataViewTableUI = this.dataViewUI.getDataViewTableUI();
        if (dataViewTableUI.getSelectedRowCount() == 0) {
            String string = NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_select_delete_rows");
            this.dataView.setInfoStatusText(string);
        } else {
            String string = NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_permanent_delete");
            if (DataViewActionHandler.showYesAllDialog(string, NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_delete")).equals(NotifyDescriptor.YES_OPTION)) {
                this.execHelper.executeDeleteRow(dataViewTableUI);
            } else {
                this.dataViewUI.getDataViewTableUI().clearSelection();
                this.dataViewUI.enableDeleteBtn(false);
            }
        }
    }

    void refreshActionPerformed() {
        this.dataPage.setTotalRows(-1);
        this.execHelper.executeQuery();
    }

    private static Object showYesAllDialog(Object object, String string) {
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor(object, string, 0, 3, null, NotifyDescriptor.NO_OPTION);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
        return notifyDescriptor.getValue();
    }
}

