/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mondrian.olap.Util;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.ServletContextCatalogLocator;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.Enumeration;
import mondrian.xmla.XmlaConstants;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequestCallback;
import mondrian.xmla.XmlaUtil;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlaServlet
extends HttpServlet
implements XmlaConstants {
    private static final Logger LOGGER = Logger.getLogger(XmlaServlet.class);
    public static final String PARAM_DATASOURCES_CONFIG = "DataSourcesConfig";
    public static final String PARAM_OPTIONAL_DATASOURCE_CONFIG = "OptionalDataSourceConfig";
    public static final String PARAM_CHAR_ENCODING = "CharacterEncoding";
    public static final String PARAM_CALLBACKS = "Callbacks";
    public static final String DEFAULT_DATASOURCE_FILE = "datasources.xml";
    protected CatalogLocator catalogLocator = null;
    protected DataSourcesConfig.DataSources dataSources = null;
    protected XmlaHandler xmlaHandler = null;
    protected String charEncoding = null;
    private final List<XmlaRequestCallback> callbackList = new ArrayList<XmlaRequestCallback>();

    public static boolean getBooleanInitParameter(ServletConfig servletConfig, String paramName) {
        String paramValue = servletConfig.getInitParameter(paramName);
        return paramValue != null && Boolean.valueOf(paramValue) != false;
    }

    public static boolean getParameter(HttpServletRequest req, String paramName) {
        String paramValue = req.getParameter(paramName);
        return paramValue != null && Boolean.valueOf(paramValue) != false;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.initCharEncodingHandler(servletConfig);
        this.initCallbacks(servletConfig);
        this.catalogLocator = this.makeCatalogLocator(servletConfig);
        DataSourcesConfig.DataSources dataSources = this.makeDataSources(servletConfig);
        this.addToDataSources(dataSources);
    }

    protected XmlaHandler getXmlaHandler() {
        if (this.xmlaHandler == null) {
            this.xmlaHandler = new XmlaHandler(this.dataSources, this.catalogLocator, "cxmla");
        }
        return this.xmlaHandler;
    }

    protected final void addCallback(XmlaRequestCallback callback) {
        this.callbackList.add(callback);
    }

    protected final List<XmlaRequestCallback> getCallbacks() {
        return Collections.unmodifiableList(this.callbackList);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Element[] requestSoapParts = new Element[2];
        byte[][] responseSoapParts = new byte[2][];
        Phase phase = Phase.VALIDATE_HTTP_HEAD;
        Enumeration.ResponseMimeType mimeType = Enumeration.ResponseMimeType.SOAP;
        try {
            if (this.charEncoding != null) {
                try {
                    request.setCharacterEncoding(this.charEncoding);
                    response.setCharacterEncoding(this.charEncoding);
                }
                catch (UnsupportedEncodingException uee) {
                    this.charEncoding = null;
                    LOGGER.warn((Object)("Unsupported character encoding '" + this.charEncoding + "': Use default character encoding from HTTP client " + "for now"));
                }
            }
            response.setContentType(mimeType.getMimeType());
            HashMap<String, Object> context = new HashMap<String, Object>();
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Invoking validate http header callbacks");
                }
                for (XmlaRequestCallback callback : this.getCallbacks()) {
                    if (callback.processHttpHeader(request, response, context)) continue;
                    return;
                }
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when invoking callbacks validateHttpHeader", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Errors when invoking callbacks validateHttpHeader", (Throwable)ex);
                this.handleFault(response, responseSoapParts, phase, new XmlaException("Server", "00CHHA01", "Error in Callback processHttpHeader", ex));
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            phase = Phase.INITIAL_PARSE;
            try {
                String contentType;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Unmarshalling SOAP message");
                }
                if ((contentType = request.getContentType()) == null || contentType.indexOf("text/xml") == -1) {
                    throw new IllegalArgumentException("Only accepts content type 'text/xml', not '" + contentType + "'");
                }
                String accept = request.getHeader("Accept");
                if (accept != null) {
                    mimeType = XmlaUtil.chooseResponseMimeType(accept);
                    if (mimeType == null) {
                        throw new IllegalArgumentException("Accept header '" + accept + "' is not a supported" + " response content type. Allowed values:" + " text/xml, application/xml, application/json.");
                    }
                    if (mimeType != Enumeration.ResponseMimeType.SOAP) {
                        response.setContentType(mimeType.getMimeType());
                    }
                }
                context.put("language", (Object)mimeType);
                this.unmarshallSoapMessage(request, requestSoapParts);
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Unable to unmarshall SOAP message", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            phase = Phase.PROCESS_HEADER;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Handling XML/A message header");
                }
                this.handleSoapHeader(response, requestSoapParts, responseSoapParts, context);
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when handling XML/A message", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            phase = Phase.CALLBACK_PRE_ACTION;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Invoking callbacks preAction");
                }
                for (XmlaRequestCallback callback : this.getCallbacks()) {
                    callback.preAction(request, requestSoapParts, context);
                }
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when invoking callbacks preaction", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Errors when invoking callbacks preaction", (Throwable)ex);
                this.handleFault(response, responseSoapParts, phase, new XmlaException("Server", "00CPREA01", "Error in Callback PreAction", ex));
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            phase = Phase.PROCESS_BODY;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Handling XML/A message body");
                }
                this.handleSoapBody(response, requestSoapParts, responseSoapParts, context);
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when handling XML/A message", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            mimeType = (Enumeration.ResponseMimeType)((Object)context.get("language"));
            phase = Phase.CALLBACK_POST_ACTION;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Invoking callbacks postAction");
                }
                for (XmlaRequestCallback callback : this.getCallbacks()) {
                    callback.postAction(request, response, responseSoapParts, context);
                }
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when invoking callbacks postaction", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Errors when invoking callbacks postaction", (Throwable)ex);
                this.handleFault(response, responseSoapParts, phase, new XmlaException("Server", "00CPOSTA01", "Error in Callback PostAction", ex));
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            phase = Phase.SEND_RESPONSE;
            try {
                response.setStatus(200);
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when handling XML/A message", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
        }
        catch (Throwable t) {
            LOGGER.error((Object)"Unknown Error when handling XML/A message", t);
            this.handleFault(response, responseSoapParts, phase, t);
            this.marshallSoapMessage(response, responseSoapParts, mimeType);
        }
    }

    protected abstract void unmarshallSoapMessage(HttpServletRequest var1, Element[] var2) throws XmlaException;

    protected abstract void handleSoapHeader(HttpServletResponse var1, Element[] var2, byte[][] var3, Map<String, Object> var4) throws XmlaException;

    protected abstract void handleSoapBody(HttpServletResponse var1, Element[] var2, byte[][] var3, Map<String, Object> var4) throws XmlaException;

    protected abstract void marshallSoapMessage(HttpServletResponse var1, byte[][] var2, Enumeration.ResponseMimeType var3) throws XmlaException;

    protected abstract void handleFault(HttpServletResponse var1, byte[][] var2, Phase var3, Throwable var4);

    protected CatalogLocator makeCatalogLocator(ServletConfig servletConfig) {
        ServletContext servletContext = servletConfig.getServletContext();
        return new ServletContextCatalogLocator(servletContext);
    }

    protected DataSourcesConfig.DataSources makeDataSources(ServletConfig servletConfig) {
        URL dataSourcesConfigUrl;
        block12: {
            String paramValue = servletConfig.getInitParameter(PARAM_DATASOURCES_CONFIG);
            boolean optional = XmlaServlet.getBooleanInitParameter(servletConfig, PARAM_OPTIONAL_DATASOURCE_CONFIG);
            dataSourcesConfigUrl = null;
            try {
                if (paramValue == null) {
                    String defaultDS = "WEB-INF/datasources.xml";
                    ServletContext servletContext = servletConfig.getServletContext();
                    File realPath = new File(servletContext.getRealPath(defaultDS));
                    if (realPath.exists()) {
                        dataSourcesConfigUrl = realPath.toURL();
                    }
                    break block12;
                }
                paramValue = Util.replaceProperties(paramValue, Util.toMap(System.getProperties()));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("XmlaServlet.makeDataSources: paramValue=" + paramValue));
                }
                MalformedURLException mue = null;
                try {
                    dataSourcesConfigUrl = new URL(paramValue);
                }
                catch (MalformedURLException e) {
                    mue = e;
                }
                if (dataSourcesConfigUrl == null) {
                    File f = new File(paramValue);
                    if (f.exists()) {
                        dataSourcesConfigUrl = f.toURL();
                    } else if (mue != null && !optional) {
                        throw mue;
                    }
                }
            }
            catch (MalformedURLException mue) {
                throw Util.newError(mue, "invalid URL path '" + paramValue + "'");
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("XmlaServlet.makeDataSources: dataSourcesConfigUrl=" + dataSourcesConfigUrl));
        }
        return dataSourcesConfigUrl == null ? null : this.parseDataSourcesUrl(dataSourcesConfigUrl);
    }

    protected void addToDataSources(DataSourcesConfig.DataSources dataSources) {
        if (this.dataSources == null) {
            this.dataSources = dataSources;
        } else if (dataSources != null) {
            DataSourcesConfig.DataSource[] ds1 = this.dataSources.dataSources;
            int len1 = ds1.length;
            DataSourcesConfig.DataSource[] ds2 = dataSources.dataSources;
            int len2 = ds2.length;
            DataSourcesConfig.DataSource[] tmp = new DataSourcesConfig.DataSource[len1 + len2];
            System.arraycopy(ds1, 0, tmp, 0, len1);
            System.arraycopy(ds2, 0, tmp, len1, len2);
            this.dataSources.dataSources = tmp;
        } else {
            LOGGER.warn((Object)"XmlaServlet.addToDataSources: DataSources is null");
        }
    }

    protected DataSourcesConfig.DataSources parseDataSourcesUrl(URL dataSourcesConfigUrl) {
        try {
            String dataSourcesConfigString = this.readDataSourcesContent(dataSourcesConfigUrl);
            return this.parseDataSources(dataSourcesConfigString);
        }
        catch (Exception e) {
            throw Util.newError(e, "Failed to parse data sources config '" + dataSourcesConfigUrl.toExternalForm() + "'");
        }
    }

    protected String readDataSourcesContent(URL dataSourcesConfigUrl) throws IOException {
        return Util.readURL(dataSourcesConfigUrl, Util.toMap(System.getProperties()));
    }

    protected DataSourcesConfig.DataSources parseDataSources(String dataSourcesConfigString) {
        try {
            if (dataSourcesConfigString == null) {
                LOGGER.warn((Object)"XmlaServlet.parseDataSources: null input");
                return null;
            }
            dataSourcesConfigString = Util.replaceProperties(dataSourcesConfigString, Util.toMap(System.getProperties()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("XmlaServlet.parseDataSources: dataSources=" + dataSourcesConfigString));
            }
            Parser parser = XOMUtil.createDefaultParser();
            DOMWrapper doc = parser.parse(dataSourcesConfigString);
            return new DataSourcesConfig.DataSources(doc);
        }
        catch (XOMException e) {
            throw Util.newError(e, "Failed to parse data sources config: " + dataSourcesConfigString);
        }
    }

    protected void initCharEncodingHandler(ServletConfig servletConfig) {
        String paramValue = servletConfig.getInitParameter(PARAM_CHAR_ENCODING);
        if (paramValue != null) {
            this.charEncoding = paramValue;
        } else {
            this.charEncoding = null;
            LOGGER.warn((Object)"Use default character encoding from HTTP client");
        }
    }

    protected void initCallbacks(ServletConfig servletConfig) {
        String callbacksValue = servletConfig.getInitParameter(PARAM_CALLBACKS);
        if (callbacksValue != null) {
            String[] classNames = callbacksValue.split(";");
            int count = 0;
            for (String className1 : classNames) {
                String className = className1.trim();
                try {
                    Class<?> cls = Class.forName(className);
                    if (XmlaRequestCallback.class.isAssignableFrom(cls)) {
                        XmlaRequestCallback callback = (XmlaRequestCallback)cls.newInstance();
                        try {
                            callback.init(servletConfig);
                        }
                        catch (Exception e) {
                            LOGGER.warn((Object)("Failed to initialize callback '" + className + "'"), (Throwable)e);
                            continue;
                        }
                        this.addCallback(callback);
                        ++count;
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.info((Object)("Register callback '" + className + "'"));
                        continue;
                    }
                    LOGGER.warn((Object)("'" + className + "' is not an implementation of '" + XmlaRequestCallback.class + "'"));
                }
                catch (ClassNotFoundException cnfe) {
                    LOGGER.warn((Object)("Callback class '" + className + "' not found"), (Throwable)cnfe);
                }
                catch (InstantiationException ie) {
                    LOGGER.warn((Object)("Can't instantiate class '" + className + "'"), (Throwable)ie);
                }
                catch (IllegalAccessException iae) {
                    LOGGER.warn((Object)("Can't instantiate class '" + className + "'"), (Throwable)iae);
                }
            }
            LOGGER.debug((Object)("Registered " + count + " callback" + (count > 1 ? "s" : "")));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Phase {
        VALIDATE_HTTP_HEAD,
        INITIAL_PARSE,
        CALLBACK_PRE_ACTION,
        PROCESS_HEADER,
        PROCESS_BODY,
        CALLBACK_POST_ACTION,
        SEND_RESPONSE,
        SEND_ERROR;

    }
}

