/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx.parser.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java_cup.runtime.Symbol;
import org.olap4j.mdx.ParseRegion;
import org.olap4j.mdx.parser.MdxParseException;

class Scanner {
    protected int nextChar;
    private int[] lookaheadChars = new int[16];
    private int firstLookaheadChar = 0;
    private int lastLookaheadChar = 0;
    private Map<String, Integer> reservedWordIds;
    private int iMaxResword;
    private String[] reservedWords;
    protected boolean debug;
    private final List<Integer> lines = new ArrayList<Integer>();
    private int iChar;
    private int iPrevChar;
    private int previousSymbol;
    private boolean inFormula;
    private static final String[][] commentDelim = new String[][]{{"//", null}, {"--", null}, {"/*", "*/"}};
    private static final boolean allowNestedComments = true;
    private static final BigDecimal BigDecimalZero = BigDecimal.valueOf(0L);

    Scanner(boolean debug) {
        this.debug = debug;
    }

    public static boolean getNestedCommentsState() {
        return true;
    }

    public static String[][] getCommentDelimiters() {
        return commentDelim;
    }

    private void advance() throws IOException {
        if (this.firstLookaheadChar == this.lastLookaheadChar) {
            this.nextChar = this.getChar();
        } else {
            this.nextChar = this.lookaheadChars[this.firstLookaheadChar++];
            if (this.firstLookaheadChar == this.lastLookaheadChar) {
                this.firstLookaheadChar = 0;
                this.lastLookaheadChar = 0;
            }
        }
        if (this.nextChar == 10) {
            this.lines.add(this.iChar);
        }
        ++this.iChar;
    }

    private int lookahead() throws IOException {
        return this.lookahead(1);
    }

    private int lookahead(int n) throws IOException {
        if (n == 0) {
            return this.nextChar;
        }
        if (n > this.lastLookaheadChar - this.firstLookaheadChar) {
            int len = this.lastLookaheadChar - this.firstLookaheadChar;
            if (n + this.firstLookaheadChar > this.lookaheadChars.length) {
                int[] t = n > this.lookaheadChars.length ? new int[n * 2] : this.lookaheadChars;
                System.arraycopy(this.lookaheadChars, this.firstLookaheadChar, t, 0, len);
                this.lookaheadChars = t;
                this.firstLookaheadChar = 0;
                this.lastLookaheadChar = len;
            }
            while (n > this.lastLookaheadChar - this.firstLookaheadChar) {
                this.lookaheadChars[this.lastLookaheadChar++] = this.getChar();
            }
        }
        return this.lookaheadChars[n - 1 + this.firstLookaheadChar];
    }

    protected int getChar() throws IOException {
        return System.in.read();
    }

    public void init() throws IOException {
        this.initReswords();
        this.lines.clear();
        this.iPrevChar = 0;
        this.iChar = 0;
        this.advance();
    }

    private void initResword(int id, String s) {
        this.reservedWordIds.put(s, id);
        if (id > this.iMaxResword) {
            this.iMaxResword = id;
        }
    }

    private void initReswords() {
        this.reservedWordIds = new HashMap<String, Integer>();
        this.iMaxResword = 0;
        this.initResword(2, "AND");
        this.initResword(3, "AS");
        this.initResword(4, "AXIS");
        this.initResword(6, "CAST");
        this.initResword(5, "CASE");
        this.initResword(7, "CELL");
        this.initResword(8, "CHAPTERS");
        this.initResword(9, "COLUMNS");
        this.initResword(10, "DIMENSION");
        this.initResword(11, "ELSE");
        this.initResword(12, "EMPTY");
        this.initResword(13, "END");
        this.initResword(14, "FROM");
        this.initResword(16, "IS");
        this.initResword(15, "IN");
        this.initResword(17, "MATCHES");
        this.initResword(18, "MEMBER");
        this.initResword(19, "NON");
        this.initResword(20, "NOT");
        this.initResword(21, "NULL");
        this.initResword(22, "ON");
        this.initResword(23, "OR");
        this.initResword(24, "PAGES");
        this.initResword(25, "PROPERTIES");
        this.initResword(26, "ROWS");
        this.initResword(27, "SECTIONS");
        this.initResword(28, "SELECT");
        this.initResword(29, "SET");
        this.initResword(30, "THEN");
        this.initResword(31, "WHEN");
        this.initResword(32, "WHERE");
        this.initResword(34, "WITH");
        this.initResword(33, "XOR");
        this.reservedWords = new String[this.iMaxResword + 1];
        for (Map.Entry<String, Integer> entry : this.reservedWordIds.entrySet()) {
            this.reservedWords[entry.getValue().intValue()] = entry.getKey();
        }
    }

    public String lookupReserved(int i) {
        return this.reservedWords[i];
    }

    private Symbol makeSymbol(int id, Object o) {
        int iPrevPrevChar = this.iPrevChar;
        this.iPrevChar = this.iChar;
        this.previousSymbol = id;
        return new Symbol(id, iPrevPrevChar, this.iChar, o);
    }

    private Symbol makeNumber(BigDecimal mantissa, int exponent) {
        double d = mantissa.movePointRight(exponent).doubleValue();
        return this.makeSymbol(54, d);
    }

    private Symbol makeId(String s, boolean quoted, boolean ampersand) {
        int id = quoted ? (ampersand ? 57 : 56) : (ampersand ? 58 : 55);
        return this.makeSymbol(id, s);
    }

    private Symbol makeRes(int i) {
        return this.makeSymbol(i, this.reservedWords[i]);
    }

    private Symbol makeToken(int i, String s) {
        return this.makeSymbol(i, s);
    }

    private Symbol makeString(String s) {
        if (this.inFormula) {
            this.inFormula = false;
            return this.makeSymbol(60, s);
        }
        return this.makeSymbol(59, s);
    }

    private void skipToEOL() throws IOException {
        while (this.nextChar != -1 && this.nextChar != 10) {
            this.advance();
        }
    }

    private void skipComment(String startDelim, String endDelim) throws IOException {
        int x;
        int depth = 1;
        for (x = 0; x < startDelim.length(); ++x) {
            this.advance();
        }
        while (this.nextChar != -1) {
            if (this.checkForSymbol(endDelim)) {
                for (x = 0; x < endDelim.length(); ++x) {
                    this.advance();
                }
                if (--depth != 0) continue;
                return;
            }
            if (this.checkForSymbol(startDelim)) {
                for (x = 0; x < startDelim.length(); ++x) {
                    this.advance();
                }
                ++depth;
                continue;
            }
            this.advance();
        }
        return;
    }

    private void searchForComments() throws IOException {
        boolean foundComment;
        do {
            foundComment = false;
            for (String[] aCommentDelim : commentDelim) {
                if (!this.checkForSymbol(aCommentDelim[0])) continue;
                if (aCommentDelim[1] == null) {
                    foundComment = true;
                    this.skipToEOL();
                    continue;
                }
                foundComment = true;
                this.skipComment(aCommentDelim[0], aCommentDelim[1]);
            }
        } while (foundComment);
    }

    private boolean checkForSymbol(String symb) throws IOException {
        for (int x = 0; x < symb.length(); ++x) {
            if (symb.charAt(x) == this.lookahead(x)) continue;
            return false;
        }
        return true;
    }

    public Symbol next_token() throws IOException {
        boolean ampersandId = false;
        block76: while (true) {
            this.searchForComments();
            switch (this.nextChar) {
                case 46: {
                    switch (this.lookahead()) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            break;
                        }
                        default: {
                            this.advance();
                            return this.makeToken(40, ".");
                        }
                    }
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    BigDecimal n = BigDecimalZero;
                    int digitCount = 0;
                    int exponent = 0;
                    boolean positive = true;
                    BigDecimal mantissa = BigDecimalZero;
                    State state = State.leftOfPoint;
                    block77: while (true) {
                        switch (this.nextChar) {
                            case 46: {
                                switch (state) {
                                    case leftOfPoint: {
                                        state = State.rightOfPoint;
                                        mantissa = n;
                                        n = BigDecimalZero;
                                        digitCount = 0;
                                        positive = true;
                                        this.advance();
                                        break;
                                    }
                                    case rightOfPoint: {
                                        mantissa = mantissa.add(n.movePointRight(-digitCount));
                                        return this.makeNumber(mantissa, exponent);
                                    }
                                    case inExponent: {
                                        if (!positive) {
                                            n = n.negate();
                                        }
                                        exponent = n.intValue();
                                        return this.makeNumber(mantissa, exponent);
                                    }
                                }
                                continue block77;
                            }
                            case 69: 
                            case 101: {
                                switch (state) {
                                    case inExponent: {
                                        if (!positive) {
                                            n = n.negate();
                                        }
                                        exponent = n.intValue();
                                        return this.makeNumber(mantissa, exponent);
                                    }
                                    case leftOfPoint: {
                                        mantissa = n;
                                        break;
                                    }
                                    default: {
                                        mantissa = mantissa.add(n.movePointRight(-digitCount));
                                    }
                                }
                                digitCount = 0;
                                n = BigDecimalZero;
                                positive = true;
                                this.advance();
                                state = State.inExponent;
                                continue block77;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n = n.movePointRight(1);
                                n = n.add(BigDecimal.valueOf(this.nextChar - 48));
                                ++digitCount;
                                this.advance();
                                continue block77;
                            }
                            case 43: 
                            case 45: {
                                if (state != State.inExponent || digitCount != 0) break block77;
                                positive = !positive;
                                this.advance();
                                continue block77;
                            }
                        }
                        break;
                    }
                    switch (state) {
                        case leftOfPoint: {
                            mantissa = n;
                            break;
                        }
                        case rightOfPoint: {
                            mantissa = mantissa.add(n.movePointRight(-digitCount));
                            break;
                        }
                        default: {
                            if (!positive) {
                                n = n.negate();
                            }
                            exponent = n.intValue();
                        }
                    }
                    return this.makeNumber(mantissa, exponent);
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    StringBuilder id = new StringBuilder();
                    block78: while (true) {
                        id.append((char)this.nextChar);
                        this.advance();
                        switch (this.nextChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 95: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: {
                                continue block78;
                            }
                        }
                        break;
                    }
                    String strId = id.toString();
                    Integer i = this.reservedWordIds.get(strId.toUpperCase());
                    if (i == null) {
                        return this.makeId(strId, false, ampersandId);
                    }
                    return this.makeRes(i);
                }
                case 38: {
                    this.advance();
                    switch (this.nextChar) {
                        case 91: {
                            ampersandId = true;
                            break;
                        }
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: {
                            ampersandId = true;
                            continue block76;
                        }
                        default: {
                            return this.makeToken(61, "&");
                        }
                    }
                }
                case 91: {
                    StringBuilder id = new StringBuilder();
                    block79: while (true) {
                        this.advance();
                        switch (this.nextChar) {
                            case 93: {
                                this.advance();
                                if (this.nextChar == 93) {
                                    id.append(']');
                                    continue block79;
                                }
                                if (ampersandId) {
                                    ampersandId = false;
                                    return this.makeId(id.toString(), true, true);
                                }
                                return this.makeId(id.toString(), true, false);
                            }
                            case -1: {
                                if (ampersandId) {
                                    ampersandId = false;
                                    return this.makeId(id.toString(), true, true);
                                }
                                return this.makeId(id.toString(), true, false);
                            }
                        }
                        id.append((char)this.nextChar);
                    }
                }
                case 58: {
                    this.advance();
                    return this.makeToken(37, ":");
                }
                case 44: {
                    this.advance();
                    return this.makeToken(38, ",");
                }
                case 61: {
                    this.advance();
                    return this.makeToken(41, "=");
                }
                case 60: {
                    this.advance();
                    switch (this.nextChar) {
                        case 62: {
                            this.advance();
                            return this.makeToken(49, "<>");
                        }
                        case 61: {
                            this.advance();
                            return this.makeToken(45, "<=");
                        }
                    }
                    return this.makeToken(47, "<");
                }
                case 62: {
                    this.advance();
                    switch (this.nextChar) {
                        case 61: {
                            this.advance();
                            return this.makeToken(42, ">=");
                        }
                    }
                    return this.makeToken(43, ">");
                }
                case 123: {
                    this.advance();
                    return this.makeToken(44, "{");
                }
                case 40: {
                    this.advance();
                    return this.makeToken(46, "(");
                }
                case 125: {
                    this.advance();
                    return this.makeToken(51, "}");
                }
                case 41: {
                    this.advance();
                    return this.makeToken(52, ")");
                }
                case 43: {
                    this.advance();
                    return this.makeToken(50, "+");
                }
                case 45: {
                    this.advance();
                    return this.makeToken(48, "-");
                }
                case 42: {
                    this.advance();
                    return this.makeToken(36, "*");
                }
                case 47: {
                    this.advance();
                    return this.makeToken(53, "/");
                }
                case 124: {
                    this.advance();
                    switch (this.nextChar) {
                        case 124: {
                            this.advance();
                            return this.makeToken(39, "||");
                        }
                    }
                    return this.makeToken(61, "|");
                }
                case 34: {
                    StringBuilder id = new StringBuilder();
                    block80: while (true) {
                        this.advance();
                        switch (this.nextChar) {
                            case 34: {
                                this.advance();
                                if (this.nextChar == 34) {
                                    id.append('\"');
                                    continue block80;
                                }
                                return this.makeString(id.toString());
                            }
                            case -1: {
                                return this.makeString(id.toString());
                            }
                        }
                        id.append((char)this.nextChar);
                    }
                }
                case 39: {
                    if (this.previousSymbol == 3) {
                        this.inFormula = true;
                    }
                    StringBuilder id = new StringBuilder();
                    block81: while (true) {
                        this.advance();
                        switch (this.nextChar) {
                            case 39: {
                                this.advance();
                                if (this.nextChar == 39) {
                                    id.append('\'');
                                    continue block81;
                                }
                                return this.makeString(id.toString());
                            }
                            case -1: {
                                return this.makeString(id.toString());
                            }
                        }
                        id.append((char)this.nextChar);
                    }
                }
                case -1: {
                    return this.makeToken(0, "EOF");
                }
                default: {
                    if (this.nextChar <= 65535 && Character.isWhitespace(this.nextChar)) break;
                    throw new MdxParseException(this.createRegion(this.iPrevChar, this.iChar), "Unexpected character '" + (char)this.nextChar + "'");
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
            }
            this.iPrevChar = this.iChar;
            this.advance();
        }
    }

    ParseRegion createRegion(int left, int right) {
        int lineStart;
        int target = left;
        int line = -1;
        int lineEnd = 0;
        do {
            lineStart = lineEnd;
            lineEnd = Integer.MAX_VALUE;
            if (++line >= this.lines.size()) continue;
            lineEnd = this.lines.get(line);
        } while (lineEnd < target);
        int startLine = line;
        int startColumn = target - lineStart;
        if (right == left) {
            return new ParseRegion(startLine + 1, startColumn + 1);
        }
        target = right - 1;
        if (target > left) {
            --target;
        }
        line = -1;
        lineEnd = 0;
        do {
            lineStart = lineEnd;
            lineEnd = Integer.MAX_VALUE;
            if (++line >= this.lines.size()) continue;
            lineEnd = this.lines.get(line);
        } while (lineEnd < target);
        int endLine = line;
        int endColumn = target - lineStart;
        return new ParseRegion(startLine + 1, startColumn + 1, endLine + 1, endColumn + 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        leftOfPoint,
        rightOfPoint,
        inExponent;

    }
}

