/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hive.io.HiveIOExceptionHandlerUtil;
import org.apache.hadoop.hive.shims.CombineHiveKey;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.lib.CombineFileInputFormat;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.HadoopArchives;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class Hadoop20Shims
implements HadoopShims {
    String[] ret = new String[2];

    @Override
    public boolean usesJobShell() {
        return false;
    }

    @Override
    public boolean fileSystemDeleteOnExit(FileSystem fs, Path path) throws IOException {
        return fs.deleteOnExit(path);
    }

    @Override
    public void inputFormatValidateInput(InputFormat fmt, JobConf conf) throws IOException {
    }

    @Override
    public boolean isJobPreparing(RunningJob job) throws IOException {
        return job.getJobState() == 4;
    }

    @Override
    public void setTmpFiles(String prop, String files) {
    }

    @Override
    public HadoopShims.MiniDFSShim getMiniDfs(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        return new MiniDFSShim(new MiniDFSCluster(conf, numDataNodes, format, racks));
    }

    @Override
    public int compareText(Text a, Text b) {
        return a.compareTo((BinaryComparable)b);
    }

    @Override
    public long getAccessTime(FileStatus file) {
        return file.getAccessTime();
    }

    @Override
    public HadoopShims.CombineFileInputFormatShim getCombineFileInputFormat() {
        return new CombineFileInputFormatShim(){

            public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
                throw new IOException("CombineFileInputFormat.getRecordReader not needed.");
            }
        };
    }

    @Override
    public String getInputFormatClassName() {
        return "org.apache.hadoop.hive.ql.io.CombineHiveInputFormat";
    }

    @Override
    public String[] getTaskJobIDs(TaskCompletionEvent t) {
        TaskID tid = t.getTaskAttemptId().getTaskID();
        this.ret[0] = tid.toString();
        this.ret[1] = tid.getJobID().toString();
        return this.ret;
    }

    @Override
    public void setFloatConf(Configuration conf, String varName, float val) {
        conf.setFloat(varName, val);
    }

    @Override
    public int createHadoopArchive(Configuration conf, Path sourceDir, Path destDir, String archiveName) throws Exception {
        HadoopArchives har = new HadoopArchives(conf);
        ArrayList<String> args = new ArrayList<String>();
        if (conf.get("hive.archive.har.parentdir.settable") == null) {
            throw new RuntimeException("hive.archive.har.parentdir.settable is not set");
        }
        boolean parentSettable = conf.getBoolean("hive.archive.har.parentdir.settable", false);
        if (parentSettable) {
            args.add("-archiveName");
            args.add(archiveName);
            args.add("-p");
            args.add(sourceDir.toString());
            args.add(destDir.toString());
        } else {
            args.add("-archiveName");
            args.add(archiveName);
            args.add(sourceDir.toString());
            args.add(destDir.toString());
        }
        return ToolRunner.run((Tool)har, (String[])args.toArray(new String[0]));
    }

    @Override
    public void setNullOutputFormat(JobConf conf) {
        conf.setOutputFormat(NullOutputFormat.class);
        conf.setOutputCommitter(NullOutputCommitter.class);
        conf.setBoolean("mapred.committer.job.setup.cleanup.needed", false);
        conf.setBoolean("mapreduce.job.committer.task.cleanup.needed", false);
    }

    @Override
    public UserGroupInformation getUGIForConf(Configuration conf) throws LoginException {
        UnixUserGroupInformation ugi = UnixUserGroupInformation.readFromConf((Configuration)conf, (String)"hadoop.job.ugi");
        if (ugi == null) {
            ugi = UserGroupInformation.login((Configuration)conf);
        }
        return ugi;
    }

    @Override
    public boolean isSecureShimImpl() {
        return false;
    }

    @Override
    public String getShortUserName(UserGroupInformation ugi) {
        return ugi.getUserName();
    }

    @Override
    public String getTokenStrForm(String tokenSignature) throws IOException {
        throw new UnsupportedOperationException("Tokens are not supported in current hadoop version");
    }

    @Override
    public void doAs(UserGroupInformation ugi, PrivilegedExceptionAction<Void> pvea) throws IOException, InterruptedException {
        try {
            Subject.doAs(SecurityUtil.getSubject((UserGroupInformation)ugi), pvea);
        }
        catch (PrivilegedActionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public UserGroupInformation createRemoteUser(String userName, List<String> groupNames) {
        return new UnixUserGroupInformation(userName, groupNames.toArray(new String[0]));
    }

    @Override
    public HadoopShims.JobTrackerState getJobTrackerState(ClusterStatus clusterStatus) throws Exception {
        switch (clusterStatus.getJobTrackerState()) {
            case INITIALIZING: {
                return HadoopShims.JobTrackerState.INITIALIZING;
            }
            case RUNNING: {
                return HadoopShims.JobTrackerState.RUNNING;
            }
        }
        String errorMsg = "Unrecognized JobTracker state: " + clusterStatus.getJobTrackerState();
        throw new Exception(errorMsg);
    }

    @Override
    public TaskAttemptContext newTaskAttemptContext(Configuration conf, final Progressable progressable) {
        return new TaskAttemptContext(conf, new TaskAttemptID()){

            public void progress() {
                progressable.progress();
            }
        };
    }

    @Override
    public org.apache.hadoop.mapreduce.JobContext newJobContext(Job job) {
        return new org.apache.hadoop.mapreduce.JobContext(job.getConfiguration(), job.getJobID());
    }

    public static class NullOutputCommitter
    extends OutputCommitter {
        public void setupJob(JobContext jobContext) {
        }

        public void cleanupJob(JobContext jobContext) {
        }

        public void setupTask(org.apache.hadoop.mapred.TaskAttemptContext taskContext) {
        }

        public boolean needsTaskCommit(org.apache.hadoop.mapred.TaskAttemptContext taskContext) {
            return false;
        }

        public void commitTask(org.apache.hadoop.mapred.TaskAttemptContext taskContext) {
        }

        public void abortTask(org.apache.hadoop.mapred.TaskAttemptContext taskContext) {
        }
    }

    public static abstract class CombineFileInputFormatShim<K, V>
    extends CombineFileInputFormat<K, V>
    implements HadoopShims.CombineFileInputFormatShim<K, V> {
        @Override
        public Path[] getInputPathsShim(JobConf conf) {
            try {
                return FileInputFormat.getInputPaths((JobConf)conf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void createPool(JobConf conf, PathFilter ... filters) {
            super.createPool(conf, filters);
        }

        public InputSplitShim[] getSplits(JobConf job, int numSplits) throws IOException {
            long minSize = job.getLong("mapred.min.split.size", 0L);
            if (job.getLong("mapred.min.split.size.per.node", 0L) == 0L) {
                super.setMinSplitSizeNode(minSize);
            }
            if (job.getLong("mapred.min.split.size.per.rack", 0L) == 0L) {
                super.setMinSplitSizeRack(minSize);
            }
            if (job.getLong("mapred.max.split.size", 0L) == 0L) {
                super.setMaxSplitSize(minSize);
            }
            CombineFileSplit[] splits = (CombineFileSplit[])super.getSplits(job, numSplits);
            InputSplitShim[] isplits = new InputSplitShim[splits.length];
            for (int pos = 0; pos < splits.length; ++pos) {
                isplits[pos] = new InputSplitShim(splits[pos]);
            }
            return isplits;
        }

        @Override
        public InputSplitShim getInputSplitShim() throws IOException {
            return new InputSplitShim();
        }

        @Override
        public RecordReader getRecordReader(JobConf job, HadoopShims.InputSplitShim split, Reporter reporter, Class<RecordReader<K, V>> rrClass) throws IOException {
            CombineFileSplit cfSplit = (CombineFileSplit)split;
            return new CombineFileRecordReader<K, V>(job, cfSplit, reporter, rrClass);
        }
    }

    public static class CombineFileRecordReader<K, V>
    implements RecordReader<K, V> {
        static final Class[] constructorSignature = new Class[]{InputSplit.class, Configuration.class, Reporter.class, Integer.class};
        protected CombineFileSplit split;
        protected JobConf jc;
        protected Reporter reporter;
        protected Class<RecordReader<K, V>> rrClass;
        protected Constructor<RecordReader<K, V>> rrConstructor;
        protected FileSystem fs;
        protected int idx;
        protected long progress;
        protected RecordReader<K, V> curReader;
        protected boolean isShrinked;
        protected long shrinkedLength;

        public boolean next(K key, V value) throws IOException {
            while (this.curReader == null || !this.doNextWithExceptionHandler(((CombineHiveKey)key).getKey(), value)) {
                if (this.initNextRecordReader(key)) continue;
                return false;
            }
            return true;
        }

        public K createKey() {
            Object newKey = this.curReader.createKey();
            return (K)new CombineHiveKey(newKey);
        }

        public V createValue() {
            return (V)this.curReader.createValue();
        }

        public long getPos() throws IOException {
            return this.progress;
        }

        public void close() throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
            }
        }

        public float getProgress() throws IOException {
            return Math.min(1.0f, (float)this.progress / (float)this.split.getLength());
        }

        public CombineFileRecordReader(JobConf job, CombineFileSplit split, Reporter reporter, Class<RecordReader<K, V>> rrClass) throws IOException {
            this.split = split;
            this.jc = job;
            this.rrClass = rrClass;
            this.reporter = reporter;
            this.idx = 0;
            this.curReader = null;
            this.progress = 0L;
            this.isShrinked = false;
            assert (split instanceof InputSplitShim);
            if (((InputSplitShim)split).isShrinked()) {
                this.isShrinked = true;
                this.shrinkedLength = ((InputSplitShim)split).getShrinkedLength();
            }
            try {
                this.rrConstructor = rrClass.getDeclaredConstructor(constructorSignature);
                this.rrConstructor.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(rrClass.getName() + " does not have valid constructor", e);
            }
            this.initNextRecordReader(null);
        }

        private boolean doNextWithExceptionHandler(K key, V value) throws IOException {
            try {
                return this.curReader.next(key, value);
            }
            catch (Exception e) {
                return HiveIOExceptionHandlerUtil.handleRecordReaderNextException(e, this.jc);
            }
        }

        protected boolean initNextRecordReader(K key) throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
                if (this.idx > 0) {
                    this.progress += this.split.getLength(this.idx - 1);
                }
            }
            if (this.idx == this.split.getNumPaths() || this.isShrinked && this.progress > this.shrinkedLength) {
                return false;
            }
            try {
                this.curReader = this.rrConstructor.newInstance(this.split, this.jc, this.reporter, this.idx);
                if (key != null) {
                    Object newKey = this.curReader.createKey();
                    ((CombineHiveKey)key).setKey(newKey);
                }
                this.jc.set("map.input.file", this.split.getPath(this.idx).toString());
                this.jc.setLong("map.input.start", this.split.getOffset(this.idx));
                this.jc.setLong("map.input.length", this.split.getLength(this.idx));
            }
            catch (Exception e) {
                this.curReader = HiveIOExceptionHandlerUtil.handleRecordReaderCreationException(e, this.jc);
            }
            ++this.idx;
            return true;
        }
    }

    public static class InputSplitShim
    extends CombineFileSplit
    implements HadoopShims.InputSplitShim {
        long shrinkedLength;
        boolean _isShrinked = false;

        public InputSplitShim() {
        }

        public InputSplitShim(CombineFileSplit old) throws IOException {
            super(old);
        }

        @Override
        public void shrinkSplit(long length) {
            this._isShrinked = true;
            this.shrinkedLength = length;
        }

        public boolean isShrinked() {
            return this._isShrinked;
        }

        public long getShrinkedLength() {
            return this.shrinkedLength;
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
            this._isShrinked = in.readBoolean();
            if (this._isShrinked) {
                this.shrinkedLength = in.readLong();
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            super.write(out);
            out.writeBoolean(this._isShrinked);
            if (this._isShrinked) {
                out.writeLong(this.shrinkedLength);
            }
        }
    }

    public class MiniDFSShim
    implements HadoopShims.MiniDFSShim {
        private final MiniDFSCluster cluster;

        public MiniDFSShim(MiniDFSCluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public FileSystem getFileSystem() throws IOException {
            return this.cluster.getFileSystem();
        }

        @Override
        public void shutdown() {
            this.cluster.shutdown();
        }
    }
}

