/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.utils.RoundGradientPaint;
import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;

public class PageFormatPreviewPanel
extends JPanel {
    private int pageWidth = 0;
    private int pageHeight = 0;
    private int marginTop = 0;
    private int marginLeft = 0;
    private int marginBottom = 0;
    private int marginRight = 0;
    private int columns = 0;
    private int columnWidth = 0;
    private int columnSpace = 0;

    public PageFormatPreviewPanel() {
        this.initComponents();
    }

    public void paint(Graphics g) {
        super.paint(g);
        try {
            if (this.getPageHeight() == 0 || this.getPageWidth() == 0) {
                return;
            }
            double wRatio = (double)(this.getWidth() - 20) / (double)this.getPageWidth();
            double hRatio = (double)(this.getHeight() - 20) / (double)this.getPageHeight();
            double ratio = Math.min(wRatio, hRatio);
            int leftGap = (int)(((double)this.getWidth() - (double)this.getPageWidth() * ratio) / 2.0);
            int topGap = (int)(((double)this.getHeight() - (double)this.getPageHeight() * ratio) / 2.0);
            Graphics2D g2 = (Graphics2D)g;
            this.paintPageShadow(g, leftGap - 10, topGap - 10, (double)this.getPageWidth() * ratio + 20.0, (double)this.getPageHeight() * ratio + 20.0);
            g2.setColor(Color.WHITE);
            GradientPaint gp = new GradientPaint(leftGap + 10, topGap + 10, Color.WHITE, (float)((double)this.getPageWidth() * ratio), (float)((double)this.getPageHeight() * ratio), new Color(208, 218, 229));
            g2.setPaint(gp);
            g2.fill(new Rectangle2D.Double(leftGap, topGap, (double)this.getPageWidth() * ratio, (double)this.getPageHeight() * ratio));
            g2.setColor(ReportObjectScene.DESIGN_LINE_COLOR);
            g2.draw(new Rectangle2D.Double(leftGap, topGap, (double)this.getPageWidth() * ratio, (double)this.getPageHeight() * ratio));
            g2.draw(new Line2D.Double((double)leftGap + (double)this.getMarginLeft() * ratio, topGap, (double)leftGap + (double)this.getMarginLeft() * ratio, this.getHeight() - topGap));
            g2.draw(new Line2D.Double((double)leftGap + (double)(this.getPageWidth() - this.getMarginRight()) * ratio, topGap, (double)leftGap + (double)(this.getPageWidth() - this.getMarginRight()) * ratio, this.getHeight() - topGap));
            g2.draw(new Line2D.Double(leftGap, (double)topGap + (double)this.getMarginTop() * ratio, this.getWidth() - leftGap, (double)topGap + (double)this.getMarginTop() * ratio));
            g2.draw(new Line2D.Double(leftGap, (double)(this.getHeight() - topGap) - (double)this.getMarginBottom() * ratio, this.getWidth() - leftGap, (double)(this.getHeight() - topGap) - (double)this.getMarginBottom() * ratio));
            if (this.getColumns() > 1) {
                int x = this.getMarginLeft();
                for (int i = 0; i < this.getColumns(); ++i) {
                    g2.draw(new Line2D.Double((double)leftGap + (double)(x += this.getColumnWidth()) * ratio, topGap, (double)leftGap + (double)x * ratio, this.getHeight() - topGap));
                    if (i >= this.getColumns() - 1) continue;
                    g2.draw(new Line2D.Double((double)leftGap + (double)(x += this.getColumnSpace()) * ratio, topGap, (double)leftGap + (double)x * ratio, this.getHeight() - topGap));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paintPageShadow(Graphics g, double x, double y, double width, double height) {
        Rectangle2D.Double r = new Rectangle2D.Double(x + 10.0, y, width - 20.0, 10.0);
        GradientPaint gp = new GradientPaint(0.0f, (float)(y + 2.0), new Color(0, 0, 0, 0), 0.0f, (float)(y + 9.5), new Color(0, 0, 0, 60));
        ((Graphics2D)g).setPaint(gp);
        ((Graphics2D)g).fill(r);
        r = new Rectangle2D.Double(x + 10.0, y + height - 10.0, width - 20.0, 10.0);
        gp = new GradientPaint(0.0f, (float)((RectangularShape)r).getY(), new Color(0, 0, 0, 60), 0.0f, (float)(((RectangularShape)r).getY() + 7.5), new Color(0, 0, 0, 0));
        ((Graphics2D)g).setPaint(gp);
        ((Graphics2D)g).fill(r);
        r = new Rectangle2D.Double(x, y + 10.0, 10.0, height - 20.0);
        gp = new GradientPaint((float)(((RectangularShape)r).getX() + 2.0), 0.0f, new Color(0, 0, 0, 0), (float)(((RectangularShape)r).getX() + 9.5), 0.0f, new Color(0, 0, 0, 60));
        ((Graphics2D)g).setPaint(gp);
        ((Graphics2D)g).fill(r);
        r = new Rectangle2D.Double(x + width - 10.0, y + 10.0, 10.0, height - 20.0);
        gp = new GradientPaint((float)((RectangularShape)r).getX(), 0.0f, new Color(0, 0, 0, 60), (float)(((RectangularShape)r).getX() + 7.5), 0.0f, new Color(0, 0, 0, 0));
        ((Graphics2D)g).setPaint(gp);
        ((Graphics2D)g).fill(r);
        r = new Rectangle2D.Double(x, y, 10.0, 10.0);
        RoundGradientPaint rgp = new RoundGradientPaint(x + (double)9.8f, y + (double)9.8f, new Color(0, 0, 0, 60), new Point2D.Float(0.0f, 6.8f), new Color(0, 0, 0, 0));
        ((Graphics2D)g).setPaint(rgp);
        ((Graphics2D)g).fill(r);
        r = new Rectangle2D.Double(x + width - 10.0, y, 10.0, 10.0);
        rgp = new RoundGradientPaint(((RectangularShape)r).getX() + 0.5, ((RectangularShape)r).getY() + 9.5, new Color(0, 0, 0, 60), new Point2D.Float(0.0f, 6.5f), new Color(0, 0, 0, 0));
        ((Graphics2D)g).setPaint(rgp);
        ((Graphics2D)g).fill(r);
        r = new Rectangle2D.Double(x + width - 10.0, y + height - 10.0, 10.0, 10.0);
        rgp = new RoundGradientPaint(((RectangularShape)r).getX() + 0.5, ((RectangularShape)r).getY() + 0.5, new Color(0, 0, 0, 60), new Point2D.Float(0.0f, 6.5f), new Color(0, 0, 0, 0));
        ((Graphics2D)g).setPaint(rgp);
        ((Graphics2D)g).fill(r);
        r = new Rectangle2D.Double(x, y + height - 10.0, 10.0, 10.0);
        rgp = new RoundGradientPaint(((RectangularShape)r).getX() + 9.5, ((RectangularShape)r).getY() + 0.5, new Color(0, 0, 0, 60), new Point2D.Float(0.0f, 6.5f), new Color(0, 0, 0, 0));
        ((Graphics2D)g).setPaint(rgp);
        ((Graphics2D)g).fill(r);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
    }

    protected int getPageWidth() {
        return this.pageWidth;
    }

    protected void setPageWidth(int pageWidth) {
        this.pageWidth = pageWidth;
    }

    protected int getPageHeight() {
        return this.pageHeight;
    }

    protected void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
    }

    protected int getMarginTop() {
        return this.marginTop;
    }

    protected void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    protected int getMarginLeft() {
        return this.marginLeft;
    }

    protected void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    protected int getMarginBottom() {
        return this.marginBottom;
    }

    protected void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    protected int getMarginRight() {
        return this.marginRight;
    }

    protected void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    protected int getColumns() {
        return this.columns;
    }

    protected void setColumns(int columns) {
        this.columns = columns;
    }

    protected int getColumnWidth() {
        return this.columnWidth;
    }

    protected void setColumnWidth(int columnWidth) {
        this.columnWidth = columnWidth;
    }

    protected int getColumnSpace() {
        return this.columnSpace;
    }

    protected void setColumnSpace(int columnSpace) {
        this.columnSpace = columnSpace;
    }
}

