/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.NotRealElementNode;
import com.jaspersoft.ireport.designer.actions.AddAnotherDetailBandAction;
import com.jaspersoft.ireport.designer.actions.AddAnotherGroupFooterBandAction;
import com.jaspersoft.ireport.designer.actions.AddAnotherGroupHeaderBandAction;
import com.jaspersoft.ireport.designer.actions.DeleteBandAction;
import com.jaspersoft.ireport.designer.actions.DeleteGroupAction;
import com.jaspersoft.ireport.designer.actions.MaximizeBackgroundAction;
import com.jaspersoft.ireport.designer.actions.MaximizeBandAction;
import com.jaspersoft.ireport.designer.actions.MoveGroupDownAction;
import com.jaspersoft.ireport.designer.actions.MoveGroupUpAction;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.outline.nodes.ElementContainerChildren;
import com.jaspersoft.ireport.designer.outline.nodes.ElementGroupNode;
import com.jaspersoft.ireport.designer.outline.nodes.ElementPasteType;
import com.jaspersoft.ireport.designer.outline.nodes.GroupNode;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.sheet.properties.AbstractProperty;
import com.jaspersoft.ireport.designer.sheet.properties.BandPrintWhenExpressionProperty;
import com.jaspersoft.ireport.designer.sheet.properties.BooleanProperty;
import com.jaspersoft.ireport.designer.sheet.properties.GroupExpressionProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.type.FooterPositionEnum;
import net.sf.jasperreports.engine.type.SplitTypeEnum;
import org.openide.ErrorManager;
import org.openide.actions.PasteAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class BandNode
extends IRIndexedNode
implements PropertyChangeListener,
GroupNode {
    private final JasperDesign jd;
    private final JRDesignBand band;
    private final JRDesignGroup group;

    public BandNode(JasperDesign jd, JRDesignBand band, Lookup doLkp) {
        this(new ElementContainerChildren(jd, (JRDesignElementGroup)band, doLkp), jd, band, doLkp);
    }

    public BandNode(ElementContainerChildren pc, JasperDesign jd, JRDesignBand band, Lookup doLkp) {
        super((Children)pc, pc.getIndex(), (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{jd, band}), doLkp}));
        this.jd = jd;
        this.band = band;
        if (ModelUtils.isGroupHeader((JRBand)band, jd)) {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/groupheader-16.png");
        } else if (ModelUtils.isGroupFooter((JRBand)band, jd)) {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/groupfooter-16.png");
        } else {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/band-16.png");
        }
        this.band.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        if (band.getOrigin().getBandTypeValue() == BandTypeEnum.DETAIL) {
            ((JRDesignSection)jd.getDetailSection()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.group = ModelUtils.getGroupFromBand(jd, band);
        if (this.group != null) {
            this.group.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            ((JRDesignSection)this.group.getGroupHeaderSection()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            ((JRDesignSection)this.group.getGroupFooterSection()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.setDisplayName(ModelUtils.nameOf((JRBand)band, jd));
        this.addNodeListener(new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
            }

            public void childrenRemoved(NodeMemberEvent ev) {
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void propertyChange(PropertyChangeEvent evt) {
            }

            public void childrenReordered(NodeReorderEvent ev) {
                int i;
                List elements = BandNode.this.getBand().getChildren();
                int[] permutations = ev.getPermutation();
                Object[] elementsArray = new Object[elements.size()];
                for (i = 0; i < elementsArray.length; ++i) {
                    elementsArray[permutations[i]] = elements.get(i);
                }
                elements.clear();
                for (i = 0; i < elementsArray.length; ++i) {
                    elements.add(elementsArray[i]);
                }
                BandNode.this.getBand().getEventSupport().firePropertyChange("children", null, (Object)BandNode.this.getBand().getChildren());
            }
        });
    }

    public String getHtmlDisplayName() {
        return this.getDisplayName();
    }

    public JRDesignDataset getDataset() {
        return this.jd.getMainDesignDataset();
    }

    public JRDesignGroup getGroup() {
        if (this.band.getOrigin().getGroupName() != null) {
            return (JRDesignGroup)this.getDataset().getGroupsMap().get(this.band.getOrigin().getGroupName());
        }
        return null;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set bandPropertiesSet = Sheet.createPropertiesSet();
        bandPropertiesSet.setName("BAND_PROPERTIES");
        bandPropertiesSet.setDisplayName(I18n.getString("BandNode.Property.Bandproperties"));
        bandPropertiesSet.put((Node.Property)new HeightProperty(this.band, this.jd));
        bandPropertiesSet.put((Node.Property)new BandPrintWhenExpressionProperty(this.band, this.jd.getMainDesignDataset()));
        bandPropertiesSet.put((Node.Property)new SplitTypeProperty(this.band));
        sheet.put(bandPropertiesSet);
        if (this.group != null) {
            Sheet.Set groupPropertiesSet = Sheet.createPropertiesSet();
            groupPropertiesSet.setName("GROUP_PROPERTIES");
            groupPropertiesSet.setDisplayName(I18n.getString("BandNode.Property.Groupproperties"));
            groupPropertiesSet = BandNode.fillGroupPropertySet(groupPropertiesSet, this.jd.getMainDesignDataset(), this.group);
            sheet.put(groupPropertiesSet);
        }
        return sheet;
    }

    public static Sheet.Set fillGroupPropertySet(Sheet.Set groupPropertiesSet, JRDesignDataset dataset, JRDesignGroup group) {
        groupPropertiesSet.put((Node.Property)new GroupNameProperty(group, dataset));
        groupPropertiesSet.put((Node.Property)new GroupExpressionProperty(group, dataset));
        if (dataset.isMainDataset()) {
            groupPropertiesSet.put((Node.Property)new StartNewPageProperty(group));
            groupPropertiesSet.put((Node.Property)new StartNewColumnProperty(group));
            groupPropertiesSet.put((Node.Property)new ResetPageNumberProperty(group));
            groupPropertiesSet.put((Node.Property)new ReprintHeaderProperty(group));
            groupPropertiesSet.put((Node.Property)new MinHeightToStartNewPageProperty(group));
            groupPropertiesSet.put((Node.Property)new MinHeightToStartNewPageProperty(group));
            groupPropertiesSet.put((Node.Property)new FooterPositionProperty(group));
            groupPropertiesSet.put((Node.Property)new KeepTogetherProperty(group));
        }
        return groupPropertiesSet;
    }

    public JRDesignBand getBand() {
        return this.band;
    }

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (ModelUtils.containsProperty(this.getPropertySets(), evt.getPropertyName())) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
        if (evt.getPropertyName().equals("name") || evt.getPropertyName().equals("bands")) {
            String s = ModelUtils.nameOf((JRBand)this.band, this.jd);
            this.setDisplayName(s);
            this.fireNameChange(null, this.getDisplayName());
        }
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public Action[] getActions(boolean popup) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(SystemAction.get(PasteAction.class));
        list.add(SystemAction.get(RefreshNodes.class));
        if (this.getBand().getOrigin().getBandTypeValue() == BandTypeEnum.BACKGROUND) {
            list.add(SystemAction.get(MaximizeBackgroundAction.class));
        } else {
            list.add(SystemAction.get(MaximizeBandAction.class));
        }
        if (this.getBand().getOrigin().getBandTypeValue() == BandTypeEnum.DETAIL) {
            list.add(SystemAction.get(AddAnotherDetailBandAction.class));
        }
        if (this.group != null) {
            list.add(null);
            list.add(SystemAction.get(MoveGroupUpAction.class));
            list.add(SystemAction.get(MoveGroupDownAction.class));
            list.add((Object)DeleteGroupAction.getInstance());
            list.add(null);
            list.add(SystemAction.get(AddAnotherGroupHeaderBandAction.class));
            list.add(SystemAction.get(AddAnotherGroupFooterBandAction.class));
        }
        list.add((Object)DeleteBandAction.getInstance());
        return list.toArray(new Action[list.size()]);
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        Node[] dropNodes = NodeTransfer.nodes((Transferable)t, (int)7);
        int dropAction = DnDUtilities.getTransferAction(t);
        if (dropNode == null) {
            ElementPasteType.setLastPastedNodes(dropNodes);
        }
        if (null != dropNode && !(dropNode instanceof NotRealElementNode)) {
            JRDesignElement element = (JRDesignElement)dropNode.getLookup().lookup(JRDesignElement.class);
            if (null != element) {
                return new ElementPasteType(element.getElementGroup(), (JRElementGroup)this.getBand(), element, dropAction, (Node)this);
            }
            if (dropNode instanceof ElementGroupNode) {
                JRDesignElementGroup g = ((ElementGroupNode)dropNode).getElementGroup();
                return new ElementPasteType(g.getElementGroup(), (JRElementGroup)this.getBand(), g, dropAction, (Node)this);
            }
        }
        return null;
    }

    private static final class KeepTogetherProperty
    extends BooleanProperty {
        private final JRDesignGroup group;

        public KeepTogetherProperty(JRDesignGroup group) {
            super(group);
            this.group = group;
        }

        public String getName() {
            return "keepTogether";
        }

        public String getDisplayName() {
            return I18n.getString("Global.Property.KeepTogether");
        }

        public String getShortDescription() {
            return I18n.getString("Global.Property.KeepTogether.description");
        }

        public Boolean getBoolean() {
            return this.getOwnBoolean();
        }

        public Boolean getOwnBoolean() {
            return this.group.isKeepTogether();
        }

        public Boolean getDefaultBoolean() {
            return false;
        }

        public void setBoolean(Boolean value) {
            if (value == null) {
                value = false;
            }
            this.group.setKeepTogether(value.booleanValue());
        }
    }

    private static final class FooterPositionProperty
    extends AbstractProperty {
        private final JRDesignGroup group;
        private ComboBoxPropertyEditor editor;

        public FooterPositionProperty(JRDesignGroup group) {
            super(FooterPositionEnum.class, group);
            this.group = group;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                this.editor = new ComboBoxPropertyEditor(false, this.getTagList());
            }
            return this.editor;
        }

        public String getName() {
            return "footerPosition";
        }

        public String getDisplayName() {
            return I18n.getString("Global.Property.FooterPosition");
        }

        public String getShortDescription() {
            return I18n.getString("Global.Property.FooterPosition.description");
        }

        public List getTagList() {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tags.add(new Tag(FooterPositionEnum.NORMAL, I18n.getString("Global.Property.FooterPosition.normal")));
            tags.add(new Tag(FooterPositionEnum.STACK_AT_BOTTOM, I18n.getString("Global.Property.FooterPosition.stackAtBottom")));
            tags.add(new Tag(FooterPositionEnum.FORCE_AT_BOTTOM, I18n.getString("Global.Property.FooterPosition.forceAtBottom")));
            tags.add(new Tag(FooterPositionEnum.COLLATE_AT_BOTTOM, I18n.getString("Global.Property.FooterPosition.collateAtBottom")));
            return tags;
        }

        public Object getPropertyValue() {
            return this.group.getFooterPositionValue();
        }

        public Object getOwnPropertyValue() {
            return this.getPropertyValue();
        }

        public Object getDefaultValue() {
            return FooterPositionEnum.NORMAL;
        }

        public void validate(Object value) {
        }

        public void setPropertyValue(Object value) {
            this.group.setFooterPosition((FooterPositionEnum)value);
        }
    }

    private static final class SplitTypeProperty
    extends PropertySupport {
        private final JRDesignBand band;
        private ComboBoxPropertyEditor editor;

        public SplitTypeProperty(JRDesignBand band) {
            super("net.sf.jasperreports.band.split.type", Byte.class, I18n.getString("band.property.splitType.name"), I18n.getString("band.property.splitType.description"), true, true);
            this.band = band;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(null, "<Default>"));
                l.add(new Tag(SplitTypeEnum.IMMEDIATE, I18n.getString("band.property.splitType.immediate")));
                l.add(new Tag(SplitTypeEnum.PREVENT, I18n.getString("band.property.splitType.prevent")));
                l.add(new Tag(SplitTypeEnum.STRETCH, I18n.getString("band.property.splitType.stretch")));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.band.getSplitTypeValue();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (IReportManager.getPreferences().getBoolean("designer_debug_mode", false)) {
                System.out.println(new Date() + ": setting SplitType to: " + val + ". If the value is unattended or null, please report this notification to http://jasperforge.org/plugins/mantis/view.php?id=4139");
                Thread.dumpStack();
            }
            if (val == null || val instanceof SplitTypeEnum) {
                SplitTypeEnum oldValue = this.band.getSplitTypeValue();
                SplitTypeEnum newValue = (SplitTypeEnum)val;
                this.band.setSplitType(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.band, "SplitType", SplitTypeEnum.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.band.getSplitTypeValue() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    private static final class MinHeightToStartNewPageProperty
    extends PropertySupport {
        private final JRDesignGroup group;

        public MinHeightToStartNewPageProperty(JRDesignGroup group) {
            super("minHeightToStartNewPage", Integer.class, I18n.getString("BandNode.Property.MinHeight"), I18n.getString("BandNode.Property.MinHeightdetail"), true, true);
            this.group = group;
        }

        public boolean isDefaultValue() {
            return this.group.getMinHeightToStartNewPage() == 0;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setPropertyValue(0);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.group.getMinHeightToStartNewPage();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                this.setPropertyValue((Integer)val);
            }
        }

        private void setPropertyValue(int val) throws IllegalArgumentException {
            Integer oldValue = this.group.getMinHeightToStartNewPage();
            Integer newValue = val;
            if (newValue < 0) {
                IllegalArgumentException iae = this.annotateException(I18n.getString("BandNode.Property.Nodemessage"));
                throw iae;
            }
            this.group.setMinHeightToStartNewPage(newValue.intValue());
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.group, "MinHeightToStartNewPage", Integer.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }

    private static final class ReprintHeaderProperty
    extends PropertySupport {
        private final JRDesignGroup group;

        public ReprintHeaderProperty(JRDesignGroup group) {
            super("reprintHeaderOnEachPage", Boolean.class, I18n.getString("BandNode.Property.ReprintHeader"), I18n.getString("BandNode.Property.ReprintHeaderdetail"), true, true);
            this.group = group;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.group.isReprintHeaderOnEachPage();
        }

        public boolean isDefaultValue() {
            return !this.group.isReprintHeaderOnEachPage();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setPropertyValue(false);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                this.setPropertyValue((Boolean)val);
            }
        }

        private void setPropertyValue(boolean val) {
            Boolean oldValue = this.group.isReprintHeaderOnEachPage();
            Boolean newValue = val;
            this.group.setReprintHeaderOnEachPage(newValue.booleanValue());
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.group, "ReprintHeaderOnEachPage", Boolean.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    private static final class ResetPageNumberProperty
    extends PropertySupport {
        private final JRDesignGroup group;

        public ResetPageNumberProperty(JRDesignGroup group) {
            super("resetPageNumber", Boolean.class, I18n.getString("BandNode.Property.ResetPageNumber"), I18n.getString("BandNode.Property.ResetPageNumberdetail"), true, true);
            this.group = group;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.group.isResetPageNumber();
        }

        public boolean isDefaultValue() {
            return !this.group.isResetPageNumber();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setPropertyValue(false);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                this.setPropertyValue((Boolean)val);
            }
        }

        private void setPropertyValue(boolean val) {
            Boolean oldValue = this.group.isResetPageNumber();
            Boolean newValue = val;
            this.group.setResetPageNumber(newValue.booleanValue());
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.group, "ResetPageNumber", Boolean.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    private static final class StartNewColumnProperty
    extends PropertySupport {
        private final JRDesignGroup group;

        public StartNewColumnProperty(JRDesignGroup group) {
            super("startNewColumn", Boolean.class, I18n.getString("BandNode.Property.NewCol"), I18n.getString("BandNode.Property.NewColdetail"), true, true);
            this.group = group;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.group.isStartNewColumn();
        }

        public boolean isDefaultValue() {
            return !this.group.isStartNewColumn();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setPropertyValue(false);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                this.setPropertyValue((Boolean)val);
            }
        }

        private void setPropertyValue(boolean val) {
            Boolean oldValue = this.group.isStartNewColumn();
            Boolean newValue = val;
            this.group.setStartNewColumn(newValue.booleanValue());
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.group, "StartNewColumn", Boolean.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    private static final class StartNewPageProperty
    extends PropertySupport {
        private final JRDesignGroup group;

        public StartNewPageProperty(JRDesignGroup group) {
            super("startNewPage", Boolean.class, I18n.getString("BandNode.Property.NewPage"), I18n.getString("BandNode.Property.NewPagedetail"), true, true);
            this.group = group;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.group.isStartNewPage();
        }

        public boolean isDefaultValue() {
            return !this.group.isStartNewPage();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setPropertyValue(false);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                this.setPropertyValue((Boolean)val);
            }
        }

        private void setPropertyValue(boolean val) {
            Boolean oldValue = this.group.isStartNewPage();
            Boolean newValue = val;
            this.group.setStartNewPage(newValue.booleanValue());
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.group, "StartNewPage", Boolean.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public static final class GroupNameProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignGroup group;
        private final JRDesignDataset dataset;

        public GroupNameProperty(JRDesignGroup group, JRDesignDataset dataset) {
            super("name", String.class, I18n.getString("BandNode.Property.Name"), I18n.getString("BandNode.Property.Namedetail"));
            this.group = group;
            this.dataset = dataset;
            this.setValue("oneline", Boolean.TRUE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.group.getName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val.equals("")) {
                IllegalArgumentException iae = this.annotateException(I18n.getString("BandNode.Property.NameMessage"));
                throw iae;
            }
            String s = val + "";
            List currentGroups = this.dataset.getGroupsList();
            for (JRGroup gr : currentGroups) {
                JRDesignGroup g = (JRDesignGroup)gr;
                if (g == this.group || !g.getName().equals(s)) continue;
                IllegalArgumentException iae = this.annotateException(I18n.getString("BandNode.Property.Nameexist"));
                throw iae;
            }
            String oldName = this.group.getName();
            this.dataset.getGroupsMap().remove(oldName);
            this.dataset.getGroupsMap().put(s, this.group);
            this.group.setName(s);
            JRDesignVariable var = (JRDesignVariable)this.dataset.getVariablesMap().get(oldName + "_COUNT");
            var.setName(s + "_COUNT");
            this.dataset.getVariablesMap().remove(oldName + "_COUNT");
            this.dataset.getVariablesMap().put(s + "_COUNT", var);
            this.dataset.getEventSupport().firePropertyChange("variables", null, null);
            ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.group, "Name", String.class, oldName, this.group.getName());
            IReportManager.getInstance().addUndoableEdit(opue);
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }

    private static final class HeightProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;
        private final JRDesignBand band;

        public HeightProperty(JRDesignBand band, JasperDesign jd) {
            super("height", Integer.class, I18n.getString("BandNode.Property.Bandheight"), I18n.getString("BandNode.Property.Bandheightdetail"), true, true);
            this.jasperDesign = jd;
            this.band = band;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.band.getHeight();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.band.getHeight();
                Integer newValue = (Integer)val;
                int maxBandHeight = ModelUtils.getMaxBandHeight(this.band, this.jasperDesign);
                if (newValue < 0 || newValue > maxBandHeight) {
                    IllegalArgumentException iae = this.annotateException(I18n.getString("BandNode.Property.bandheightmessagge", maxBandHeight));
                    throw iae;
                }
                this.band.setHeight(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.band, I18n.getString("Global.Property.Height"), Integer.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }

    public static final class RefreshNodes
    extends NodeAction {
        public String getName() {
            return I18n.getString("BandNode.Property.Refreshnodes");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected void performAction(Node[] activatedNodes) {
            ((ElementContainerChildren)activatedNodes[0].getChildren()).recalculateKeys();
        }

        protected boolean enable(Node[] activatedNodes) {
            return activatedNodes.length == 1 && activatedNodes[0] instanceof BandNode;
        }
    }
}

