/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.BandNode;
import com.jaspersoft.ireport.designer.undo.DeleteBandUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class DeleteBandAction
extends NodeAction {
    private static DeleteBandAction instance = null;

    public static synchronized DeleteBandAction getInstance() {
        if (instance == null) {
            instance = new DeleteBandAction();
        }
        return instance;
    }

    private DeleteBandAction() {
    }

    public String getName() {
        return I18n.getString("DeleteBandAction.Name.CTL_DeleteBandAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            JRDesignSection section;
            JRDesignGroup group;
            if (!(activatedNodes[i] instanceof BandNode)) continue;
            BandNode nbn = (BandNode)activatedNodes[i];
            JasperDesign jd = nbn.getJasperDesign();
            JRDesignBand band = nbn.getBand();
            if (jd == null || band == null) continue;
            if (band.getOrigin().getBandTypeValue() == BandTypeEnum.BACKGROUND) {
                jd.setBackground(null);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.TITLE) {
                jd.setTitle(null);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.PAGE_HEADER) {
                jd.setPageHeader(null);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.COLUMN_HEADER) {
                jd.setColumnHeader(null);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.DETAIL) {
                JRDesignSection section2 = (JRDesignSection)jd.getDetailSection();
                section2.removeBand((JRBand)band);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.COLUMN_FOOTER) {
                jd.setColumnFooter(null);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.PAGE_FOOTER) {
                jd.setPageFooter(null);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.LAST_PAGE_FOOTER) {
                jd.setLastPageFooter(null);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.SUMMARY) {
                jd.setSummary(null);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.NO_DATA) {
                jd.setNoData(null);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.GROUP_HEADER) {
                group = (JRDesignGroup)jd.getGroupsMap().get(band.getOrigin().getGroupName());
                section = (JRDesignSection)group.getGroupHeaderSection();
                section.removeBand((JRBand)band);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.GROUP_FOOTER) {
                group = (JRDesignGroup)jd.getGroupsMap().get(band.getOrigin().getGroupName());
                section = (JRDesignSection)group.getGroupFooterSection();
                section.removeBand((JRBand)band);
            }
            DeleteBandUndoableEdit edit = new DeleteBandUndoableEdit(band, jd);
            IReportManager.getInstance().addUndoableEdit(edit);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (activatedNodes[i] instanceof BandNode) continue;
            return false;
        }
        return true;
    }
}

