/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class ReduceSinkOperator
extends TerminalOperator<ReduceSinkDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient ExprNodeEvaluator[] keyEval;
    protected transient ExprNodeEvaluator[] valueEval;
    protected transient ExprNodeEvaluator[] partitionEval;
    transient Serializer keySerializer;
    transient boolean keyIsText;
    transient Serializer valueSerializer;
    transient int tag;
    transient byte[] tagByte = new byte[1];
    protected transient int numDistributionKeys;
    protected transient int numDistinctExprs;
    transient InspectableObject tempInspectableObject = new InspectableObject();
    transient HiveKey keyWritable = new HiveKey();
    transient Writable value;
    transient StructObjectInspector keyObjectInspector;
    transient StructObjectInspector valueObjectInspector;
    transient ObjectInspector[] partitionObjectInspectors;
    transient Object[][] cachedKeys;
    transient Object[] cachedValues;
    transient List<List<Integer>> distinctColIndices;
    boolean firstRow;
    transient Random random;

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        try {
            this.keyEval = new ExprNodeEvaluator[((ReduceSinkDesc)this.conf).getKeyCols().size()];
            int i = 0;
            for (ExprNodeDesc e : ((ReduceSinkDesc)this.conf).getKeyCols()) {
                this.keyEval[i++] = ExprNodeEvaluatorFactory.get(e);
            }
            this.numDistributionKeys = ((ReduceSinkDesc)this.conf).getNumDistributionKeys();
            this.distinctColIndices = ((ReduceSinkDesc)this.conf).getDistinctColumnIndices();
            this.numDistinctExprs = this.distinctColIndices.size();
            this.valueEval = new ExprNodeEvaluator[((ReduceSinkDesc)this.conf).getValueCols().size()];
            i = 0;
            for (ExprNodeDesc e : ((ReduceSinkDesc)this.conf).getValueCols()) {
                this.valueEval[i++] = ExprNodeEvaluatorFactory.get(e);
            }
            this.partitionEval = new ExprNodeEvaluator[((ReduceSinkDesc)this.conf).getPartitionCols().size()];
            i = 0;
            for (ExprNodeDesc e : ((ReduceSinkDesc)this.conf).getPartitionCols()) {
                this.partitionEval[i++] = ExprNodeEvaluatorFactory.get(e);
            }
            this.tag = ((ReduceSinkDesc)this.conf).getTag();
            this.tagByte[0] = (byte)this.tag;
            this.LOG.info((Object)("Using tag = " + this.tag));
            TableDesc keyTableDesc = ((ReduceSinkDesc)this.conf).getKeySerializeInfo();
            this.keySerializer = (Serializer)((Object)keyTableDesc.getDeserializerClass().newInstance());
            this.keySerializer.initialize(null, keyTableDesc.getProperties());
            this.keyIsText = this.keySerializer.getSerializedClass().equals(Text.class);
            TableDesc valueTableDesc = ((ReduceSinkDesc)this.conf).getValueSerializeInfo();
            this.valueSerializer = (Serializer)((Object)valueTableDesc.getDeserializerClass().newInstance());
            this.valueSerializer.initialize(null, valueTableDesc.getProperties());
            this.firstRow = true;
            this.initializeChildren(hconf);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected static StructObjectInspector initEvaluatorsAndReturnStruct(ExprNodeEvaluator[] evals, List<List<Integer>> distinctColIndices, List<String> outputColNames, int length, ObjectInspector rowInspector) throws HiveException {
        int inspectorLen = evals.length > length ? length + 1 : evals.length;
        ArrayList<ObjectInspector> sois = new ArrayList<ObjectInspector>(inspectorLen);
        ObjectInspector[] fieldObjectInspectors = ReduceSinkOperator.initEvaluators(evals, 0, length, rowInspector);
        sois.addAll(Arrays.asList(fieldObjectInspectors));
        if (evals.length > length) {
            ArrayList<ObjectInspector> uois = new ArrayList<ObjectInspector>();
            for (List<Integer> distinctCols : distinctColIndices) {
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<ObjectInspector> eois = new ArrayList<ObjectInspector>();
                int numExprs = 0;
                for (int i : distinctCols) {
                    names.add(HiveConf.getColumnInternalName(numExprs));
                    eois.add(evals[i].initialize(rowInspector));
                    ++numExprs;
                }
                uois.add(ObjectInspectorFactory.getStandardStructObjectInspector(names, eois));
            }
            StandardUnionObjectInspector uoi = ObjectInspectorFactory.getStandardUnionObjectInspector(uois);
            sois.add(uoi);
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(outputColNames, sois);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        try {
            int i;
            int i2;
            ObjectInspector rowInspector = this.inputObjInspectors[tag];
            if (this.firstRow) {
                this.firstRow = false;
                this.keyObjectInspector = ReduceSinkOperator.initEvaluatorsAndReturnStruct(this.keyEval, this.distinctColIndices, ((ReduceSinkDesc)this.conf).getOutputKeyColumnNames(), this.numDistributionKeys, rowInspector);
                this.valueObjectInspector = ReduceSinkOperator.initEvaluatorsAndReturnStruct(this.valueEval, ((ReduceSinkDesc)this.conf).getOutputValueColumnNames(), rowInspector);
                this.partitionObjectInspectors = ReduceSinkOperator.initEvaluators(this.partitionEval, rowInspector);
                int numKeys = this.numDistinctExprs > 0 ? this.numDistinctExprs : 1;
                int keyLen = this.numDistinctExprs > 0 ? this.numDistributionKeys + 1 : this.numDistributionKeys;
                this.cachedKeys = new Object[numKeys][keyLen];
                this.cachedValues = new Object[this.valueEval.length];
            }
            int keyHashCode = 0;
            if (this.partitionEval.length == 0) {
                if (this.random == null) {
                    this.random = new Random(12345L);
                }
                keyHashCode = this.random.nextInt();
            } else {
                for (i2 = 0; i2 < this.partitionEval.length; ++i2) {
                    Object o = this.partitionEval[i2].evaluate(row);
                    keyHashCode = keyHashCode * 31 + ObjectInspectorUtils.hashCode(o, this.partitionObjectInspectors[i2]);
                }
            }
            for (i2 = 0; i2 < this.valueEval.length; ++i2) {
                this.cachedValues[i2] = this.valueEval[i2].evaluate(row);
            }
            this.value = this.valueSerializer.serialize(this.cachedValues, this.valueObjectInspector);
            Object[] distributionKeys = new Object[this.numDistributionKeys];
            for (i = 0; i < this.numDistributionKeys; ++i) {
                distributionKeys[i] = this.keyEval[i].evaluate(row);
            }
            if (this.numDistinctExprs > 0) {
                for (i = 0; i < this.numDistinctExprs; ++i) {
                    System.arraycopy(distributionKeys, 0, this.cachedKeys[i], 0, this.numDistributionKeys);
                    Object[] distinctParameters = new Object[this.distinctColIndices.get(i).size()];
                    for (int j = 0; j < distinctParameters.length; ++j) {
                        distinctParameters[j] = this.keyEval[this.distinctColIndices.get(i).get(j)].evaluate(row);
                    }
                    this.cachedKeys[i][this.numDistributionKeys] = new StandardUnionObjectInspector.StandardUnion((byte)i, distinctParameters);
                }
            } else {
                System.arraycopy(distributionKeys, 0, this.cachedKeys[0], 0, this.numDistributionKeys);
            }
            for (i = 0; i < this.cachedKeys.length; ++i) {
                int keyLength;
                Text key;
                if (this.keyIsText) {
                    key = (Text)this.keySerializer.serialize(this.cachedKeys[i], this.keyObjectInspector);
                    if (tag == -1) {
                        this.keyWritable.set(key.getBytes(), 0, key.getLength());
                    } else {
                        keyLength = key.getLength();
                        this.keyWritable.setSize(keyLength + 1);
                        System.arraycopy(key.getBytes(), 0, this.keyWritable.get(), 0, keyLength);
                        this.keyWritable.get()[keyLength] = this.tagByte[0];
                    }
                } else {
                    key = (BytesWritable)this.keySerializer.serialize(this.cachedKeys[i], this.keyObjectInspector);
                    if (tag == -1) {
                        this.keyWritable.set(key.getBytes(), 0, key.getLength());
                    } else {
                        keyLength = key.getLength();
                        this.keyWritable.setSize(keyLength + 1);
                        System.arraycopy(key.getBytes(), 0, this.keyWritable.get(), 0, keyLength);
                        this.keyWritable.get()[keyLength] = this.tagByte[0];
                    }
                }
                this.keyWritable.setHashCode(keyHashCode);
                if (this.out == null) continue;
                this.out.collect((Object)this.keyWritable, (Object)this.value);
                if (this.counterNameToEnum == null) continue;
                ++this.outputRows;
                if (this.outputRows % 1000L != 0L) continue;
                this.incrCounter(numOutputRowsCntr, this.outputRows);
                this.outputRows = 0L;
            }
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    @Override
    public String getName() {
        return "RS";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.REDUCESINK;
    }
}

