/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties.charts;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import org.openide.ErrorManager;
import org.openide.nodes.PropertySupport;

public final class ImageEvaluationTimeProperty
extends PropertySupport {
    private final JRDesignDataset dataset;
    private final JRDesignChart element;
    private ComboBoxPropertyEditor editor;

    public ImageEvaluationTimeProperty(JRDesignChart element, JRDesignDataset dataset) {
        super("evaluationTime", EvaluationTimeEnum.class, I18n.getString("Evaluation_Time"), I18n.getString("When_the_image_expression_should_be_evaluated."), true, true);
        this.element = element;
        this.dataset = dataset;
        this.setValue(I18n.getString("suppressCustomEditor"), Boolean.TRUE);
    }

    public boolean isDefaultValue() {
        return this.element.getEvaluationTimeValue() == EvaluationTimeEnum.NOW;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setPropertyValue(EvaluationTimeEnum.NOW);
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            ArrayList<Tag> l = new ArrayList<Tag>();
            l.add(new Tag(EvaluationTimeEnum.NOW, I18n.getString("Now")));
            l.add(new Tag(EvaluationTimeEnum.REPORT, I18n.getString("Report")));
            l.add(new Tag(EvaluationTimeEnum.PAGE, I18n.getString("Page")));
            l.add(new Tag(EvaluationTimeEnum.COLUMN, I18n.getString("Column")));
            l.add(new Tag(EvaluationTimeEnum.GROUP, I18n.getString("Group")));
            l.add(new Tag(EvaluationTimeEnum.BAND, I18n.getString("Band")));
            l.add(new Tag(EvaluationTimeEnum.AUTO, I18n.getString("Auto")));
            this.editor = new ComboBoxPropertyEditor(false, l);
        }
        return this.editor;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.element.getEvaluationTimeValue();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val instanceof EvaluationTimeEnum) {
            this.setPropertyValue((EvaluationTimeEnum)val);
        }
    }

    private void setPropertyValue(EvaluationTimeEnum val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        EvaluationTimeEnum oldValue = this.element.getEvaluationTimeValue();
        EvaluationTimeEnum newValue = val;
        ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, I18n.getString("EvaluationTime"), EvaluationTimeEnum.class, oldValue, newValue);
        JRGroup oldGroupValue = this.element.getEvaluationGroup();
        JRGroup newGroupValue = null;
        if (val == EvaluationTimeEnum.GROUP) {
            if (this.dataset.getGroupsList().size() == 0) {
                IllegalArgumentException iae = this.annotateException(I18n.getString("No_groups_are_defined_to_be_used_with_this_element"));
                throw iae;
            }
            newGroupValue = (JRGroup)this.dataset.getGroupsList().get(0);
        }
        this.element.setEvaluationTime(newValue);
        if (oldGroupValue != newGroupValue) {
            ObjectPropertyUndoableEdit urobGroup = new ObjectPropertyUndoableEdit(this.element, I18n.getString("EvaluationGroup"), JRGroup.class, oldGroupValue, newGroupValue);
            this.element.setEvaluationGroup(newGroupValue);
            urob.concatenate(urobGroup);
        }
        IReportManager.getInstance().addUndoableEdit(urob);
    }

    public IllegalArgumentException annotateException(String msg) {
        IllegalArgumentException iae = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
        return iae;
    }
}

