/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.compatibility;

import com.jaspersoft.ireport.designer.IRLocalJasperReportsContext;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.compatibility.JRXmlWriter_3_5_0;
import com.jaspersoft.ireport.designer.compatibility.JRXmlWriter_3_5_1;
import com.jaspersoft.ireport.designer.compatibility.JRXmlWriter_3_5_2;
import com.jaspersoft.ireport.designer.compatibility.JRXmlWriter_3_6_0;
import com.jaspersoft.ireport.designer.compatibility.JRXmlWriter_3_6_1;
import com.jaspersoft.ireport.designer.compatibility.JRXmlWriter_3_6_2;
import com.jaspersoft.ireport.designer.compatibility.JRXmlWriter_3_7_1;
import com.jaspersoft.ireport.designer.compatibility.JRXmlWriter_3_7_3;
import com.jaspersoft.ireport.designer.compatibility.JRXmlWriter_3_7_4;
import com.jaspersoft.ireport.designer.compatibility.JRXmlWriter_4_0_1;
import com.jaspersoft.ireport.designer.compatibility.JRXmlWriter_4_5_0;
import com.jaspersoft.ireport.designer.compatibility.VersionWarningDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRXmlWriterHelper {
    private static final Map<String, Class> writers = new HashMap<String, Class>();
    private static VersionWarningDialog dialog;

    public static String writeReport(JRReport report, String encoding) throws Exception {
        JRXmlWriter writer = new JRXmlWriter((JasperReportsContext)IRLocalJasperReportsContext.getInstance());
        return writer.write(report, encoding);
    }

    public static String writeReport(JRReport report, String encoding, String version) throws Exception {
        JRXmlWriter writer = new JRXmlWriter((JasperReportsContext)IRLocalJasperReportsContext.getInstance());
        if (IReportManager.getPreferences().getBoolean("show_compatibility_warning", true)) {
            JRXmlWriterHelper.setDialog(null);
            JRXmlWriterHelper.getDialog().setVersion(version);
            if (SwingUtilities.isEventDispatchThread()) {
                JRXmlWriterHelper.getDialog().setVisible(true);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JRXmlWriterHelper.getDialog().setVisible(true);
                    }
                });
            }
            int res = JRXmlWriterHelper.getDialog().getDialogResult();
            if (!JRXmlWriterHelper.getDialog().askAgain()) {
                IReportManager.getPreferences().putBoolean("show_compatibility_warning", false);
            }
            if (res == VersionWarningDialog.DIALOG_RESULT_USE_LAST_VERSION) {
                version = "";
            }
        }
        if (writers.containsKey(version)) {
            Class clazz = writers.get(version);
            return (String)clazz.getMethod("writeReport", JRReport.class, String.class).invoke(null, report, encoding);
        }
        if (version.length() == 0) {
            return JRXmlWriter.writeReport((JRReport)report, (String)encoding);
        }
        throw new Exception("XML writer for version " + version + " not found.");
    }

    public static VersionWarningDialog getDialog() {
        if (dialog == null) {
            Runnable run = new Runnable(){

                public void run() {
                    JRXmlWriterHelper.setDialog(new VersionWarningDialog(Misc.getMainFrame(), true));
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(run);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return dialog;
    }

    public static void setDialog(VersionWarningDialog dlg) {
        dialog = dlg;
    }

    static {
        writers.put("4_5_0", JRXmlWriter_4_5_0.class);
        writers.put("4_0_1", JRXmlWriter_4_0_1.class);
        writers.put("3_7_4", JRXmlWriter_3_7_4.class);
        writers.put("3_7_3", JRXmlWriter_3_7_3.class);
        writers.put("3_7_1", JRXmlWriter_3_7_1.class);
        writers.put("3_6_2", JRXmlWriter_3_6_2.class);
        writers.put("3_6_1", JRXmlWriter_3_6_1.class);
        writers.put("3_6_0", JRXmlWriter_3_6_0.class);
        writers.put("3_5_2", JRXmlWriter_3_5_2.class);
        writers.put("3_5_1", JRXmlWriter_3_5_1.class);
        writers.put("3_5_0", JRXmlWriter_3_5_0.class);
        dialog = null;
    }
}

