/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class HiveLockObject {
    String[] pathNames = null;
    private HiveLockObjectData data;

    public HiveLockObject() {
        this.data = null;
    }

    public HiveLockObject(String path, HiveLockObjectData lockData) {
        this.pathNames = new String[1];
        this.pathNames[0] = path;
        this.data = lockData;
    }

    public HiveLockObject(String[] paths, HiveLockObjectData lockData) {
        this.pathNames = paths;
        this.data = lockData;
    }

    public HiveLockObject(Table tbl, HiveLockObjectData lockData) {
        this(new String[]{tbl.getDbName(), tbl.getTableName()}, lockData);
    }

    public HiveLockObject(Partition par, HiveLockObjectData lockData) {
        this(new String[]{par.getTable().getDbName(), par.getTable().getTableName(), par.getName()}, lockData);
    }

    public HiveLockObject(DummyPartition par, HiveLockObjectData lockData) {
        this(new String[]{par.getName()}, lockData);
    }

    public String getName() {
        if (this.pathNames == null) {
            return null;
        }
        String ret = "";
        boolean first = true;
        for (int i = 0; i < this.pathNames.length; ++i) {
            if (!first) {
                ret = ret + "/";
            } else {
                first = false;
            }
            ret = ret + this.pathNames[i];
        }
        return ret;
    }

    public String getDisplayName() {
        if (this.pathNames == null) {
            return null;
        }
        if (this.pathNames.length == 1) {
            return this.pathNames[0];
        }
        if (this.pathNames.length == 2) {
            return this.pathNames[0] + "@" + this.pathNames[1];
        }
        String ret = this.pathNames[0] + "@" + this.pathNames[1] + "@";
        boolean first = true;
        for (int i = 2; i < this.pathNames.length; ++i) {
            if (!first) {
                ret = ret + "/";
            } else {
                first = false;
            }
            ret = ret + this.pathNames[i];
        }
        return ret;
    }

    public HiveLockObjectData getData() {
        return this.data;
    }

    public void setData(HiveLockObjectData data) {
        this.data = data;
    }

    public static class HiveLockObjectData {
        private String queryId;
        private String lockTime;
        private String lockMode;
        private String queryStr;
        private String clientIp;

        public HiveLockObjectData(String queryId, String lockTime, String lockMode, String queryStr) {
            this.queryId = queryId;
            this.lockTime = lockTime;
            this.lockMode = lockMode;
            this.queryStr = queryStr.trim();
        }

        public HiveLockObjectData(String data) {
            if (data == null) {
                return;
            }
            String[] elem = data.split(":");
            this.queryId = elem[0];
            this.lockTime = elem[1];
            this.lockMode = elem[2];
            this.queryStr = elem[3];
        }

        public String getQueryId() {
            return this.queryId;
        }

        public String getLockTime() {
            return this.lockTime;
        }

        public String getLockMode() {
            return this.lockMode;
        }

        public String getQueryStr() {
            return this.queryStr;
        }

        public String toString() {
            return this.queryId + ":" + this.lockTime + ":" + this.lockMode + ":" + this.queryStr + ":" + this.clientIp;
        }

        public String getClientIp() {
            return this.clientIp;
        }

        public void setClientIp(String clientIp) {
            this.clientIp = clientIp;
        }
    }
}

