/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb;

import com.jaspersoft.mongodb.query.MongoDbQueryWrapper;
import com.mongodb.DBObject;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.log4j.Logger;

public class MongoDbDataSource
implements JRDataSource {
    private MongoDbQueryWrapper wrapper;
    private DBObject currentDbObject;
    public static final String QUERY_LANGUAGE = "MongoDbQuery";
    private static final Logger logger = Logger.getLogger(MongoDbDataSource.class);
    private boolean hasIterator = false;
    private boolean hasCommandResult = false;
    private Iterator<?> resultsIterator;
    private Map<?, ?> currentResult;

    public MongoDbDataSource(MongoDbQueryWrapper wrapper) {
        logger.info((Object)"New MongoDB Data Source");
        this.wrapper = wrapper;
        boolean bl = this.hasIterator = wrapper.iterator != null;
        if (!this.hasIterator) {
            this.hasCommandResult = wrapper.commandResults != null;
            this.resultsIterator = wrapper.commandResults.iterator();
        }
    }

    public Object getFieldValue(JRField field) throws JRException {
        block5: {
            try {
                if (field.getName() != null) break block5;
                return null;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new JRException(e.getMessage());
            }
        }
        String[] ids = field.getName().split("\\.");
        if (this.hasIterator) {
            return this.getCursorValue(ids);
        }
        if (this.hasCommandResult) {
            return this.getCommandResult(ids);
        }
        return null;
    }

    private Object getCommandResult(String[] ids) {
        Map currentMap = this.currentResult;
        int index = 0;
        while (index < ids.length) {
            boolean isLast = index == ids.length - 1;
            String id = ids[index];
            Object currentFieldObject = currentMap.get(id);
            if (currentFieldObject == null) {
                return null;
            }
            if (currentFieldObject instanceof Map) {
                if (isLast) {
                    return currentFieldObject;
                }
            } else {
                if (isLast) {
                    return currentFieldObject;
                }
                return null;
            }
            currentMap = (Map)currentFieldObject;
            ++index;
        }
        return null;
    }

    private Object getCursorValue(String[] ids) {
        DBObject fieldObject = this.currentDbObject;
        int index = 0;
        while (index < ids.length) {
            boolean isLast = index == ids.length - 1;
            String id = ids[index];
            Object currentFieldObject = fieldObject.get(id);
            if (currentFieldObject == null) {
                return null;
            }
            if (currentFieldObject instanceof DBObject) {
                if (isLast) {
                    return currentFieldObject;
                }
            } else {
                if (isLast) {
                    return currentFieldObject;
                }
                return null;
            }
            fieldObject = (DBObject)currentFieldObject;
            ++index;
        }
        return null;
    }

    public boolean next() throws JRException {
        boolean next = false;
        if (this.hasIterator && (next = this.wrapper.iterator.hasNext())) {
            this.currentDbObject = this.wrapper.iterator.next();
        } else if (this.hasCommandResult) {
            next = this.resultsIterator.hasNext();
            this.currentResult = null;
            if (next) {
                this.currentResult = (Map)this.resultsIterator.next();
            }
        }
        return next;
    }
}

