/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.provider;

import java.awt.Color;
import java.awt.Font;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.print.provider.ComponentDocument;
import org.netbeans.modules.print.provider.ComponentProvider;
import org.netbeans.modules.print.util.Config;
import org.openide.cookies.EditorCookie;
import org.openide.text.AttributedCharacters;

public final class TextProvider
extends ComponentProvider {
    private EditorCookie myEditor;
    private static final int MAX_LENGTH = 64000;

    public TextProvider(EditorCookie editorCookie, Date date) {
        super(null, TextProvider.getName(editorCookie), date);
        this.myEditor = editorCookie;
    }

    protected JComponent getComponent() {
        int n;
        int n2;
        JTextComponent jTextComponent = this.getTextComponent();
        if (jTextComponent == null) {
            return null;
        }
        if (Config.getDefault().isAsEditor()) {
            return jTextComponent;
        }
        StyledDocument styledDocument = this.myEditor.getDocument();
        if (styledDocument == null) {
            return null;
        }
        if (Config.getDefault().isSelection()) {
            n2 = jTextComponent.getSelectionStart();
            n = jTextComponent.getSelectionEnd();
        } else {
            n2 = 0;
            n = styledDocument.getLength();
        }
        int n3 = n - n2;
        if (styledDocument instanceof BaseDocument && n3 < 64000) {
            PrintContainer printContainer = new PrintContainer();
            ((BaseDocument)styledDocument).print((org.netbeans.editor.PrintContainer)printContainer, false, true, n2, n);
            return new ComponentDocument(printContainer.getIterators());
        }
        try {
            return new ComponentDocument(jTextComponent.getText(n2, n3));
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private JTextComponent getTextComponent() {
        JEditorPane[] jEditorPaneArray = this.myEditor.getOpenedPanes();
        if (jEditorPaneArray != null && jEditorPaneArray.length != 0) {
            return jEditorPaneArray[0];
        }
        return null;
    }

    private static String getName(EditorCookie editorCookie) {
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return null;
        }
        return ((String)styledDocument.getProperty("title")).replace('\\', '/');
    }

    private static final class PrintContainer
    implements org.netbeans.editor.PrintContainer {
        private List<AttributedCharacters> myCharactersList;
        private AttributedCharacters myCharacters = new AttributedCharacters();

        PrintContainer() {
            this.myCharactersList = new ArrayList<AttributedCharacters>();
        }

        public void add(char[] cArray, Font font, Color color, Color color2) {
            this.myCharacters.append(cArray, font, color);
        }

        public void eol() {
            this.myCharactersList.add(this.myCharacters);
            this.myCharacters = new AttributedCharacters();
        }

        public boolean initEmptyLines() {
            return false;
        }

        AttributedCharacterIterator[] getIterators() {
            AttributedCharacterIterator[] attributedCharacterIteratorArray = new AttributedCharacterIterator[this.myCharactersList.size()];
            for (int i = 0; i < this.myCharactersList.size(); ++i) {
                attributedCharacterIteratorArray[i] = this.myCharactersList.get(i).iterator();
            }
            return attributedCharacterIteratorArray;
        }
    }
}

