/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar;

import java.awt.GraphicsEnvironment;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import net.sf.jasperreports.components.BaseElementHtmlHandler;
import net.sf.jasperreports.components.headertoolbar.HeaderToolbarElementUtils;
import net.sf.jasperreports.components.headertoolbar.actions.EditColumnHeaderData;
import net.sf.jasperreports.components.headertoolbar.actions.EditColumnValueData;
import net.sf.jasperreports.components.headertoolbar.actions.FilterAction;
import net.sf.jasperreports.components.headertoolbar.actions.SortAction;
import net.sf.jasperreports.components.sort.FieldFilter;
import net.sf.jasperreports.components.sort.FilterTypeBooleanOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypeDateOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypeNumericOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypeTextOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypesEnum;
import net.sf.jasperreports.components.sort.actions.FilterData;
import net.sf.jasperreports.components.sort.actions.SortData;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.DatasetFilter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRIdentifiable;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.base.JRBasePrintHyperlink;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.export.JRXhtmlExporter;
import net.sf.jasperreports.engine.type.JREnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.MessageProvider;
import net.sf.jasperreports.engine.util.MessageUtil;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.web.commands.CommandTarget;
import net.sf.jasperreports.web.util.JacksonUtil;
import net.sf.jasperreports.web.util.VelocityUtil;
import net.sf.jasperreports.web.util.WebUtil;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class HeaderToolbarElementHtmlHandler
extends BaseElementHtmlHandler {
    private static final String DEFAULT_DATE_PATTERN_BUNDLE = "net.sf.jasperreports.components.messages";
    private static final String DEFAULT_DATE_PATTERN_KEY = "net.sf.jasperreports.components.date.pattern";
    private static final String DEFAULT_CALENDAR_DATE_PATTERN_KEY = "net.sf.jasperreports.components.calendar.date.pattern";
    private static final String DATE_PATTERN_BUNDLE = "net.sf.jasperreports.components.date.pattern.bundle";
    private static final String DATE_PATTERN_KEY = "net.sf.jasperreports.components.date.pattern.key";
    private static final String CALENDAR_DATE_PATTERN_BUNDLE = "net.sf.jasperreports.components.calendar.date.pattern.bundle";
    private static final String CALENDAR_DATE_PATTERN_KEY = "net.sf.jasperreports.components.calendar.date.pattern.key";
    private static final String RESOURCE_HEADERTOOLBAR_JS = "net/sf/jasperreports/components/headertoolbar/resources/jive.js";
    private static final String RESOURCE_HEADERTOOLBAR_CSS = "net/sf/jasperreports/components/headertoolbar/resources/jive.vm.css";
    private static final String RESOURCE_JIVE_COLUMN_JS = "net/sf/jasperreports/components/headertoolbar/resources/jive.interactive.column.js";
    private static final String RESOURCE_JIVE_COLUMN_I18N_JS = "net/sf/jasperreports/components/headertoolbar/resources/jive.interactive.column.i18n.vm.js";
    private static final String CSS_FILTER_DISABLED = "filterBtnDisabled";
    private static final String CSS_FILTER_DEFAULT = "filterBtnDefault";
    private static final String CSS_FILTER_DEFAULT_HOVER = "filterBtnDefaultHover";
    private static final String CSS_FILTER_ENABLED = "filterBtnEnabled";
    private static final String CSS_FILTER_ENABLED_HOVER = "filterBtnEnabledHover";
    private static final String CSS_FILTER_WRONG = "filterBtnWrong";
    private static final String CSS_FILTER_WRONG_HOVER = "filterBtnWrongHover";
    private static final String CSS_SORT_DEFAULT_ASC = "sortAscBtnDefault";
    private static final String CSS_SORT_DEFAULT_ASC_HOVER = "sortAscBtnDefaultHover";
    private static final String CSS_SORT_ENABLED_ASC = "sortAscBtnEnabled";
    private static final String CSS_SORT_ENABLED_ASC_HOVER = "sortAscBtnEnabledHover";
    private static final String CSS_SORT_DEFAULT_DESC = "sortDescBtnDefault";
    private static final String CSS_SORT_DEFAULT_DESC_HOVER = "sortDescBtnDefaultHover";
    private static final String CSS_SORT_ENABLED_DESC = "sortDescBtnEnabled";
    private static final String CSS_SORT_ENABLED_DESC_HOVER = "sortDescBtnEnabledHover";
    private static final String SORT_ELEMENT_HTML_TEMPLATE = "net/sf/jasperreports/components/headertoolbar/resources/HeaderToolbarElementHtmlTemplate.vm";
    private static final String PARAM_GENERATED_TEMPLATE_PREFIX = "net.sf.jasperreports.headertoolbar.";
    private static final List<String> datePatterns = new ArrayList<String>();
    private static final Map<String, String> numberPatternsMap = new LinkedHashMap<String, String>();
    private static final CustomJRExporterParameter param;

    @Override
    public String getHtmlFragment(JRHtmlExporterContext context, JRGenericPrintElement element) {
        boolean templateAlreadyLoaded = false;
        String htmlFragment = null;
        String tableUUID = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.tableUUID");
        ReportContext reportContext = context.getExporter().getReportContext();
        if (reportContext != null && tableUUID != null) {
            Map<String, ColumnInfo> columnNames;
            String popupId = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.popupId");
            String columnLabel = (String)element.getParameterValue("sortColumnLabel");
            int columnIndex = Integer.parseInt(element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.columnIndex"));
            HashMap<String, Object> contextMap = new HashMap<String, Object>();
            contextMap.put("JRStringUtil", JRStringUtil.class);
            contextMap.put("tableUUID", tableUUID);
            JasperReportsContext jrContext = context.getJasperReportsContext();
            WebUtil webUtil = WebUtil.getInstance(jrContext);
            String webResourcesBasePath = webUtil.getResourcesBasePath();
            Locale locale = (Locale)reportContext.getParameterValue("REPORT_LOCALE");
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if (reportContext.getParameterValue(PARAM_GENERATED_TEMPLATE_PREFIX) != null) {
                templateAlreadyLoaded = true;
            } else {
                reportContext.setParameterValue(PARAM_GENERATED_TEMPLATE_PREFIX, true);
                contextMap.put("actionBaseUrl", this.getActionBaseUrl(context));
                contextMap.put("actionBaseData", this.getActionBaseJsonData(context));
                contextMap.put("jasperreports_tableHeaderToolbar_js", webUtil.getResourcePath(webResourcesBasePath, RESOURCE_HEADERTOOLBAR_JS));
                contextMap.put("jasperreports_tableHeaderToolbar_css", webUtil.getResourcePath(webResourcesBasePath, RESOURCE_HEADERTOOLBAR_CSS, true));
                contextMap.put("jiveColumnScript", webUtil.getResourcePath(webResourcesBasePath, RESOURCE_JIVE_COLUMN_JS));
                contextMap.put("jiveColumnI18n_js", webUtil.getResourcePath(webResourcesBasePath, RESOURCE_JIVE_COLUMN_I18N_JS, "net.sf.jasperreports.components.headertoolbar.messages", locale));
                contextMap.put("msgProvider", MessageUtil.getInstance(jrContext).getLocalizedMessageProvider("net.sf.jasperreports.components.headertoolbar.messages", locale));
            }
            if (!(context.getExportParameters().containsKey(param) && tableUUID.equals(context.getExportParameters().get(param)) || (columnNames = this.getAllColumnNames(element, jrContext, contextMap)).isEmpty())) {
                context.getExportParameters().put(param, tableUUID);
                contextMap.put("allColumnNames", JacksonUtil.getInstance(jrContext).getJsonString(columnNames));
                contextMap.put("exporterFirstAttempt", true);
            }
            contextMap.put("templateAlreadyLoaded", templateAlreadyLoaded);
            Boolean canSort = Boolean.parseBoolean(element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.can.sort"));
            if (element.getModeValue() == ModeEnum.OPAQUE) {
                contextMap.put("backgroundColor", JRColorUtil.getColorHexa(element.getBackcolor()));
            }
            contextMap.put("elementX", ((JRXhtmlExporter)context.getExporter()).toSizeUnit(element.getX()));
            contextMap.put("elementY", ((JRXhtmlExporter)context.getExporter()).toSizeUnit(element.getY()));
            contextMap.put("elementWidth", element.getWidth());
            contextMap.put("elementHeight", element.getHeight());
            contextMap.put("popupId", popupId);
            contextMap.put("columnLabel", columnLabel);
            contextMap.put("columnIndex", columnIndex);
            contextMap.put("canSort", canSort);
            contextMap.put("fontExtensionsFontNames", this.getFontExtensionsFontNames());
            contextMap.put("systemFontNames", this.getSystemFontNames());
            this.setColumnHeaderData(columnLabel, columnIndex, tableUUID, contextMap, jrContext, reportContext);
            this.setColumnValueData(columnLabel, columnIndex, tableUUID, contextMap, jrContext, reportContext);
            if (canSort.booleanValue()) {
                String sortField;
                String columnName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.sortColumnName");
                String columnType = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.sortColumnType");
                FilterTypesEnum filterType = FilterTypesEnum.getByName(element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.filter.type"));
                if (filterType == null) {
                    return null;
                }
                String filterPattern = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.filter.pattern");
                String calendarPattern = null;
                if (filterPattern == null) {
                    filterPattern = "";
                }
                Map<String, String> translatedOperators = null;
                LinkedHashMap<String, String> valuesFormatPatternMap = new LinkedHashMap();
                Boolean hasPattern = true;
                Boolean isNumeric = false;
                String formatPatternLabel = "";
                switch (filterType) {
                    case NUMERIC: {
                        translatedOperators = this.getTranslatedOperators(jrContext, FilterTypeNumericOperatorsEnum.class.getName(), FilterTypeNumericOperatorsEnum.values(), locale);
                        valuesFormatPatternMap = numberPatternsMap;
                        formatPatternLabel = "Number pattern:";
                        isNumeric = true;
                        break;
                    }
                    case DATE: {
                        String calendarDatePatternKey;
                        String datePatternKey;
                        translatedOperators = this.getTranslatedOperators(jrContext, FilterTypeDateOperatorsEnum.class.getName(), FilterTypeDateOperatorsEnum.values(), locale);
                        this.setDatePatterns(valuesFormatPatternMap, datePatterns, locale);
                        formatPatternLabel = "Date pattern:";
                        String datePatternBundleName = JRPropertiesUtil.getInstance(jrContext).getProperty(DATE_PATTERN_BUNDLE);
                        if (datePatternBundleName == null) {
                            datePatternBundleName = DEFAULT_DATE_PATTERN_BUNDLE;
                        }
                        if ((datePatternKey = JRPropertiesUtil.getInstance(jrContext).getProperty(DATE_PATTERN_KEY)) == null) {
                            datePatternKey = DEFAULT_DATE_PATTERN_KEY;
                        }
                        filterPattern = this.getBundleMessage(datePatternKey, jrContext, datePatternBundleName, locale);
                        String calendarDatePatternBundleName = JRPropertiesUtil.getInstance(jrContext).getProperty(CALENDAR_DATE_PATTERN_BUNDLE);
                        if (calendarDatePatternBundleName == null) {
                            calendarDatePatternBundleName = DEFAULT_DATE_PATTERN_BUNDLE;
                        }
                        if ((calendarDatePatternKey = JRPropertiesUtil.getInstance(jrContext).getProperty(CALENDAR_DATE_PATTERN_KEY)) == null) {
                            calendarDatePatternKey = DEFAULT_CALENDAR_DATE_PATTERN_KEY;
                        }
                        calendarPattern = this.getBundleMessage(calendarDatePatternKey, jrContext, calendarDatePatternBundleName, locale);
                        break;
                    }
                    case TEXT: {
                        translatedOperators = this.getTranslatedOperators(jrContext, FilterTypeTextOperatorsEnum.class.getName(), FilterTypeTextOperatorsEnum.values(), locale);
                        hasPattern = false;
                        break;
                    }
                    case BOOLEAN: {
                        translatedOperators = this.getTranslatedOperators(jrContext, FilterTypeBooleanOperatorsEnum.class.getName(), FilterTypeBooleanOperatorsEnum.values(), locale);
                        hasPattern = false;
                    }
                }
                SortData sortAscData = new SortData(tableUUID, columnName, columnType, "Asc");
                SortData sortDescData = new SortData(tableUUID, columnName, columnType, "Dsc");
                String sortAscActive = CSS_SORT_DEFAULT_ASC;
                String sortAscHover = CSS_SORT_DEFAULT_ASC_HOVER;
                String sortDescActive = CSS_SORT_DEFAULT_DESC;
                String sortDescHover = CSS_SORT_DEFAULT_DESC_HOVER;
                String filterActive = CSS_FILTER_DISABLED;
                String filterHover = "";
                if (filterType != null) {
                    filterActive = CSS_FILTER_DEFAULT;
                    filterHover = CSS_FILTER_DEFAULT_HOVER;
                }
                if ((sortField = this.getCurrentSortField(jrContext, reportContext, tableUUID, columnName, columnType)) != null) {
                    String[] sortActionData = HeaderToolbarElementUtils.extractColumnInfo(sortField);
                    boolean isAscending = "Asc".equals(sortActionData[2]);
                    if (isAscending) {
                        sortAscData.setSortOrder("None");
                        sortAscActive = CSS_SORT_ENABLED_ASC;
                        sortAscHover = CSS_SORT_ENABLED_ASC_HOVER;
                    } else {
                        sortDescData.setSortOrder("None");
                        sortDescActive = CSS_SORT_ENABLED_DESC;
                        sortDescHover = CSS_SORT_ENABLED_DESC_HOVER;
                    }
                }
                String filterValueStart = "";
                String filterValueEnd = "";
                String filterTypeOperatorValue = "";
                List<DatasetFilter> fieldFilters = this.getExistingFiltersForField(jrContext, reportContext, tableUUID, columnName);
                if (fieldFilters.size() > 0) {
                    FieldFilter ff = (FieldFilter)fieldFilters.get(0);
                    if (ff.getFilterValueStart() != null) {
                        filterValueStart = ff.getFilterValueStart();
                    }
                    if (ff.getFilterValueEnd() != null) {
                        filterValueEnd = ff.getFilterValueEnd();
                    }
                    filterTypeOperatorValue = ff.getFilterTypeOperator();
                    if (ff.getIsValid() != null && !ff.getIsValid().booleanValue()) {
                        filterActive = CSS_FILTER_WRONG;
                        filterHover = CSS_FILTER_WRONG_HOVER;
                    } else {
                        filterActive = CSS_FILTER_ENABLED;
                        filterHover = CSS_FILTER_ENABLED_HOVER;
                    }
                }
                contextMap.put("hasPattern", hasPattern);
                contextMap.put("isNumeric", isNumeric);
                if (hasPattern.booleanValue()) {
                    contextMap.put("formatPatternLabel", formatPatternLabel);
                    contextMap.put("valuesFormatPatternMap", valuesFormatPatternMap);
                }
                FilterData filterData = new FilterData();
                filterData.setTableUuid(tableUUID);
                filterData.setFieldName(columnName);
                filterData.setFilterType(filterType.getName());
                filterData.setFilterPattern(filterPattern);
                filterData.setCalendarPattern(calendarPattern);
                filterData.setFieldValueStart(filterValueStart);
                filterData.setFieldValueEnd(filterValueEnd);
                filterData.setFilterTypeOperator(filterTypeOperatorValue);
                contextMap.put("filterData", JacksonUtil.getInstance(jrContext).getJsonString(filterData));
                contextMap.put("filterTypeValuesMap", translatedOperators);
                contextMap.put("filterTypeOperatorValue", filterTypeOperatorValue);
                contextMap.put("filterTableUuid", tableUUID);
                contextMap.put("filterColumnNameLabel", columnLabel != null ? columnLabel : "");
                contextMap.put("sortAscData", JacksonUtil.getInstance(jrContext).getJsonString(sortAscData));
                contextMap.put("sortDescData", JacksonUtil.getInstance(jrContext).getJsonString(sortDescData));
                contextMap.put("sortAscActive", sortAscActive);
                contextMap.put("sortAscHover", sortAscHover);
                contextMap.put("sortDescActive", sortDescActive);
                contextMap.put("sortDescHover", sortDescHover);
                contextMap.put("filterActive", filterActive);
                contextMap.put("filterHover", filterHover);
            }
            htmlFragment = VelocityUtil.processTemplate(SORT_ELEMENT_HTML_TEMPLATE, contextMap);
        }
        return htmlFragment;
    }

    private void setDatePatterns(Map<String, String> valuesFormatPatternMap, List<String> datePatterns, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", locale);
        Date today = new Date();
        for (String datePattern : datePatterns) {
            sdf.applyPattern(datePattern);
            valuesFormatPatternMap.put(datePattern, sdf.format(today));
        }
    }

    private String getActionBaseUrl(JRHtmlExporterContext context) {
        JRBasePrintHyperlink hyperlink = new JRBasePrintHyperlink();
        hyperlink.setLinkType("ReportInteraction");
        return context.getHyperlinkURL(hyperlink);
    }

    private String getActionBaseJsonData(JRHtmlExporterContext context) {
        ReportContext reportContext = context.getExporter().getReportContext();
        HashMap<String, Object> actionParams = new HashMap<String, Object>();
        actionParams.put("jr.ctxid", reportContext.getId());
        String runReportParamName = JRPropertiesUtil.getInstance(context.getJasperReportsContext()).getProperty("net.sf.jasperreports.web.request.parameter.run.report");
        actionParams.put(runReportParamName, true);
        return JacksonUtil.getInstance(context.getJasperReportsContext()).getJsonString(actionParams);
    }

    private String getCurrentSortField(JasperReportsContext jasperReportsContext, ReportContext reportContext, String uuid, String sortColumnName, String sortColumnType) {
        JasperDesignCache cache = JasperDesignCache.getInstance(jasperReportsContext, reportContext);
        SortAction action = new SortAction();
        action.init(jasperReportsContext, reportContext);
        CommandTarget target = action.getCommandTarget(UUID.fromString(uuid));
        if (target != null) {
            JRIdentifiable identifiable = target.getIdentifiable();
            JRDesignComponentElement componentElement = identifiable instanceof JRDesignComponentElement ? (JRDesignComponentElement)identifiable : null;
            StandardTable table = componentElement == null ? null : (StandardTable)componentElement.getComponent();
            JRDesignDatasetRun datasetRun = (JRDesignDatasetRun)table.getDatasetRun();
            String datasetName = datasetRun.getDatasetName();
            JasperDesign jasperDesign = cache.getJasperDesign(target.getUri());
            JRDesignDataset dataset = (JRDesignDataset)jasperDesign.getDatasetMap().get(datasetName);
            List<JRSortField> existingFields = dataset.getSortFieldsList();
            String sortField = null;
            if (existingFields != null && existingFields.size() > 0) {
                for (JRSortField field : existingFields) {
                    if (!field.getName().equals(sortColumnName) || !field.getType().getName().equals(sortColumnType)) continue;
                    sortField = sortColumnName + ":" + sortColumnType + ":";
                    switch (field.getOrderValue()) {
                        case ASCENDING: {
                            sortField = sortField + "Asc";
                            break;
                        }
                        case DESCENDING: {
                            sortField = sortField + "Dsc";
                        }
                    }
                    break;
                }
            }
            return sortField;
        }
        return null;
    }

    @Override
    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }

    private Map<String, String> getTranslatedOperators(JasperReportsContext jasperReportsContext, String bundleName, JREnum[] operators, Locale locale) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        MessageProvider messageProvider = MessageUtil.getInstance(jasperReportsContext).getMessageProvider(bundleName);
        for (JREnum operator : operators) {
            String key = bundleName + "." + ((Enum)((Object)operator)).name();
            result.put(((Enum)((Object)operator)).name(), messageProvider.getMessage(key, null, locale));
        }
        return result;
    }

    private List<DatasetFilter> getExistingFiltersForField(JasperReportsContext jasperReportsContext, ReportContext reportContext, String uuid, String filterFieldName) {
        JasperDesignCache cache = JasperDesignCache.getInstance(jasperReportsContext, reportContext);
        FilterAction action = new FilterAction();
        action.init(jasperReportsContext, reportContext);
        CommandTarget target = action.getCommandTarget(UUID.fromString(uuid));
        ArrayList<DatasetFilter> result = new ArrayList<DatasetFilter>();
        if (target != null) {
            JRIdentifiable identifiable = target.getIdentifiable();
            JRDesignComponentElement componentElement = identifiable instanceof JRDesignComponentElement ? (JRDesignComponentElement)identifiable : null;
            StandardTable table = componentElement == null ? null : (StandardTable)componentElement.getComponent();
            JRDesignDatasetRun datasetRun = (JRDesignDatasetRun)table.getDatasetRun();
            String datasetName = datasetRun.getDatasetName();
            JasperDesign jasperDesign = cache.getJasperDesign(target.getUri());
            JRDesignDataset dataset = (JRDesignDataset)jasperDesign.getDatasetMap().get(datasetName);
            String serializedFilters = "[]";
            JRPropertiesMap propertiesMap = dataset.getPropertiesMap();
            if (propertiesMap.getProperty("net.sf.jasperreports.filters") != null) {
                serializedFilters = propertiesMap.getProperty("net.sf.jasperreports.filters");
            }
            ObjectMapper mapper = new ObjectMapper();
            List existingFilters = null;
            try {
                existingFilters = (List)mapper.readValue(serializedFilters, (TypeReference)new TypeReference<List<FieldFilter>>(){});
            }
            catch (Exception e) {
                throw new JRRuntimeException(e);
            }
            if (existingFilters.size() > 0) {
                for (DatasetFilter filter : existingFilters) {
                    if (!((FieldFilter)filter).getField().equals(filterFieldName)) continue;
                    result.add(filter);
                    break;
                }
            }
        }
        return result;
    }

    private void setColumnHeaderData(String sortColumnLabel, Integer columnIndex, String tableUuid, Map<String, Object> contextMap, JasperReportsContext jasperReportsContext, ReportContext reportContext) {
        FilterAction action = new FilterAction();
        action.init(jasperReportsContext, reportContext);
        CommandTarget target = action.getCommandTarget(UUID.fromString(tableUuid));
        EditColumnHeaderData colHeaderData = new EditColumnHeaderData();
        if (target != null) {
            StandardColumn column;
            JRDesignTextElement textElement;
            JRIdentifiable identifiable = target.getIdentifiable();
            JRDesignComponentElement componentElement = identifiable instanceof JRDesignComponentElement ? (JRDesignComponentElement)identifiable : null;
            StandardTable table = componentElement == null ? null : (StandardTable)componentElement.getComponent();
            List<BaseColumn> tableColumns = TableUtil.getAllColumns(table);
            if (columnIndex != null && (textElement = TableUtil.getColumnHeaderTextElement(column = (StandardColumn)tableColumns.get(columnIndex))) != null) {
                colHeaderData.setHeadingName(JRStringUtil.escapeJavaScript(sortColumnLabel));
                colHeaderData.setColumnIndex(columnIndex);
                colHeaderData.setTableUuid(tableUuid);
                colHeaderData.setFontName(textElement.getFontName());
                colHeaderData.setFontSize(textElement.getFontSize());
                colHeaderData.setFontBold(textElement.isBold());
                colHeaderData.setFontItalic(textElement.isItalic());
                colHeaderData.setFontUnderline(textElement.isUnderline());
                colHeaderData.setFontColor(JRColorUtil.getColorHexa(textElement.getForecolor()));
                colHeaderData.setFontHAlign(textElement.getHorizontalAlignmentValue().getName());
            }
        }
        contextMap.put("colHeaderData", JacksonUtil.getInstance(jasperReportsContext).getJsonString(colHeaderData));
    }

    private void setColumnValueData(String sortColumnLabel, Integer columnIndex, String tableUuid, Map<String, Object> contextMap, JasperReportsContext jasperReportsContext, ReportContext reportContext) {
        FilterAction action = new FilterAction();
        action.init(jasperReportsContext, reportContext);
        CommandTarget target = action.getCommandTarget(UUID.fromString(tableUuid));
        EditColumnValueData colValueData = new EditColumnValueData();
        if (target != null) {
            StandardColumn column;
            JRDesignTextField textElement;
            JRIdentifiable identifiable = target.getIdentifiable();
            JRDesignComponentElement componentElement = identifiable instanceof JRDesignComponentElement ? (JRDesignComponentElement)identifiable : null;
            StandardTable table = componentElement == null ? null : (StandardTable)componentElement.getComponent();
            List<BaseColumn> tableColumns = TableUtil.getAllColumns(table);
            if (columnIndex != null && (textElement = (JRDesignTextField)TableUtil.getColumnDetailTextElement(column = (StandardColumn)tableColumns.get(columnIndex))) != null) {
                colValueData.setHeadingName(JRStringUtil.escapeJavaScript(sortColumnLabel));
                colValueData.setColumnIndex(columnIndex);
                colValueData.setTableUuid(tableUuid);
                colValueData.setFontName(textElement.getFontName());
                colValueData.setFontSize(textElement.getFontSize());
                colValueData.setFontBold(textElement.isBold());
                colValueData.setFontItalic(textElement.isItalic());
                colValueData.setFontUnderline(textElement.isUnderline());
                colValueData.setFontColor(JRColorUtil.getColorHexa(textElement.getForecolor()));
                colValueData.setFontHAlign(textElement.getHorizontalAlignmentValue().getName());
                colValueData.setFormatPattern(textElement.getPattern());
            }
        }
        contextMap.put("colValueData", JacksonUtil.getInstance(jasperReportsContext).getJsonString(colValueData));
    }

    private Map<String, ColumnInfo> getAllColumnNames(JRGenericPrintElement element, JasperReportsContext jasperReportsContext, Map<String, Object> contextMap) {
        int prefixLength = "column.".length();
        HashMap<String, ColumnInfo> columnNames = new HashMap<String, ColumnInfo>();
        for (String paramName : element.getParameterNames()) {
            if (!paramName.startsWith("column.")) continue;
            String columnName = (String)element.getParameterValue(paramName);
            String[] tokens = paramName.substring(prefixLength).split("\\|");
            if (columnName == null || columnName.trim().length() == 0) {
                columnName = "Column_" + tokens[0];
            }
            columnNames.put(tokens[0], new ColumnInfo(tokens[0], columnName, tokens[1], false));
        }
        return columnNames;
    }

    private Set<String> getFontExtensionsFontNames() {
        TreeSet<String> classes = new TreeSet<String>();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Collection<String> extensionFonts = JRFontUtil.getFontFamilyNames();
        for (String fname : extensionFonts) {
            classes.add(fname);
        }
        Thread.currentThread().setContextClassLoader(oldCL);
        return classes;
    }

    private Set<String> getSystemFontNames() {
        Set<String> fontExtensionsFontNames = this.getFontExtensionsFontNames();
        TreeSet<String> classes = new TreeSet<String>();
        String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (!fontExtensionsFontNames.add(name)) continue;
            classes.add(name);
        }
        return classes;
    }

    private String getBundleMessage(String key, JasperReportsContext jasperReportsContext, String bundleName, Locale locale) {
        MessageProvider messageProvider = MessageUtil.getInstance(jasperReportsContext).getMessageProvider(bundleName);
        return messageProvider.getMessage(key, null, locale);
    }

    static {
        datePatterns.add("dd/MM/yyyy");
        datePatterns.add("MM/dd/yyyy");
        datePatterns.add("yyyy/MM/dd");
        datePatterns.add("EEEEE dd MMMMM yyyy");
        datePatterns.add("MMMMM dd. yyyy");
        datePatterns.add("dd/MM");
        datePatterns.add("dd/MM/yy");
        datePatterns.add("dd-MMM");
        datePatterns.add("dd-MMM-yy");
        datePatterns.add("MMM-yy");
        datePatterns.add("MMMMM-yy");
        datePatterns.add("dd/MM/yyyy h.mm a");
        datePatterns.add("dd/MM/yyyy HH.mm.ss");
        datePatterns.add("MMM");
        datePatterns.add("d/M/yyyy");
        datePatterns.add("dd-MMM-yyyy");
        datePatterns.add("yyyy.MM.dd G 'at' HH:mm:ss z");
        datePatterns.add("EEE. MMM d. ''yy");
        datePatterns.add("yyyy.MMMMM.dd GGG hh:mm aaa");
        datePatterns.add("EEE. d MMM yyyy HH:mm:ss Z");
        datePatterns.add("yyMMddHHmmssZ");
        numberPatternsMap.put("###0;-###0", "-1234");
        numberPatternsMap.put("###0;###0-", "1234-");
        numberPatternsMap.put("###0;(###0)", "(1234)");
        numberPatternsMap.put("###0;(-###0)", "(-1234)");
        numberPatternsMap.put("###0;(###0-)", "(1234-)");
        param = new CustomJRExporterParameter("exporter_first_attempt");
    }

    public static class ColumnInfo {
        private String index;
        private String label;
        private String uuid;
        private boolean enabled;

        private ColumnInfo(String index, String label, String uuid, boolean enabled) {
            this.index = index;
            this.label = label;
            this.uuid = uuid;
            this.enabled = enabled;
        }

        public String getIndex() {
            return this.index;
        }

        public String getLabel() {
            return this.label;
        }

        public String getUuid() {
            return this.uuid;
        }

        public boolean getEnabled() {
            return this.enabled;
        }
    }

    private static class CustomJRExporterParameter
    extends JRExporterParameter {
        protected CustomJRExporterParameter(String name) {
            super(name);
        }
    }
}

