/*
 * Decompiled with CFR 0.152.
 */
package rex.olap.mdxparse;

import java.util.ArrayList;
import rex.olap.mdxparse.Exp;
import rex.olap.mdxparse.ExpVisitor;

public class CompoundId
implements Exp {
    private ArrayList names = new ArrayList();

    public CompoundId(String name, boolean isKey) {
        this.names.add(new NamePart(name, isKey));
    }

    public CompoundId(String name) {
        this(name, false);
    }

    public void append(String name, boolean isKey) {
        this.names.add(new NamePart(name, isKey));
    }

    public void append(String name) {
        this.names.add(new NamePart(name, false));
    }

    public String[] toStringArray() {
        String[] ret = new String[this.names.size()];
        int i = 0;
        for (NamePart np : this.names) {
            ret[i++] = np.name;
        }
        return ret;
    }

    @Override
    public String toMdx() {
        String str = "";
        boolean isFollow = false;
        for (NamePart np : this.names) {
            if (isFollow) {
                str = str + ".";
            }
            isFollow = true;
            str = str + np.name;
        }
        return str;
    }

    private CompoundId() {
    }

    @Override
    public Object clone() {
        CompoundId cloned = new CompoundId();
        for (NamePart np : this.names) {
            cloned.append(np.name, np.isKey);
        }
        return cloned;
    }

    @Override
    public void accept(ExpVisitor visitor) {
        visitor.visitCompoundId(this);
    }

    private class NamePart {
        private String name;
        private boolean isKey;

        protected NamePart(String name, boolean isKey) {
            this.name = name;
            this.isKey = isKey;
        }
    }
}

