/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBForeignKey;
import org.netbeans.modules.db.dataview.meta.DBModel;
import org.netbeans.modules.db.dataview.meta.DBObject;
import org.netbeans.modules.db.dataview.meta.DBPrimaryKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBTable
extends DBObject<DBModel> {
    private static final String FQ_TBL_NAME_SEPARATOR = ".";
    private String catalog;
    private Map<String, DBColumn> columns = new LinkedHashMap<String, DBColumn>();
    private Map<String, DBForeignKey> foreignKeys = new HashMap<String, DBForeignKey>();
    private String name;
    private DBPrimaryKey primaryKey;
    private String schema;
    private SQLIdentifiers.Quoter quoter;

    public DBTable(String string, String string2, String string3) {
        this.name = string != null ? string.trim() : null;
        this.schema = string2 != null ? string2.trim() : null;
        this.catalog = string3 != null ? string3.trim() : null;
    }

    public synchronized boolean addColumn(DBColumn dBColumn) {
        if (dBColumn != null) {
            dBColumn.setParentObject(this);
            this.columns.put(dBColumn.getName() + dBColumn.getOrdinalPosition(), dBColumn);
            return true;
        }
        return false;
    }

    public int compareTo(Object object) {
        String string;
        if (object == null) {
            return -1;
        }
        if (object == this) {
            return 0;
        }
        DBModel dBModel = (DBModel)this.getParentObject();
        String string2 = dBModel != null ? dBModel.getFullyQualifiedTableName((DBTable)object) : ((DBTable)object).getName();
        String string3 = string = dBModel != null ? dBModel.getFullyQualifiedTableName(this) : this.name;
        return string != null ? string.compareTo(string2) : (string2 != null ? 1 : -1);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            return true;
        }
        if (!(object instanceof DBTable)) {
            return false;
        }
        bl = super.equals(object);
        if (!bl) {
            return bl;
        }
        if (object instanceof DBTable) {
            Collection<Object> collection;
            DBTable dBTable = (DBTable)object;
            String string = dBTable.getName();
            Map<String, DBColumn> map = dBTable.getColumns();
            DBPrimaryKey dBPrimaryKey = dBTable.primaryKey;
            List<DBForeignKey> list = dBTable.getForeignKeys();
            bl &= string != null && this.name != null && this.name.equals(string);
            if (this.columns != null && map != null) {
                collection = map.keySet();
                Set<String> set = this.columns.keySet();
                bl &= set.containsAll(collection) && collection.containsAll(set);
            } else if (this.columns != null || map != null) {
                bl = false;
            }
            bl &= this.primaryKey != null ? this.primaryKey.equals(dBPrimaryKey) : dBPrimaryKey == null;
            if (this.foreignKeys != null && list != null) {
                collection = this.foreignKeys.values();
                bl &= collection.containsAll(list) && list.containsAll(collection);
            } else if (this.foreignKeys != null || list != null) {
                bl = false;
            }
        }
        return bl;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public SQLIdentifiers.Quoter getQuoter() {
        return this.quoter;
    }

    void setQuoter(SQLIdentifiers.Quoter quoter) {
        this.quoter = quoter;
    }

    public List<DBColumn> getColumnList() {
        ArrayList<DBColumn> arrayList = new ArrayList<DBColumn>();
        arrayList.addAll(this.columns.values());
        Collections.sort(arrayList, new ColumnOrderComparator());
        return arrayList;
    }

    public Map<String, DBColumn> getColumns() {
        return this.columns;
    }

    @Override
    public String getDisplayName() {
        return this.getFullyQualifiedName();
    }

    public List<DBForeignKey> getForeignKeys() {
        return new ArrayList<DBForeignKey>(this.foreignKeys.values());
    }

    public String getFullyQualifiedName() {
        StringBuilder stringBuilder = new StringBuilder(50);
        if (this.catalog != null && this.catalog.trim().length() != 0) {
            stringBuilder.append(this.quoter.quoteIfNeeded(this.catalog.trim()));
            stringBuilder.append(FQ_TBL_NAME_SEPARATOR);
        }
        if (this.schema != null && this.schema.trim().length() != 0) {
            stringBuilder.append(this.quoter.quoteIfNeeded(this.schema.trim()));
            stringBuilder.append(FQ_TBL_NAME_SEPARATOR);
        }
        if (this.quoter != null) {
            stringBuilder.append(this.quoter.quoteIfNeeded(this.name.trim()));
        } else {
            stringBuilder.append(this.name);
        }
        return stringBuilder.toString();
    }

    public String getQualifiedName() {
        if (this.quoter != null) {
            return this.quoter.quoteIfNeeded(this.name.trim());
        }
        return this.name.trim();
    }

    public String getName() {
        return this.name;
    }

    public DBPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public String getSchema() {
        return this.schema;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = this.name != null ? this.name.hashCode() : 0;
        n += this.schema != null ? this.schema.hashCode() : 0;
        n += this.catalog != null ? this.catalog.hashCode() : 0;
        if (this.columns != null) {
            n += ((Object)this.columns.keySet()).hashCode();
        }
        if (this.primaryKey != null) {
            n += this.primaryKey.hashCode();
        }
        if (this.foreignKeys != null) {
            n += ((Object)this.foreignKeys.keySet()).hashCode();
        }
        return n += this.displayName != null ? this.displayName.hashCode() : 0;
    }

    public void setName(String string) {
        this.name = string;
        this.setDisplayName(string);
    }

    public void setCatalogName(String string) {
        this.catalog = string;
    }

    public void setSchemaName(String string) {
        this.schema = string;
    }

    boolean setPrimaryKey(DBPrimaryKey dBPrimaryKey) {
        if (dBPrimaryKey != null) {
            dBPrimaryKey.setParentObject(this);
        }
        this.primaryKey = dBPrimaryKey;
        return true;
    }

    void setForeignKeyMap(Map<String, DBForeignKey> map) {
        this.foreignKeys = map;
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ColumnOrderComparator
    implements Comparator<DBColumn> {
        private ColumnOrderComparator() {
        }

        @Override
        public int compare(DBColumn dBColumn, DBColumn dBColumn2) {
            return dBColumn.getOrdinalPosition() - dBColumn2.getOrdinalPosition();
        }
    }
}

