/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.util.ThreadLocalStack;
import net.sf.jasperreports.repo.InputStreamResource;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.repo.ReportResource;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;

public final class RepositoryUtil {
    private static ThreadLocalStack localContextStack = new ThreadLocalStack();
    private static final ThreadLocal<ReportContext> threadReportContext = new InheritableThreadLocal<ReportContext>();
    private AtomicReference<List<RepositoryService>> repositoryServices = new AtomicReference();
    private JasperReportsContext jasperReportsContext;

    private RepositoryUtil(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    private static RepositoryUtil getDefaultInstance() {
        return new RepositoryUtil(DefaultJasperReportsContext.getInstance());
    }

    public static RepositoryUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new RepositoryUtil(jasperReportsContext);
    }

    private List<RepositoryService> getServices() {
        List<RepositoryService> cachedServices = this.repositoryServices.get();
        if (cachedServices != null) {
            return cachedServices;
        }
        List<RepositoryService> services = this.jasperReportsContext.getExtensions(RepositoryService.class);
        if (this.repositoryServices.compareAndSet(null, services)) {
            return services;
        }
        return this.repositoryServices.get();
    }

    public static List<RepositoryService> getRepositoryServices() {
        return RepositoryUtil.getDefaultInstance().getServices();
    }

    public static void setRepositoryContext(RepositoryContext context) {
        List<RepositoryService> services = RepositoryUtil.getRepositoryServices();
        if (services != null) {
            for (RepositoryService service : services) {
                service.setContext(context);
            }
        }
        localContextStack.push(context);
    }

    public static void revertRepositoryContext() {
        List<RepositoryService> services = RepositoryUtil.getRepositoryServices();
        if (services != null) {
            for (RepositoryService service : services) {
                service.revertContext();
            }
        }
        localContextStack.pop();
    }

    public static ReportContext getThreadReportContext() {
        return threadReportContext.get();
    }

    public static void setThreadReportContext(ReportContext reportContext) {
        threadReportContext.set(reportContext);
    }

    public static void resetThreadReportContext() {
        threadReportContext.set(null);
    }

    public JasperReport getReport(ReportContext reportContext, String location) throws JRException {
        JasperReport jasperReport = null;
        JasperDesignCache cache = JasperDesignCache.getInstance(this.jasperReportsContext, reportContext);
        if (cache != null) {
            jasperReport = cache.getJasperReport(location);
        }
        if (jasperReport == null) {
            ReportResource resource = this.getResourceFromLocation(location, ReportResource.class);
            if (resource == null) {
                throw new JRException("Report not found at : " + location);
            }
            jasperReport = resource.getReport();
            if (cache != null) {
                cache.set(location, jasperReport);
            }
        }
        return jasperReport;
    }

    public static JasperReport getReport(String location) throws JRException {
        return RepositoryUtil.getDefaultInstance().getReport(RepositoryUtil.getThreadReportContext(), location);
    }

    public <K extends Resource> K getResourceFromLocation(String location, Class<K> resourceType) throws JRException {
        K resource = null;
        List<RepositoryService> services = this.getServices();
        if (services != null) {
            RepositoryService service;
            Iterator<RepositoryService> i$ = services.iterator();
            while (i$.hasNext() && (resource = (K)(service = i$.next()).getResource(location, resourceType)) == null) {
            }
        }
        if (resource == null) {
            throw new JRException("Resource not found at : " + location);
        }
        return resource;
    }

    public static <K extends Resource> K getResource(String location, Class<K> resourceType) throws JRException {
        return RepositoryUtil.getDefaultInstance().getResourceFromLocation(location, resourceType);
    }

    public InputStream getInputStreamFromLocation(String location) throws JRException {
        InputStream is = this.findInputStream(location);
        if (is == null) {
            throw new JRException("Input stream not found at : " + location);
        }
        return is;
    }

    public static InputStream getInputStream(String location) throws JRException {
        return RepositoryUtil.getDefaultInstance().getInputStreamFromLocation(location);
    }

    private InputStream findInputStream(String location) throws JRException {
        InputStreamResource inputStreamResource;
        block1: {
            RepositoryService service;
            inputStreamResource = null;
            List<RepositoryService> services = this.getServices();
            if (services == null) break block1;
            Iterator<RepositoryService> i$ = services.iterator();
            while (i$.hasNext() && (inputStreamResource = (service = i$.next()).getResource(location, InputStreamResource.class)) == null) {
            }
        }
        return inputStreamResource == null ? null : inputStreamResource.getInputStream();
    }

    public byte[] getBytesFromLocation(String location) throws JRException {
        InputStream is = this.findInputStream(location);
        if (is == null) {
            throw new JRException("Byte data not found at : " + location);
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
        }
        catch (IOException e) {
            throw new JRException("Error loading byte data from : " + location, e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return baos.toByteArray();
    }

    public static byte[] getBytes(String location) throws JRException {
        return RepositoryUtil.getDefaultInstance().getBytesFromLocation(location);
    }
}

