/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTNode
extends ASTItem {
    private String nt;
    private Map<String, ASTItem> nameToChild = null;

    public static ASTNode createCompoundASTNode(Language language, String string, List<ASTItem> list, int n) {
        return new CompoundNode(language, string, n, list);
    }

    public static ASTNode create(Language language, String string, List<ASTItem> list, int n) {
        return new ASTNode(language, string, n, list);
    }

    public static ASTNode create(Language language, String string, int n) {
        return new ASTNode(language, string, n, Collections.<ASTItem>emptyList());
    }

    private ASTNode(Language language, String string, int n, List<ASTItem> list) {
        super(language, n, -1, list);
        if (!this.getClass().equals(ASTNode.class) && !this.getClass().equals(CompoundNode.class)) {
            throw new IllegalArgumentException("Do not extend ASTNode!");
        }
        this.nt = string;
    }

    public String getNT() {
        return this.nt;
    }

    public ASTNode findNode(String string, int n) {
        if (string.equals(this.getNT())) {
            return this;
        }
        for (ASTItem aSTItem : this.getChildren()) {
            ASTNode aSTNode;
            if (!(aSTItem instanceof ASTNode) || (aSTNode = (ASTNode)aSTItem).getOffset() > n || n >= aSTNode.getEndOffset()) continue;
            return aSTNode.findNode(string, n);
        }
        return null;
    }

    public String getTokenTypeIdentifier(String string) {
        ASTToken aSTToken = this.getTokenType(string);
        if (aSTToken == null) {
            return null;
        }
        return aSTToken.getIdentifier();
    }

    public ASTToken getTokenType(String string) {
        ASTNode aSTNode = this;
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            aSTNode = this.getNode(string.substring(0, n));
        }
        if (aSTNode == null) {
            return null;
        }
        Object object = aSTNode.getChild("token-type-" + string.substring(n + 1));
        if (object == null) {
            return null;
        }
        if (!(object instanceof ASTToken)) {
            return null;
        }
        return (ASTToken)object;
    }

    public ASTNode getNode(String string) {
        ASTNode aSTNode = this;
        int n = 0;
        int n2 = string.indexOf(46);
        while (n2 >= 0) {
            if ((aSTNode = (ASTNode)aSTNode.getChild("node-" + string.substring(n, n2))) == null) {
                return null;
            }
            n = n2 + 1;
            n2 = string.indexOf(46, n);
        }
        return (ASTNode)aSTNode.getChild("node-" + string.substring(n));
    }

    @Override
    public void addChildren(ASTItem aSTItem) {
        super.addChildren(aSTItem);
        if (this.nameToChild != null) {
            if (aSTItem instanceof ASTToken) {
                ASTToken aSTToken = (ASTToken)aSTItem;
                this.nameToChild.put("token-type-" + aSTToken.getTypeName(), aSTToken);
            } else {
                this.nameToChild.put("node-" + ((ASTNode)aSTItem).getNT(), aSTItem);
            }
        }
    }

    @Override
    public void removeChildren(ASTItem aSTItem) {
        super.removeChildren(aSTItem);
        if (this.nameToChild != null) {
            if (aSTItem instanceof ASTToken) {
                ASTToken aSTToken = (ASTToken)aSTItem;
                this.nameToChild.remove("token-type-" + aSTToken.getTypeName());
            } else {
                this.nameToChild.remove("node-" + ((ASTNode)aSTItem).getNT());
            }
        }
    }

    @Override
    public void setChildren(int n, ASTItem aSTItem) {
        ASTToken aSTToken;
        ASTItem aSTItem2 = this.getChildren().get(n);
        if (this.nameToChild != null) {
            if (aSTItem2 instanceof ASTToken) {
                aSTToken = (ASTToken)aSTItem2;
                this.nameToChild.remove("token-type-" + aSTToken.getTypeName());
            } else {
                this.nameToChild.remove("node-" + ((ASTNode)aSTItem2).getNT());
            }
        }
        super.setChildren(n, aSTItem);
        if (this.nameToChild != null) {
            if (aSTItem instanceof ASTToken) {
                aSTToken = (ASTToken)aSTItem;
                this.nameToChild.put("token-type-" + aSTToken.getTypeName(), aSTItem);
            } else {
                this.nameToChild.put("node-" + ((ASTNode)aSTItem).getNT(), aSTItem);
            }
        }
    }

    private Object getChild(String string) {
        if (this.nameToChild == null) {
            this.nameToChild = new HashMap<String, ASTItem>();
            for (ASTItem aSTItem : this.getChildren()) {
                if (aSTItem instanceof ASTToken) {
                    ASTToken aSTToken = (ASTToken)aSTItem;
                    this.nameToChild.put("token-type-" + aSTToken.getTypeName(), aSTToken);
                    continue;
                }
                this.nameToChild.put("node-" + ((ASTNode)aSTItem).getNT(), aSTItem);
            }
        }
        return this.nameToChild.get(string);
    }

    public String print() {
        return this.print("");
    }

    private String print(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("ASTNode ").append(this.getNT()).append(' ').append(this.getOffset()).append('-').append(this.getEndOffset());
        string = "  " + string;
        for (ASTItem aSTItem : this.getChildren()) {
            if (aSTItem instanceof ASTNode) {
                stringBuilder.append('\n').append(((ASTNode)aSTItem).print(string));
                continue;
            }
            stringBuilder.append('\n').append(string).append(aSTItem);
        }
        return stringBuilder.toString();
    }

    public String getAsText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ASTItem aSTItem : this.getChildren()) {
            if (aSTItem instanceof ASTNode) {
                stringBuilder.append(((ASTNode)aSTItem).getAsText());
                continue;
            }
            stringBuilder.append(((ASTToken)aSTItem).getIdentifier());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ASTNode ").append(this.getNT()).append(' ').append(this.getOffset()).append('-').append(this.getEndOffset());
        for (ASTItem aSTItem : this.getChildren()) {
            if (aSTItem instanceof ASTNode) {
                stringBuilder.append("\n    ").append(((ASTNode)aSTItem).getNT() + "...");
                continue;
            }
            stringBuilder.append("\n    ").append(aSTItem);
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompoundNode
    extends ASTNode {
        CompoundNode(Language language, String string, int n, List<ASTItem> list) {
            super(language, string, n, list);
        }

        @Override
        public ASTPath findPath(int n) {
            ASTPath aSTPath = null;
            for (ASTItem aSTItem : this.getChildren()) {
                if (n >= aSTItem.getEndOffset() || aSTItem.getOffset() > n) continue;
                ArrayList<ASTItem> arrayList = new ArrayList<ASTItem>();
                arrayList.add(this);
                ASTPath aSTPath2 = aSTItem.findPath(arrayList, n);
                if (aSTPath != null && aSTPath2.getLeaf().getLength() >= aSTPath.getLeaf().getLength()) continue;
                aSTPath = aSTPath2;
            }
            if (aSTPath == null) {
                aSTPath = ASTPath.create(this);
            }
            return aSTPath;
        }
    }
}

