/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.xml.xam.AbstractModel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.spi.ModelAccessProvider;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelFactory<M extends Model> {
    public static final int DELAY_SYNCER = 2000;
    public static final int DELAY_DIRTY = 1000;
    public static final String MODEL_LOADED_PROPERTY = "modelLoaded";
    private WeakHashMap<Object, WeakReference<M>> cachedModels = new WeakHashMap();
    private PropertyChangeSupport propSupport;
    private static List<WeakReference<AbstractModelFactory>> factories = new ArrayList<WeakReference<AbstractModelFactory>>();
    private static RequestProcessor.Task SYNCER = null;

    public AbstractModelFactory() {
        factories.add(new WeakReference<AbstractModelFactory>(this));
        this.propSupport = new PropertyChangeSupport(this);
    }

    protected abstract M createModel(ModelSource var1);

    public M createFreshModel(ModelSource modelSource) {
        M m = this.createModel(modelSource);
        try {
            if (m != null) {
                m.sync();
                this.propSupport.firePropertyChange(MODEL_LOADED_PROPERTY, null, m);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Sync has errors", iOException);
        }
        return m;
    }

    protected Object getKey(ModelSource modelSource) {
        ModelAccessProvider modelAccessProvider = this.getEffectiveAccessProvider(modelSource);
        if (modelAccessProvider != null) {
            return modelAccessProvider.getModelSourceKey(modelSource);
        }
        return (File)modelSource.getLookup().lookup(File.class);
    }

    private ModelAccessProvider getEffectiveAccessProvider(ModelSource modelSource) {
        ModelAccessProvider modelAccessProvider = (ModelAccessProvider)modelSource.getLookup().lookup(ModelAccessProvider.class);
        return modelAccessProvider == null ? AbstractModelFactory.getAccessProvider() : modelAccessProvider;
    }

    public static ModelAccessProvider getAccessProvider() {
        return (ModelAccessProvider)Lookup.getDefault().lookup(ModelAccessProvider.class);
    }

    protected synchronized M getModel(ModelSource modelSource) {
        Model<Object> model;
        if (modelSource == null) {
            return null;
        }
        Object object = this.getKey(modelSource);
        assert (object != null);
        WeakReference<M> weakReference = this.cachedModels.get(object);
        Model model2 = model = weakReference == null ? null : (Model)weakReference.get();
        if (model == null && (model = this.createModel(modelSource)) != null) {
            try {
                model.sync();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Sync has errors", iOException);
            }
            this.cachedModels.put(object, new WeakReference<Model<Object>>(model));
            this.propSupport.firePropertyChange(MODEL_LOADED_PROPERTY, null, model);
        }
        return (M)model;
    }

    private static synchronized List<AbstractModel> getAllModels() {
        ArrayList<AbstractModel> arrayList = new ArrayList<AbstractModel>();
        ArrayList<WeakReference<AbstractModelFactory>> arrayList2 = new ArrayList<WeakReference<AbstractModelFactory>>(factories);
        for (WeakReference weakReference : arrayList2) {
            AbstractModelFactory abstractModelFactory = (AbstractModelFactory)weakReference.get();
            if (abstractModelFactory == null) continue;
            for (Object m : abstractModelFactory.getModels()) {
                if (!(m instanceof AbstractModel)) continue;
                AbstractModel abstractModel = (AbstractModel)m;
                arrayList.add(abstractModel);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<M> getModels() {
        ArrayList<WeakReference<M>> arrayList;
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList<WeakReference<M>>(this.cachedModels.values());
        }
        object = new ArrayList();
        for (WeakReference weakReference : arrayList) {
            Model model;
            if (weakReference == null || (model = (Model)weakReference.get()) == null) continue;
            object.add(model);
        }
        return object;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    static {
        if (AbstractModelFactory.getAccessProvider() != null) {
            SYNCER = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        for (AbstractModel abstractModel : AbstractModelFactory.getAllModels()) {
                            if (!abstractModel.isAutoSyncActive() || abstractModel.getAccess().dirtyIntervalMillis() <= 1000L) continue;
                            abstractModel.runAutoSync();
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "auto-sync", exception);
                    }
                    SYNCER.schedule(2000);
                }
            }, 2000);
        }
    }
}

