/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.sheet.GenericProperty;
import com.jaspersoft.ireport.designer.sheet.editors.JRPropertiesMapPropertyEditor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.openide.nodes.PropertySupport;

public class PropertyExpressionsProperty
extends PropertySupport {
    PropertyEditor editor = null;
    JRDesignElement element = null;

    public PropertyExpressionsProperty(JRDesignElement element, JRDesignDataset dataset) {
        super("properties", List.class, "Properties expressions", "List of property expressions for this element", true, true);
        this.setValue("canEditAsText", Boolean.FALSE);
        this.setValue("useList", Boolean.TRUE);
        this.setValue("canUseExpression", Boolean.TRUE);
        this.setValue("EXPRESSION_CONTEXT", new ExpressionContext(dataset));
        if (element instanceof JRTextField) {
            this.setValue("hintType", 4);
        } else {
            this.setValue("hintType", 1);
        }
        this.element = element;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        JRPropertiesMap map = this.element.getPropertiesMap();
        ArrayList<GenericProperty> properties = new ArrayList<GenericProperty>();
        String[] names = map.getPropertyNames();
        for (int i = 0; i < names.length; ++i) {
            properties.add(new GenericProperty(names[i], map.getProperty(names[i])));
        }
        JRPropertyExpression[] expProperties = this.element.getPropertyExpressions();
        for (int i = 0; expProperties != null && i < expProperties.length; ++i) {
            properties.add(new GenericProperty(expProperties[i].getName(), (JRDesignExpression)expProperties[i].getValueExpression()));
        }
        return properties;
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!(val instanceof List)) {
            throw new IllegalArgumentException();
        }
        JRPropertiesMap map = new JRPropertiesMap();
        List values = (List)val;
        for (int i = 0; i < values.size(); ++i) {
            GenericProperty prop = (GenericProperty)values.get(i);
            if (prop.isUseExpression()) continue;
            map.setProperty(prop.getKey(), (String)prop.getValue());
        }
        ModelUtils.replacePropertiesMap(map, this.element.getPropertiesMap());
        ModelUtils.replaceExpressionProperties(this.element, values);
        IReportManager.getInstance().notifyReportChange();
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new JRPropertiesMapPropertyEditor();
        }
        return this.editor;
    }
}

