/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.refactoring;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.refactoring.RenameRefactoringUI;
import org.netbeans.modules.languages.refactoring.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    private static final String JS_MIME_TYPE = "text/javascript";

    public boolean canFindUsages(Lookup lookup) {
        return RefactoringActionsProvider.canRefactor(lookup);
    }

    public boolean canRename(Lookup lookup) {
        return RefactoringActionsProvider.canRefactor(lookup);
    }

    public void doFindUsages(Lookup lookup) {
        try {
            FileObject fileObject = RefactoringActionsProvider.getFileObject(lookup);
            Object[] objectArray = RefactoringActionsProvider.getASTPathAndDocument(lookup);
            ASTPath aSTPath = (ASTPath)objectArray[0];
            Document document = (Document)objectArray[1];
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            WhereUsedQueryUI whereUsedQueryUI = new WhereUsedQueryUI(aSTPath, fileObject, document);
            UI.openRefactoringUI((RefactoringUI)whereUsedQueryUI, (TopComponent)topComponent);
        }
        catch (ParseException parseException) {
            Logger.getLogger(RefactoringActionsProvider.class.getName()).log(Level.SEVERE, "Error parsing document", parseException);
        }
    }

    public void doRename(Lookup lookup) {
        try {
            FileObject fileObject = RefactoringActionsProvider.getFileObject(lookup);
            Object[] objectArray = RefactoringActionsProvider.getASTPathAndDocument(lookup);
            ASTPath aSTPath = (ASTPath)objectArray[0];
            Document document = (Document)objectArray[1];
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            RenameRefactoringUI renameRefactoringUI = new RenameRefactoringUI(aSTPath, fileObject, document);
            UI.openRefactoringUI((RefactoringUI)renameRefactoringUI, (TopComponent)topComponent);
        }
        catch (ParseException parseException) {
            Logger.getLogger(RefactoringActionsProvider.class.getName()).log(Level.SEVERE, "Error parsing document", parseException);
        }
    }

    private static FileObject getFileObject(Lookup lookup) {
        Node node = (Node)lookup.lookup(Node.class);
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        return dataObject.getPrimaryFile();
    }

    private static Object[] getASTPathAndDocument(Lookup lookup) throws ParseException {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        JEditorPane jEditorPane = editorCookie.getOpenedPanes()[0];
        NbEditorDocument nbEditorDocument = (NbEditorDocument)jEditorPane.getDocument();
        String string = jEditorPane.getSelectedText();
        ASTNode aSTNode = ParserManager.get((Document)nbEditorDocument).getAST();
        int n = 0;
        if (string != null) {
            n = jEditorPane.getSelectionStart();
            for (int i = 0; i < string.length() && Character.isWhitespace(string.charAt(i)); ++i) {
                ++n;
            }
        } else {
            n = jEditorPane.getCaretPosition();
        }
        return new Object[]{aSTNode.findPath(n), nbEditorDocument};
    }

    private static boolean canRefactor(Lookup lookup) {
        return false;
    }
}

