/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.hadoop.hive;

import com.jaspersoft.hadoop.hive.HiveDataSource;
import com.jaspersoft.hadoop.hive.connection.HiveConnection;
import com.jaspersoft.hadoop.hive.query.HiveParameter;
import com.jaspersoft.hadoop.hive.query.HiveQueryExecuter;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignField;

public class HiveFieldsProvider {
    private static HiveFieldsProvider instance;
    private static final Lock lock;

    private HiveFieldsProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HiveFieldsProvider getInstance() {
        lock.lock();
        try {
            if (instance == null) {
                instance = new HiveFieldsProvider();
            }
            HiveFieldsProvider hiveFieldsProvider = instance;
            return hiveFieldsProvider;
        }
        finally {
            lock.unlock();
        }
    }

    public JRField[] getFields(HiveConnection connection, JRDataset reportDataset, Map<String, Object> parameters) throws JRException, UnsupportedOperationException {
        HiveQueryExecuter queryExecuter = null;
        HiveDataSource datasource = null;
        try {
            HashMap<String, HiveParameter> newValueParameters = new HashMap<String, HiveParameter>();
            for (String parameterName : parameters.keySet()) {
                Object parameterValue = parameters.get(parameterName);
                HiveParameter newParameter = new HiveParameter(parameterName, parameterValue);
                newValueParameters.put(parameterName, newParameter);
            }
            parameters.clear();
            parameters.put("REPORT_CONNECTION", connection);
            newValueParameters.put("REPORT_PARAMETERS_MAP", new HiveParameter("REPORT_PARAMETERS_MAP", parameters));
            queryExecuter = new HiveQueryExecuter(reportDataset, newValueParameters);
            datasource = (HiveDataSource)queryExecuter.createDatasource();
            ResultSetMetaData resultSetMetaData = datasource.getResultSet().getMetaData();
            ArrayList<JRDesignField> columns = new ArrayList<JRDesignField>();
            for (int index = 1; index <= resultSetMetaData.getColumnCount(); ++index) {
                JRDesignField field = new JRDesignField();
                field.setName(resultSetMetaData.getColumnLabel(index));
                field.setValueClassName(HiveConnection.getJdbcTypeClass(resultSetMetaData, index));
                field.setDescription(null);
                columns.add(field);
            }
            JRField[] finalFields = new JRField[columns.size()];
            for (int index = 0; index < finalFields.length; ++index) {
                finalFields[index] = (JRField)columns.get(index);
            }
            JRField[] jRFieldArray = finalFields;
            return jRFieldArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        finally {
            if (queryExecuter != null) {
                queryExecuter.close();
            }
        }
    }

    static {
        lock = new ReentrantLock();
    }
}

