/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JToolTip;
import org.netbeans.modules.editor.completion.CompletionImpl;
import org.netbeans.modules.editor.completion.CompletionSpiPackageAccessor;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompletionResultSetImpl {
    private static final CompletionSpiPackageAccessor spi;
    private final CompletionImpl completionImpl;
    private final Object resultId;
    private final CompletionTask task;
    private final int queryType;
    private CompletionResultSet resultSet;
    private boolean active;
    private String title;
    private String waitText;
    private int anchorOffset;
    private List<CompletionItem> items;
    private boolean hasAdditionalItems;
    private String hasAdditionalItemsText;
    private boolean finished;
    private CompletionDocumentation documentation;
    private JToolTip toolTip;
    private int estimatedItemCount;
    private int estimatedItemWidth;

    CompletionResultSetImpl(CompletionImpl completionImpl, Object object, CompletionTask completionTask, int n) {
        assert (completionImpl != null);
        assert (object != null);
        assert (completionTask != null);
        this.completionImpl = completionImpl;
        this.resultId = object;
        this.task = completionTask;
        this.queryType = n;
        this.anchorOffset = -1;
        this.estimatedItemCount = -1;
        this.active = true;
        spi.createCompletionResultSet(this);
    }

    public synchronized CompletionResultSet getResultSet() {
        return this.resultSet;
    }

    public synchronized void setResultSet(CompletionResultSet completionResultSet) {
        assert (completionResultSet != null);
        assert (this.resultSet == null);
        this.resultSet = completionResultSet;
    }

    public CompletionTask getTask() {
        return this.task;
    }

    public int getQueryType() {
        return this.queryType;
    }

    public synchronized void markInactive() {
        this.active = false;
    }

    public synchronized String getTitle() {
        return this.title;
    }

    public synchronized void setTitle(String string) {
        this.checkNotFinished();
        this.title = string;
    }

    public synchronized int getAnchorOffset() {
        return this.anchorOffset;
    }

    public synchronized void setAnchorOffset(int n) {
        this.checkNotFinished();
        this.anchorOffset = n;
    }

    public synchronized boolean addItem(CompletionItem completionItem) {
        assert (completionItem != null) : "Added item cannot be null";
        this.checkNotFinished();
        if (!this.active || (this.queryType & 1) == 0) {
            return false;
        }
        if (this.items == null) {
            int n = this.estimatedItemCount == -1 ? 10 : this.estimatedItemCount;
            this.items = new ArrayList<CompletionItem>(n);
        }
        this.items.add(completionItem);
        return this.items.size() < 1000;
    }

    public boolean addAllItems(Collection<? extends CompletionItem> collection) {
        boolean bl = true;
        Iterator<? extends CompletionItem> iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl = this.addItem(iterator.next());
        }
        return bl;
    }

    public synchronized List<? extends CompletionItem> getItems() {
        assert (this.isFinished()) : "Adding not finished";
        return this.items != null ? this.items : Collections.emptyList();
    }

    public synchronized void setHasAdditionalItems(boolean bl) {
        this.checkNotFinished();
        if (this.queryType != 1) {
            return;
        }
        this.hasAdditionalItems = bl;
    }

    public synchronized boolean hasAdditionalItems() {
        return this.hasAdditionalItems;
    }

    public synchronized void setHasAdditionalItemsText(String string) {
        this.checkNotFinished();
        if (this.queryType != 1) {
            return;
        }
        this.hasAdditionalItemsText = string;
    }

    public synchronized String getHasAdditionalItemsText() {
        return this.hasAdditionalItemsText;
    }

    public synchronized void setDocumentation(CompletionDocumentation completionDocumentation) {
        this.checkNotFinished();
        if (!this.active || this.queryType != 2) {
            return;
        }
        this.documentation = completionDocumentation;
    }

    public synchronized CompletionDocumentation getDocumentation() {
        return this.documentation;
    }

    public synchronized JToolTip getToolTip() {
        return this.toolTip;
    }

    public synchronized void setToolTip(JToolTip jToolTip) {
        this.checkNotFinished();
        if (!this.active || this.queryType != 4) {
            return;
        }
        this.toolTip = jToolTip;
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        CompletionResultSetImpl completionResultSetImpl = this;
        synchronized (completionResultSetImpl) {
            if (this.finished) {
                throw new IllegalStateException("finish() already called");
            }
            this.finished = true;
        }
        this.completionImpl.finishNotify(this);
    }

    public int getSortType() {
        return this.completionImpl.getSortType();
    }

    public synchronized void estimateItems(int n, int n2) {
        this.estimatedItemCount = n;
        this.estimatedItemWidth = n2;
    }

    CompletionImpl getCompletionImpl() {
        return this.completionImpl;
    }

    Object getResultId() {
        return this.resultId;
    }

    private void checkNotFinished() {
        if (this.isFinished()) {
            throw new IllegalStateException("Result set already finished");
        }
    }

    public synchronized String getWaitText() {
        return this.waitText;
    }

    public synchronized void setWaitText(String string) {
        this.waitText = string;
    }

    static {
        try {
            Class.forName(CompletionResultSet.class.getName(), true, CompletionResultSetImpl.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        spi = CompletionSpiPackageAccessor.get();
    }
}

