/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRSubreportRunResult;
import net.sf.jasperreports.engine.fill.JRSubreportRunnable;
import net.sf.jasperreports.engine.fill.JRSubreportRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRThreadSubreportRunner
extends JRSubreportRunnable
implements JRSubreportRunner {
    private static final Log log = LogFactory.getLog(JRThreadSubreportRunner.class);
    private final JRBaseFiller subreportFiller;
    private Thread fillThread;

    public JRThreadSubreportRunner(JRFillSubreport fillSubreport, JRBaseFiller subreportFiller) {
        super(fillSubreport);
        this.subreportFiller = subreportFiller;
    }

    @Override
    public boolean isFilling() {
        return this.fillThread != null;
    }

    @Override
    public JRSubreportRunResult start() {
        this.fillThread = new Thread((Runnable)this, this.subreportFiller.getJasperReport().getName() + " subreport filler");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": starting thread " + this.fillThread));
        }
        this.fillThread.start();
        return this.waitResult();
    }

    @Override
    public JRSubreportRunResult resume() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": notifying to continue"));
        }
        this.subreportFiller.notifyAll();
        return this.waitResult();
    }

    protected JRSubreportRunResult waitResult() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": waiting for fill result"));
        }
        try {
            this.subreportFiller.wait();
        }
        catch (InterruptedException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Fill " + this.subreportFiller.fillerId + ": exception"), (Throwable)e);
            }
            throw new JRRuntimeException("Error encountered while waiting on the report filling thread.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": notified of fill result"));
        }
        return this.runResult();
    }

    @Override
    public void reset() {
        this.fillThread = null;
    }

    @Override
    public void cancel() throws JRException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": notifying to continue on cancel"));
        }
        this.subreportFiller.notifyAll();
        if (this.isRunning()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": still running, waiting"));
            }
            try {
                this.subreportFiller.wait();
            }
            catch (InterruptedException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Fill " + this.subreportFiller.fillerId + ": exception"), (Throwable)e);
                }
                throw new JRException("Error encountered while waiting on the subreport filling thread.", e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": wait ended"));
            }
        }
    }

    @Override
    public void suspend() throws JRException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": notifying on suspend"));
        }
        this.subreportFiller.notifyAll();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": waiting to continue"));
        }
        try {
            this.subreportFiller.wait();
        }
        catch (InterruptedException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Fill " + this.subreportFiller.fillerId + ": exception"), (Throwable)e);
            }
            throw new JRException("Error encountered while waiting on the subreport filling thread.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": notified to continue"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.run();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": notifying of completion"));
        }
        JRBaseFiller jRBaseFiller = this.subreportFiller;
        synchronized (jRBaseFiller) {
            this.subreportFiller.notifyAll();
        }
    }
}

