/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.components.map.MapPrintElement;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRTemplateGenericElement;
import net.sf.jasperreports.engine.fill.JRTemplateGenericPrintElement;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class MapFillComponent
extends BaseFillComponent {
    private final MapComponent mapComponent;
    private Float latitude;
    private Float longitude;
    private Integer zoom;

    public MapFillComponent(MapComponent map) {
        this.mapComponent = map;
    }

    protected MapComponent getMap() {
        return this.mapComponent;
    }

    @Override
    public void evaluate(byte evaluation) throws JRException {
        if (this.isEvaluateNow()) {
            this.evaluateMap(evaluation);
        }
    }

    protected void evaluateMap(byte evaluation) throws JRException {
        this.latitude = (Float)this.fillContext.evaluate(this.mapComponent.getLatitudeExpression(), evaluation);
        this.longitude = (Float)this.fillContext.evaluate(this.mapComponent.getLongitudeExpression(), evaluation);
        this.zoom = (Integer)this.fillContext.evaluate(this.mapComponent.getZoomExpression(), evaluation);
        this.zoom = this.zoom == null ? MapComponent.DEFAULT_ZOOM : this.zoom;
    }

    protected boolean isEvaluateNow() {
        return this.mapComponent.getEvaluationTime() == EvaluationTimeEnum.NOW;
    }

    @Override
    public FillPrepareResult prepare(int availableHeight) {
        return FillPrepareResult.PRINT_NO_STRETCH;
    }

    @Override
    public JRPrintElement fill() {
        JRComponentElement element = this.fillContext.getComponentElement();
        JRTemplateGenericElement template = new JRTemplateGenericElement(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider(), MapPrintElement.MAP_ELEMENT_TYPE);
        template = this.deduplicate(template);
        JRTemplateGenericPrintElement printElement = new JRTemplateGenericPrintElement(template, this.elementId);
        printElement.setX(element.getX());
        printElement.setY(this.fillContext.getElementPrintY());
        printElement.setWidth(element.getWidth());
        printElement.setHeight(element.getHeight());
        if (this.isEvaluateNow()) {
            this.copy(printElement);
        } else {
            this.fillContext.registerDelayedEvaluation(printElement, this.mapComponent.getEvaluationTime(), this.mapComponent.getEvaluationGroup());
        }
        return printElement;
    }

    @Override
    public void evaluateDelayedElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateMap(evaluation);
        this.copy((JRGenericPrintElement)element);
    }

    protected void copy(JRGenericPrintElement printElement) {
        printElement.setParameterValue("latitude", this.latitude);
        printElement.setParameterValue("longitude", this.longitude);
        printElement.setParameterValue("zoom", this.zoom);
    }
}

