/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

public class KeyUpdateCommand
extends DatanodeCommand {
    private ExportedBlockKeys keys;

    KeyUpdateCommand() {
        this(new ExportedBlockKeys());
    }

    public KeyUpdateCommand(ExportedBlockKeys keys) {
        super(7);
        this.keys = keys;
    }

    public ExportedBlockKeys getExportedKeys() {
        return this.keys;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.keys.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.keys.readFields(in);
    }

    static {
        WritableFactories.setFactory(KeyUpdateCommand.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new KeyUpdateCommand();
            }
        });
    }
}

