/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.ConstantCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.util.UnsupportedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HeadTailFunDef
extends FunDefBase {
    static final Resolver TailResolver = new ReflectiveMultiResolver("Tail", "Tail(<Set>[, <Count>])", "Returns a subset from the end of a set.", new String[]{"fxx", "fxxn"}, HeadTailFunDef.class);
    static final Resolver HeadResolver = new ReflectiveMultiResolver("Head", "Head(<Set>[, < Numeric Expression >])", "Returns the first specified number of elements in a set.", new String[]{"fxx", "fxxn"}, HeadTailFunDef.class);
    private final boolean head;

    public HeadTailFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
        this.head = dummyFunDef.getName().equals("Head");
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ConstantCalc integerCalc;
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        IntegerCalc integerCalc2 = integerCalc = call.getArgCount() > 1 ? compiler.compileInteger(call.getArg(1)) : ConstantCalc.constantInteger(1);
        if (this.head) {
            return new AbstractListCalc(call, new Calc[]{listCalc, integerCalc}){

                public List evaluateList(Evaluator evaluator) {
                    evaluator = evaluator.push(false);
                    List list = listCalc.evaluateList(evaluator);
                    int count = integerCalc.evaluateInteger(evaluator);
                    return HeadTailFunDef.head(count, list);
                }
            };
        }
        return new AbstractListCalc(call, new Calc[]{listCalc, integerCalc}){

            public List evaluateList(Evaluator evaluator) {
                evaluator = evaluator.push(false);
                List list = listCalc.evaluateList(evaluator);
                int count = integerCalc.evaluateInteger(evaluator);
                return HeadTailFunDef.tail(count, list);
            }
        };
    }

    static <T> List<T> tail(final int count, final List<T> members) {
        assert (members != null);
        final int memberCount = members.size();
        if (count >= memberCount) {
            return members;
        }
        if (count <= 0) {
            return Collections.emptyList();
        }
        return new UnsupportedList<T>(){

            @Override
            public boolean isEmpty() {
                return count == 0 || members.isEmpty();
            }

            @Override
            public int size() {
                return Math.min(count, members.size());
            }

            @Override
            public T get(int idx) {
                int index = idx + memberCount - count;
                return members.get(index);
            }

            @Override
            public Iterator<T> iterator() {
                return new UnsupportedList.Itr(this);
            }

            @Override
            public Object[] toArray() {
                int offset = memberCount - count;
                Object[] a = new Object[this.size()];
                for (int i = memberCount - count; i < memberCount; ++i) {
                    a[i - offset] = members.get(i);
                }
                return a;
            }
        };
    }

    static <T> List<T> head(final int count, final List<T> members) {
        assert (members != null);
        if (count <= 0) {
            return Collections.emptyList();
        }
        return new UnsupportedList<T>(){

            @Override
            public boolean isEmpty() {
                return count == 0 || members.isEmpty();
            }

            @Override
            public int size() {
                return Math.min(count, members.size());
            }

            @Override
            public T get(int index) {
                if (index >= count) {
                    throw new IndexOutOfBoundsException();
                }
                return members.get(index);
            }

            @Override
            public Iterator<T> iterator() {
                return new UnsupportedList.Itr(this);
            }

            @Override
            public Object[] toArray() {
                Object[] a = new Object[count];
                int i = 0;
                for (Object member : members) {
                    if (i >= a.length) {
                        return a;
                    }
                    a[i++] = member;
                }
                if (i < a.length) {
                    Object[] a0 = a;
                    a = new Object[i];
                    System.arraycopy(a0, 0, a, 0, i);
                }
                return a;
            }
        };
    }
}

